/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.ErrorReporter;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.Draggable;
import edu.hws.jcm.draw.DrawTemp;
import edu.hws.jcm.draw.Drawable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DisplayCanvas
extends Canvas
implements ErrorReporter,
InputObject,
Computable {
    private Vector coordinateRects;
    private boolean useOffscreenCanvas = true;
    private boolean handleMouseZooms = false;
    private Color errorBackground = new Color(220, 255, 220);
    private Color errorForeground = new Color(0, 120, 0);
    private String errorMessage;
    private Controller errorSource;
    private Draggable dragged;
    private transient boolean dragging;
    private transient boolean draggingZoomWindow;
    private transient CRData draggingInRect;
    private transient int dragXmax;
    private transient int dragXmin;
    private transient int dragYmax;
    private transient int dragYmin;
    private transient int lastX;
    private transient int lastY;
    private transient int startX;
    private transient int startY;
    private transient Image OSC;
    private transient Graphics OSG;
    private transient boolean OSCvalid;
    private transient int OSCwidth = -1;
    private transient int OSCheight = -1;

    public DisplayCanvas() {
        this.setBackground(Color.white);
        this.enableEvents(48L);
    }

    public DisplayCanvas(CoordinateRect coordinateRect) {
        this();
        if (coordinateRect != null) {
            this.addCoordinateRect(coordinateRect);
        }
    }

    public void releaseResources() {
        this.OSC = null;
        this.OSG = null;
    }

    public void setHandleMouseZooms(boolean bl) {
        this.handleMouseZooms = bl;
    }

    public boolean getHandleMouseZooms() {
        return this.handleMouseZooms;
    }

    public boolean getUseOffscreenCanvas() {
        return this.useOffscreenCanvas;
    }

    public void setUseOffscreenCanvas(boolean bl) {
        this.useOffscreenCanvas = bl;
        if (!bl) {
            this.OSC = null;
            this.OSG = null;
        }
    }

    public void add(Drawable drawable) {
        if (this.coordinateRects == null) {
            this.addCoordinateRect(new CoordinateRect());
        }
        CoordinateRect coordinateRect = ((CRData)this.coordinateRects.elementAt((int)0)).coords;
        coordinateRect.add(drawable);
    }

    public void add(Drawable drawable, int n) {
        if (this.coordinateRects == null || n < 0 || n >= this.coordinateRects.size()) {
            throw new IllegalArgumentException("Internal programming error:  CoordinateRect index (" + n + ")out of range.");
        }
        CoordinateRect coordinateRect = ((CRData)this.coordinateRects.elementAt((int)n)).coords;
        coordinateRect.add(drawable);
    }

    public void addCoordinateRect(CoordinateRect coordinateRect) {
        this.addCoordinateRect(coordinateRect, 0.0, 1.0, 0.0, 1.0, null);
    }

    public void addCoordinateRect(CoordinateRect coordinateRect, double d, double d2, double d3, double d4, Color color) {
        if (d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0 || d >= d2 || d3 < 0.0 || d3 > 1.0 || d4 < 0.0 || d4 > 1.0 || d3 >= d4) {
            throw new IllegalArgumentException("Illegal values for area covered by CoordinateRect.");
        }
        if (coordinateRect == null) {
            throw new IllegalArgumentException("Can't add null CoordinateRect to DisplayCanvas.");
        }
        CRData cRData = new CRData();
        cRData.coords = coordinateRect;
        cRData.xmin = d;
        cRData.xmax = d2;
        cRData.ymin = d3;
        cRData.ymax = d4;
        cRData.background = color;
        if (this.coordinateRects == null) {
            this.coordinateRects = new Vector();
        }
        this.coordinateRects.addElement(cRData);
        coordinateRect.setOwner(this);
    }

    public int addNewCoordinateRect(double d, double d2, double d3, double d4) {
        CoordinateRect coordinateRect = new CoordinateRect();
        this.addCoordinateRect(coordinateRect, d, d2, d3, d4, null);
        return this.coordinateRects.size() - 1;
    }

    public int addNewCoordinateRect(double d, double d2, double d3, double d4, Color color) {
        CoordinateRect coordinateRect = new CoordinateRect();
        this.addCoordinateRect(coordinateRect, d, d2, d3, d4, color);
        return this.coordinateRects.size() - 1;
    }

    public CoordinateRect getCoordinateRect() {
        return this.getCoordinateRect(0);
    }

    public CoordinateRect getCoordinateRect(int n) {
        if (n == 0 && (this.coordinateRects == null || this.coordinateRects.size() == 0)) {
            this.addNewCoordinateRect(0.0, 1.0, 0.0, 1.0);
        }
        if (this.coordinateRects == null || n < 0 || n >= this.coordinateRects.size()) {
            return null;
        }
        return ((CRData)this.coordinateRects.elementAt((int)n)).coords;
    }

    public CoordinateRect findCoordinateRectAt(int n, int n2) {
        if (this.coordinateRects == null) {
            return null;
        }
        for (int i = this.coordinateRects.size() - 1; i >= 0; --i) {
            CRData cRData = (CRData)this.coordinateRects.elementAt(i);
            int n3 = this.getSize().width;
            if (n3 <= 0) {
                return null;
            }
            int n4 = this.getSize().height;
            int n5 = (int)(cRData.xmin * (double)n3);
            int n6 = (int)(cRData.ymin * (double)n4);
            int n7 = (int)(cRData.xmax * (double)n3);
            int n8 = (int)(cRData.ymax * (double)n4);
            if (n < n5 || n >= n7 || n2 < n6 || n2 >= n8) continue;
            return cRData.coords;
        }
        return null;
    }

    public synchronized void doRedraw() {
        this.OSCvalid = false;
        if (this.errorMessage != null) {
            this.clearErrorMessage();
        } else {
            this.repaint();
        }
    }

    public synchronized void doRedraw(int n) {
        if (this.coordinateRects != null && n >= 0 && n < this.coordinateRects.size()) {
            CRData cRData = (CRData)this.coordinateRects.elementAt(n);
            this.OSCvalid = false;
            if (this.errorMessage != null) {
                this.clearErrorMessage();
            } else {
                int n2 = this.getSize().width;
                int n3 = this.getSize().height;
                int n4 = (int)(cRData.xmin * (double)n2);
                int n5 = (int)(cRData.ymin * (double)n3);
                int n6 = (int)(cRData.xmax * (double)n2) - n4;
                int n7 = (int)(cRData.ymax * (double)n3) - n5;
                this.repaint(n4, n5, n6, n7);
            }
        }
    }

    public synchronized void doRedraw(CoordinateRect coordinateRect) {
        int n = this.coordinateRects == null ? -1 : this.coordinateRects.size();
        for (int i = 0; i < n; ++i) {
            if (((CRData)this.coordinateRects.elementAt((int)i)).coords != coordinateRect) continue;
            this.doRedraw(i);
            break;
        }
    }

    public synchronized void checkInput() {
        if (this.coordinateRects != null) {
            int n = this.coordinateRects.size();
            for (int i = 0; i < n; ++i) {
                ((CRData)this.coordinateRects.elementAt((int)i)).coords.checkInput();
            }
        }
    }

    public synchronized void compute() {
        if (this.coordinateRects != null) {
            int n = this.coordinateRects.size();
            for (int i = 0; i < n; ++i) {
                ((CRData)this.coordinateRects.elementAt((int)i)).coords.compute();
            }
        }
    }

    public void notifyControllerOnChange(Controller controller) {
        if (this.coordinateRects != null) {
            int n = this.coordinateRects.size();
            for (int i = 0; i < n; ++i) {
                ((CRData)this.coordinateRects.elementAt((int)i)).coords.notifyControllerOnChange(controller);
            }
        }
    }

    public Color getErrorBackground() {
        return this.errorBackground;
    }

    public void setErrorBackground(Color color) {
        if (color != null) {
            this.errorBackground = color;
        }
    }

    public Color getErrorForeground() {
        return this.errorForeground;
    }

    public void setErrorForeground(Color color) {
        if (color != null) {
            this.errorForeground = color;
        }
    }

    public synchronized String getErrorMessage() {
        return this.errorMessage;
    }

    public synchronized void setErrorMessage(Controller controller, String string) {
        if (string == null || string.trim().length() == 0) {
            if (this.errorMessage != null) {
                this.clearErrorMessage();
                if (this.errorSource != controller) {
                    this.errorSource.errorCleared();
                }
                this.repaint();
            }
        } else {
            this.errorMessage = string.trim();
            this.errorSource = controller;
            this.OSCvalid = false;
            this.repaint();
        }
    }

    public synchronized void clearErrorMessage() {
        if (this.errorMessage == null) {
            return;
        }
        this.errorMessage = null;
        if (this.errorSource != null) {
            this.errorSource.errorCleared();
        }
        this.errorSource = null;
        this.repaint();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.dragging = false;
            this.dragged = null;
            if (this.errorMessage != null) {
                if (this.errorSource != null) {
                    this.errorSource.errorCleared();
                }
                this.errorSource = null;
                this.errorMessage = null;
                this.repaint();
                mouseEvent.consume();
                return;
            }
            CoordinateRect coordinateRect = this.findCoords(mouseEvent);
            if (coordinateRect != null) {
                this.dragged = coordinateRect.checkDraggables(mouseEvent);
            }
            if (this.dragged != null) {
                return;
            }
            if (this.handleMouseZooms && mouseEvent.getClickCount() <= 1 && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() && !mouseEvent.isControlDown()) {
                super.processMouseEvent(mouseEvent);
                if (!mouseEvent.isConsumed()) {
                    this.doMouseZoom_pressed(mouseEvent);
                }
                return;
            }
        } else {
            if (mouseEvent.getID() == 502 && this.handleMouseZooms && this.dragged != null) {
                this.dragged.finishDrag(mouseEvent);
                this.dragged = null;
                return;
            }
            if (mouseEvent.getID() == 502 && this.handleMouseZooms && this.dragging) {
                this.doMouseZoom_released(mouseEvent);
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.dragged != null && mouseEvent.getID() == 506) {
            this.dragged.continueDrag(mouseEvent);
        } else if (this.dragging && mouseEvent.getID() == 506) {
            this.doMouseZoom_moved(mouseEvent);
        } else {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    private void drawErrorMessage(Graphics graphics) {
        int n;
        int n2;
        if (this.errorMessage == null) {
            return;
        }
        Font font = new Font("Helvetica", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getLeading();
        int n7 = n3 - 80;
        int n8 = 30;
        int n9 = (n4 - 60 - n5) / n5;
        if (n9 <= 0) {
            n9 = 1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.errorMessage, " \t\r\n");
        int n10 = 0;
        String[] stringArray = new String[n9];
        String string = "   ";
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (fontMetrics.stringWidth(string3) > n7) {
                string2 = "";
                n2 = fontMetrics.stringWidth("...");
                for (n = 0; n < string3.length() && fontMetrics.stringWidth(string2 = string2 + string3.charAt(n)) + n2 <= n7; ++n) {
                }
                string3 = string2;
            }
            if (fontMetrics.stringWidth(string2 = string + " " + string3) > n7) {
                stringArray[n10] = string;
                if (++n10 == n9) break;
                string = string3;
                continue;
            }
            string = string2;
        }
        if (n10 < n9) {
            stringArray[n10] = string;
            ++n10;
        }
        if (n10 == 1) {
            stringArray[0] = stringArray[0] + "    ";
        }
        int n11 = n3 - 60;
        int n12 = (n10 + 1) * n5 + 50;
        n2 = n4 / 2 - n12 / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n3, n4);
        graphics.setColor(this.errorBackground);
        graphics.fillRect(n8, n2, n11, n12);
        graphics.setColor(this.errorForeground);
        graphics.drawRect(n8, n2, n11, n12);
        graphics.drawRect(n8 + 1, n2 + 1, n11 - 2, n12 - 2);
        graphics.drawLine(n8, n2 + 23 + n5, n8 + n11 - 2, n2 + 23 + n5);
        graphics.drawLine(n8, n2 + 24 + n5, n8 + n11 - 2, n2 + 24 + n5);
        graphics.setFont(font);
        graphics.drawString("ERROR MESSAGE", n3 / 2 - fontMetrics.stringWidth("(Error Message)") / 2, n2 + 10 + n5);
        if (n10 == 1) {
            graphics.drawString(stringArray[0], n3 / 2 - fontMetrics.stringWidth(stringArray[0]) / 2, n2 + 35 + 2 * n5);
        } else {
            for (n = 0; n < n10; ++n) {
                graphics.drawString(stringArray[n], n8 + 10, n2 + 35 + (n + 2) * n5 - n6);
            }
        }
    }

    private CoordinateRect findCoords(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.coordinateRects == null ? -1 : this.coordinateRects.size();
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        for (int i = n3 - 1; i >= 0; --i) {
            CRData cRData = (CRData)this.coordinateRects.elementAt(i);
            double d = (int)(cRData.xmin * (double)n4);
            double d2 = (int)(cRData.ymin * (double)n5);
            double d3 = (int)(cRData.xmax * (double)n4) - 1;
            double d4 = (int)(cRData.ymax * (double)n5) - 1;
            if (!((double)n >= d) || !((double)n <= d3) || !((double)n2 >= d2) || !((double)n2 <= d4)) continue;
            return cRData.coords;
        }
        return null;
    }

    private synchronized void doMouseZoom_pressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 || mouseEvent.isAltDown() || mouseEvent.isMetaDown() || mouseEvent.isControlDown()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.coordinateRects == null ? -1 : this.coordinateRects.size();
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        for (int i = n3 - 1; i >= 0; --i) {
            CRData cRData = (CRData)this.coordinateRects.elementAt(i);
            this.dragXmin = (int)(cRData.xmin * (double)n4);
            this.dragYmin = (int)(cRData.ymin * (double)n5);
            this.dragXmax = (int)(cRData.xmax * (double)n4) - 1;
            this.dragYmax = (int)(cRData.ymax * (double)n5) - 1;
            if (n < this.dragXmin || n > this.dragXmax || n2 < this.dragYmin || n2 > this.dragYmax) continue;
            this.dragging = true;
            this.draggingZoomWindow = false;
            this.draggingInRect = cRData;
            this.startX = n;
            this.startY = n2;
            this.lastX = n;
            this.lastY = n2;
            break;
        }
    }

    private synchronized void doMouseZoom_released(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        this.putDragRect(graphics);
        graphics.dispose();
        CoordinateRect coordinateRect = this.draggingInRect.coords;
        if (Math.abs(this.lastX - this.startX) < 4 && Math.abs(this.lastY - this.startY) < 4 || Math.abs(this.startX - this.lastX) < 2 || Math.abs(this.startY - this.lastY) < 2) {
            if (this.draggingZoomWindow) {
                return;
            }
            if (mouseEvent.isShiftDown()) {
                coordinateRect.zoomOutFromPixel(this.startX, this.startY);
            } else {
                coordinateRect.zoomInOnPixel(this.startX, this.startY);
            }
        } else {
            coordinateRect.setLimits(coordinateRect.pixelToX(this.startX), coordinateRect.pixelToX(this.lastX), coordinateRect.pixelToY(this.startY), coordinateRect.pixelToY(this.lastY));
        }
        this.dragging = false;
    }

    private synchronized void doMouseZoom_moved(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        this.putDragRect(graphics);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.putDragRect(graphics);
        graphics.dispose();
    }

    private void putDragRect(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.lastX < this.dragXmin) {
            this.lastX = this.dragXmin;
        }
        if (this.lastX > this.dragXmax) {
            this.lastX = this.dragXmax;
        }
        if (this.lastY < this.dragYmin) {
            this.lastY = this.dragYmin;
        }
        if (this.lastY > this.dragYmax) {
            this.lastY = this.dragYmax;
        }
        if (Math.abs(this.startX - this.lastX) < 4 && Math.abs(this.startY - this.lastY) < 4 || Math.abs(this.startX - this.lastX) < 2 || Math.abs(this.startY - this.lastY) < 2) {
            return;
        }
        this.draggingZoomWindow = true;
        Color color = this.draggingInRect.background;
        if (color == null) {
            color = this.getBackground();
        }
        graphics.setXORMode(color);
        if (color.getRed() <= 100 && color.getGreen() <= 100 && color.getBlue() <= 150) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        if (this.startX < this.lastX) {
            n4 = this.startX;
            n3 = this.lastX - this.startX;
        } else {
            n4 = this.lastX;
            n3 = this.startX - this.lastX;
        }
        if (this.startY < this.lastY) {
            n2 = this.startY;
            n = this.lastY - this.startY;
        } else {
            n2 = this.lastY;
            n = this.startY - this.lastY;
        }
        graphics.drawRect(n4, n2, n3, n);
        graphics.setPaintMode();
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 350);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawCoordinateRects(Graphics graphics, int n, int n2, Rectangle rectangle) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        int n3 = this.coordinateRects == null ? -1 : this.coordinateRects.size();
        try {
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle2;
                CRData cRData = (CRData)this.coordinateRects.elementAt(i);
                Rectangle rectangle3 = new Rectangle();
                rectangle3.x = (int)(cRData.xmin * (double)n);
                rectangle3.y = (int)(cRData.ymin * (double)n2);
                rectangle3.width = (int)(cRData.xmax * (double)n) - rectangle3.x;
                rectangle3.height = (int)(cRData.ymax * (double)n2) - rectangle3.y;
                Rectangle rectangle4 = rectangle2 = rectangle == null ? rectangle3 : rectangle3.intersection(rectangle);
                if (rectangle != null && rectangle2.isEmpty()) continue;
                graphics.setClip(rectangle2);
                if (cRData.background != null) {
                    graphics.setColor(cRData.background);
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
                cRData.coords.draw(graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        }
        finally {
            graphics.setClip(rectangle);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.errorMessage == null) {
            try {
                this.checkOSC();
                if (this.OSC != null) {
                    graphics.drawImage(this.OSC, 0, 0, this);
                } else {
                    this.drawCoordinateRects(graphics, this.getSize().width, this.getSize().height, graphics.getClipBounds());
                }
                if (this.dragging) {
                    this.putDragRect(graphics);
                }
            }
            catch (RuntimeException runtimeException) {
                this.errorMessage = "Internal Error? (stack trace on System.out):  " + runtimeException.toString();
                runtimeException.printStackTrace();
                graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            }
        }
        if (this.errorMessage != null) {
            this.drawErrorMessage(graphics);
            this.OSCvalid = false;
            return;
        }
    }

    public void drawTemp(DrawTemp drawTemp) {
        if (this.coordinateRects == null || this.coordinateRects.size() == 0) {
            this.addCoordinateRect(new CoordinateRect());
        }
        this.drawTemp(drawTemp, 0);
    }

    public synchronized void drawTemp(DrawTemp drawTemp, int n) {
        if (n < 0 || n >= this.coordinateRects.size()) {
            throw new IllegalArgumentException("Invalid CoordinateRect index, " + n);
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        CRData cRData = (CRData)this.coordinateRects.elementAt(n);
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)(cRData.xmin * (double)this.getSize().width);
        rectangle.y = (int)(cRData.ymin * (double)this.getSize().height);
        rectangle.width = (int)(cRData.xmax * (double)this.getSize().width) - rectangle.x;
        rectangle.height = (int)(cRData.ymax * (double)this.getSize().height) - rectangle.y;
        graphics.setClip(rectangle);
        drawTemp.draw(graphics, cRData.coords);
        graphics.dispose();
        if (this.useOffscreenCanvas && this.OSCvalid && this.OSC != null) {
            graphics = this.OSC.getGraphics();
            graphics.setClip(rectangle);
            drawTemp.draw(graphics, cRData.coords);
            graphics.dispose();
        }
    }

    private synchronized void checkOSC() {
        if (!this.useOffscreenCanvas || this.OSCvalid && this.OSC != null && this.OSCwidth == this.getSize().width && this.OSCheight == this.getSize().height) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.OSC == null || n != this.OSCwidth || n2 != this.OSCheight) {
            this.OSCvalid = false;
            this.OSCwidth = n;
            this.OSCheight = n2;
            try {
                this.OSC = this.createImage(this.OSCwidth, this.OSCheight);
                this.OSG = this.OSC.getGraphics();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.OSC = null;
                this.OSG = null;
            }
        }
        if (this.OSC == null || this.OSCvalid) {
            return;
        }
        this.OSCvalid = true;
        this.OSG.setClip(0, 0, n, n2);
        this.drawCoordinateRects(this.OSG, n, n2, null);
    }

    private static class CRData
    implements Serializable {
        CoordinateRect coords;
        double xmin;
        double xmax;
        double ymin;
        double ymax;
        Color background;

        private CRData() {
        }
    }
}

