#include <iostream>
#include <cassert>
using namespace std;

#include <symbol_factory.h>
using namespace GiNaC;
using namespace SyFi;


int main() {
  initSyFi(3);
	assert( symbol_exists("x") );
	assert( symbol_exists("y") );
	assert( symbol_exists("z") );
  
	ex x1 = get_symbol("x");
	ex x2 = get_symbol("x");
	ex x3 = get_symbol("x");
  assert( is_zero(x2-x1) );
  assert( is_zero(x3-x1) );
  
	assert( is_zero( SyFi::x - get_symbol("x") ) );
	assert( is_zero( SyFi::y - get_symbol("y") ) );
	assert( is_zero( SyFi::z - get_symbol("z") ) );
	assert( !symbol_exists("foo") );
  
  cout << get_symbolic_vector(1, "v") << endl;
  cout << get_symbolic_vector(3, "u") << endl;
  cout << get_symbolic_vector(11, "w") << endl;
  cout << get_symbolic_matrix(2, 3, "B") << endl;
  cout << get_symbolic_matrix(3, 3, "A") << endl;
  
	return 0;
}
