// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef PTV_INCLUDED
#define PTV_INCLUDED

#include <functional>
#include <iostream>

class Ptv
{

	public:
		unsigned int dim;
		double* v;
		static double tol;
		Ptv(unsigned int size_);
		Ptv(unsigned int size_, double* v_);
		Ptv(double x, double y);
		Ptv(double x, double y, double z);
		Ptv(const Ptv& p);
		Ptv();
		void redim(unsigned int size_, double *v_);
		void redim(unsigned int size_);
		void fill(double *v_);

		virtual ~Ptv();

		const unsigned int size() const;

		const double& operator [] (unsigned int i) const;
		double& operator [] (unsigned int i);
		Ptv& operator = (const Ptv& p);

		bool less(const Ptv& p) const;

};

struct Ptv_is_less : public std::binary_function<Ptv, Ptv, bool>
{
	bool operator() (const Ptv &lh, const Ptv &rh) const { return lh.less(rh);  }
};

class Ptv_match : public std::unary_function<Ptv, bool>
{
	protected:
		static double tol;
		unsigned int d;
		double v;
	public:
		Ptv_match();
		Ptv_match(unsigned int d_, double v_);
		virtual ~Ptv_match() {}
		bool operator() (const Ptv &p);
};

std::ostream & operator<< ( std::ostream& os, const Ptv& p);
#endif
