; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7 %s -o - | FileCheck %s

; Optimize expanded SRL/SHL used as an input of
; SETCC comparing it with zero by removing rotation.
;
; See https://bugs.llvm.org/show_bug.cgi?id=50197
define i64 @opt_setcc_lt_power_of_2(i64 %a) nounwind {
; CHECK-LABEL: opt_setcc_lt_power_of_2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:  .LBB0_1: @ %loop
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    adds r0, r0, #1
; CHECK-NEXT:    adc r1, r1, #0
; CHECK-NEXT:    orrs r2, r1, r0, lsr #16
; CHECK-NEXT:    bne .LBB0_1
; CHECK-NEXT:  @ %bb.2: @ %exit
; CHECK-NEXT:    bx lr
  br label %loop

loop:
  %phi.a = phi i64 [ %a, %0 ], [ %inc, %loop ]
  %inc = add i64 %phi.a, 1
  %cmp = icmp ult i64 %inc, 65536
  br i1 %cmp, label %exit, label %loop

exit:
  ret i64 %inc
}

define i1 @opt_setcc_srl_eq_zero(i64 %a) nounwind {
; CHECK-LABEL: opt_setcc_srl_eq_zero:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r1, r0, lsr #17
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    lsr r0, r0, #5
; CHECK-NEXT:    bx lr
   %srl = lshr i64 %a, 17
   %cmp = icmp eq i64 %srl, 0
   ret i1 %cmp
}

define i1 @opt_setcc_srl_ne_zero(i64 %a) nounwind {
; CHECK-LABEL: opt_setcc_srl_ne_zero:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orrs r0, r1, r0, lsr #17
; CHECK-NEXT:    movwne r0, #1
; CHECK-NEXT:    bx lr
   %srl = lshr i64 %a, 17
   %cmp = icmp ne i64 %srl, 0
   ret i1 %cmp
}

define i1 @opt_setcc_shl_eq_zero(i64 %a) nounwind {
; CHECK-LABEL: opt_setcc_shl_eq_zero:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r0, r1, lsl #17
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    lsr r0, r0, #5
; CHECK-NEXT:    bx lr
   %shl = shl i64 %a, 17
   %cmp = icmp eq i64 %shl, 0
   ret i1 %cmp
}

define i1 @opt_setcc_shl_ne_zero(i64 %a) nounwind {
; CHECK-LABEL: opt_setcc_shl_ne_zero:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orrs r0, r0, r1, lsl #17
; CHECK-NEXT:    movwne r0, #1
; CHECK-NEXT:    bx lr
   %shl = shl i64 %a, 17
   %cmp = icmp ne i64 %shl, 0
   ret i1 %cmp
}

; Negative test: optimization should not be applied if shift has multiple users.
define i1 @opt_setcc_shl_eq_zero_multiple_shl_users(i64 %a) nounwind {
; CHECK-LABEL: opt_setcc_shl_eq_zero_multiple_shl_users:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r11, lr}
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    lsl r0, r1, #17
; CHECK-NEXT:    orr r5, r0, r4, lsr #15
; CHECK-NEXT:    lsl r0, r4, #17
; CHECK-NEXT:    mov r1, r5
; CHECK-NEXT:    bl use
; CHECK-NEXT:    orr r0, r5, r4, lsl #17
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    lsr r0, r0, #5
; CHECK-NEXT:    pop {r4, r5, r11, pc}
   %shl = shl i64 %a, 17
   %cmp = icmp eq i64 %shl, 0
   call void @use(i64 %shl)
   ret i1 %cmp
}

; Check that optimization is applied to DAG having appropriate shape
; even if there were no actual shift's expansion.
define i1 @opt_setcc_expanded_shl_correct_shifts(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: opt_setcc_expanded_shl_correct_shifts:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r1, r0, lsl #17
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    lsr r0, r0, #5
; CHECK-NEXT:    bx lr
  %shl.a = shl i32 %a, 17
  %srl.b = lshr i32 %b, 15
  %or.0 = or i32 %shl.a, %srl.b
  %shl.b = shl i32 %b, 17
  %or.1 = or i32 %or.0, %shl.b
  %cmp = icmp eq i32 %or.1, 0
  ret i1 %cmp
}

; Negative test: optimization should not be applied as
; constants used in shifts do not match.
define i1 @opt_setcc_expanded_shl_wrong_shifts(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: opt_setcc_expanded_shl_wrong_shifts:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    lsl r0, r0, #17
; CHECK-NEXT:    orr r0, r0, r1, lsr #15
; CHECK-NEXT:    orr r0, r0, r1, lsl #18
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    lsr r0, r0, #5
; CHECK-NEXT:    bx lr
  %shl.a = shl i32 %a, 17
  %srl.b = lshr i32 %b, 15
  %or.0 = or i32 %shl.a, %srl.b
  %shl.b = shl i32 %b, 18
  %or.1 = or i32 %or.0, %shl.b
  %cmp = icmp eq i32 %or.1, 0
  ret i1 %cmp
}

define i1 @opt_setcc_shl_ne_zero_i128(i128 %a) nounwind {
; CHECK-LABEL: opt_setcc_shl_ne_zero_i128:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r3, r1, r3
; CHECK-NEXT:    orr r0, r2, r0
; CHECK-NEXT:    orr r2, r0, r3
; CHECK-NEXT:    orr r0, r0, r1
; CHECK-NEXT:    lsr r0, r0, #15
; CHECK-NEXT:    orrs r0, r0, r2, lsl #17
; CHECK-NEXT:    movwne r0, #1
; CHECK-NEXT:    bx lr
  %shl = shl i128 %a, 17
  %cmp = icmp ne i128 %shl, 0
  ret i1 %cmp
}

declare void @use(i64 %a)
