/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _CONFLICT_TYPE_H
#define _CONFLICT_TYPE_H


// a conflict type or'ed with this one defines 
// an 'empty conflict'
const long ctFlagEmpty  = 0x40000000;

// a conflict type or'ed with this one defines 
// a 'merged conflict'
const long ctFlagMerged = 0x20000000;


enum ConflictType
{
  ctNop                         = 0x0,         // no line
  ctCommon                      = 0x1,         // identical line in all
                                               // datasources
  // diff2/diff3
  ctConflictAll                 = 0x2,         // conflict in all
                                               // datasources
  // diff3 only
  ctConflictLatestModified      = 0x4,         // original = latest,
                                               // conflict with modified
  ctConflictModifiedLatest      = 0x8,         // original = modified,
                                               // conflict with latest
  ctConflictOriginal            = 0x10,        // modified = latest,
                                               // conflict with original

  ctConflictAllEmpty             = ctFlagEmpty | ctConflictAll,
  ctConflictLatestModifiedEmpty  = ctFlagEmpty | ctConflictLatestModified,
  ctConflictModifiedLatestEmpty  = ctFlagEmpty | ctConflictModifiedLatest,
  ctConflictOriginalEmpty        = ctFlagEmpty | ctConflictOriginal,

  ctConflictAllMerged            = ctFlagMerged | ctConflictAll,
  ctConflictLatestModifiedMerged = ctFlagMerged | ctConflictLatestModified,
  ctConflictModifiedLatestMerged = ctFlagMerged | ctConflictModifiedLatest,
  ctConflictOriginalMerged       = ctFlagMerged | ctConflictOriginal,

  ctConflictAllEmptyMerged            = ctFlagEmpty | ctFlagMerged | ctConflictAll,
  ctConflictLatestModifiedEmptyMerged = ctFlagEmpty | ctFlagMerged | ctConflictLatestModified,
  ctConflictModifiedLatestEmptyMerged = ctFlagEmpty | ctFlagMerged | ctConflictModifiedLatest,
  ctConflictOriginalEmptyMerged       = ctFlagEmpty | ctFlagMerged | ctConflictOriginal
};


#endif //  _CONFLICT_TYPE_H

