/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DELETECMD_H
#define _SC_DELETECMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class DeleteParam;

/**
 * Command for deleting files from a working copy.
 */
class DeleteCmd : public ScCmd
{
public:
  /**
   * Construct a DeleteCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  DeleteCmd( DeleteParam* param, CmdResultCallback* cb );
  ~DeleteCmd();

  void run();

private:
  // in
  DeleteParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_DELETECMD_H
