/* ====================================================================
 * Copyright (c) 2007-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWTREEITEMMODEL_H
#define _SC_WCVIEWTREEITEMMODEL_H

// sc
#include "WcViewItem.h"
#include "WcViewItemModel.h"
#include "util/String.h"
class WcViewTreeItemModelMember;
class WcViewTreeItemFolder;

// qt
#include <QtCore/QAbstractItemModel>


/**
 * Item model for WcViewTree.
 */
class WcViewTreeItemModel : public QAbstractItemModel, public WcViewItemModel
{
  typedef QAbstractItemModel super;
  Q_OBJECT

public:
  WcViewTreeItemModel( const sc::String& root, const WcViewItemData* data );
  ~WcViewTreeItemModel();

  // QAbstractItemModel
  QModelIndex index( int row, int column, const QModelIndex& parent ) const;
  QModelIndex parent( const QModelIndex& index ) const;
  int columnCount( const QModelIndex& parent ) const;
  int rowCount( const QModelIndex& parent ) const;
  QVariant headerData( int section, Qt::Orientation orientation, int role ) const;
  QVariant data( const QModelIndex& index, int role ) const;
  Qt::ItemFlags flags( const QModelIndex &index ) const;

  // WcViewItemModel
  QModelIndex index( const sc::String& name ) const;

public slots:
  // WcViewItemModel
  void insert( const sc::String& path, const WcViewItems& );
  void remove( const sc::String& path );

signals:
  void deepStatusChanged( const sc::String& );

private:
  /** update deep status up to the root item. */
  void updateDeepStatus( const sc::String& path );
  /** recursivly remove @a folder and all its children. */
  void remove( WcViewTreeItemFolder* folder );

  WcViewTreeItemModelMember* _m;
  const WcViewItemData*      _data;

  // test support
  friend class WcViewItemProxyModelTest;
};

#endif // _SC_WCVIEWTREEITEMMODEL_H
