-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;
with StringList;
with Unit;
with Units;

use type Unit.Object;
use type Unit.Id;
use type Unit.Kind;

--# inherit CommandLineData,
--#         Dictionary,
--#         Directory_Operations,
--#         ErrorHandler,
--#         E_Strings,
--#         LexTokenManager,
--#         RegularExpression,
--#         SparkLex,
--#         SparkMakeErrors,
--#         SPARK_IO,
--#         StringList,
--#         Unit,
--#         Units;

package UnitManager
--# own State;
--# initializes State;
is

   procedure Initialise
     (The_Directories : in     StringList.Object;
      Include         : in     StringList.Object;
      Exclude         : in     StringList.Object;
      Root_File       : in     E_Strings.T;
      Duplicates      : in     Boolean;
      Success         :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --#           out SparkLex.Curr_Line;
   --# derives ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         SparkLex.Curr_Line,
   --#         SPARK_IO.File_Sys,
   --#         State,
   --#         Success                    from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         Duplicates,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Exclude,
   --#                                         Include,
   --#                                         LexTokenManager.State,
   --#                                         Root_File,
   --#                                         SPARK_IO.File_Sys,
   --#                                         State,
   --#                                         The_Directories;

   -------------------------------------------------------------

   function Get_All_Units return  Units.Stack;
   --# global in State;

   procedure Get_Unit (In_File  : in     E_Strings.T;
                       The_Unit :    out Unit.Id;
                       Found    :    out Boolean);
   --# global in State;
   --# derives Found,
   --#         The_Unit from In_File,
   --#                       State;

   procedure Get_File (For_Unit : in     Unit.Id;
                       The_File :    out E_Strings.T;
                       Found    :    out Boolean);
   --# global in State;
   --# derives Found,
   --#         The_File from For_Unit,
   --#                       State;

   function Get (The_Unit : Unit.Id) return Unit.Object;
   --# global in State;

   function Package_Body (For_Unit : Unit.Id) return Unit.Id;
   --# global in State;

   function Parent (Of_Unit : Unit.Id) return Unit.Id;
   --# global in State;

   function Separate_Units (For_Unit : Unit.Id) return Units.Stack;
   --# global in State;

   function Required_Units (For_Unit : Unit.Id) return Units.Stack;
   --# global in State;

   function Components (For_Unit : Unit.Id) return Units.Stack;
   --# global in State;

   -- Search all units in UnitManager and return a stack of root
   -- units, ie units that are not required by other units.
   function Find_Roots return  Units.Stack;
   --# global in State;

end UnitManager;
