/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the impgnced warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for for JSON import / export.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgimportpluginjson.h"
#include <KLocale>
#include <KSaveFile>
#include <KGenericFactory>

#include <QFileInfo>

#include "skgtraces.h"
#include "skgdocumentbank.h"
#include "skgservices.h"

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGImportPluginJsonFactory, registerPlugin<SKGImportPluginJson>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGImportPluginJsonFactory("skrooge_import_json", "skrooge_import_json"))

SKGImportPluginJson::SKGImportPluginJson(QObject* iImporter, const QVariantList& iArg)
    : SKGImportPlugin(iImporter)
{
    SKGTRACEIN(10, "SKGImportPluginJson::SKGImportPluginJson");
    Q_UNUSED(iArg);
}

SKGImportPluginJson::~SKGImportPluginJson()
{
}

bool SKGImportPluginJson::isExportPossible()
{
    SKGTRACEIN(10, "SKGImportPluginCsv::isExportPossible");
    return (!m_importer ? true : m_importer->getFileNameExtension() == "JSON");
}

SKGError SKGImportPluginJson::exportFile()
{
    SKGError err;
    QString doc;
    err = m_importer->getDocument()->copyToJson(doc);
    IFOK(err) {
        KSaveFile file(m_importer->getLocalFileName(false));
        if (!file.open())err.setReturnCode(ERR_INVALIDARG).setMessage(i18nc("Error message",  "Save file '%1' failed", m_importer->getFileName().prettyUrl()));
        else {
            QTextStream stream(&file);
            if (!m_importer->getCodec().isEmpty()) stream.setCodec(m_importer->getCodec().toAscii().constData());
            stream << doc << endl;
        }

        // Close file
        file.finalize();
        file.close();
    }
    return err;
}

QString SKGImportPluginJson::getMimeTypeFilter() const
{
    return "*.json|" % i18nc("A file format", "JSON file");
}

#include "skgimportpluginjson.moc"
