// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2013, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================
// Author: Stephan Aiche <stephan.aiche@fu-berlin.de>
// ==========================================================================

#ifndef SEQAN_CORE_TESTS_ARG_PARSE_TEST_EXTENSIONS_H_
#define SEQAN_CORE_TESTS_ARG_PARSE_TEST_EXTENSIONS_H_

#include <seqan/basic/debug_test_system.h>
#include <string>

namespace seqan
{

void failExceptionTest()
{
    ::seqan::ClassTest::StaticData::thisTestOk() = false;
    ::seqan::ClassTest::StaticData::errorCount() += 1;
    ::seqan::ClassTest::fail();
}


#define SEQAN_TEST_EXCEPTION(_exception_type, command, _message)                    \
    do                                                                              \
    {                                                                               \
        bool caughtException = false;                                               \
        try                                                                         \
        {                                                                           \
            command;                                                                \
        }                                                                           \
        catch(_exception_type& ex)                                                  \
        {                                                                           \
            if(std::string(ex.what()) != _message)                                  \
            {                                                                       \
                std::cerr << __FILE__ << ":" << __LINE__                            \
                          << " Got correct exception but wrong message: '"          \
                          << ex.what() << "' != '"                                  \
                          << _message << "'" << std::endl;                          \
                failExceptionTest();                                                \
            }                                                                       \
            caughtException = true;                                                 \
        }                                                                           \
        catch(...)                                                                  \
        {                                                                           \
            std::cerr << __FILE__ << ":" << __LINE__ << " Got wrong exception: "    \
                      << #_exception_type << std::endl;                             \
            failExceptionTest();                                                    \
        }                                                                           \
        if (!caughtException)                                                       \
        {                                                                           \
            std::cerr << __FILE__ << ":" << __LINE__ << " No exception thrown!"     \
                      << std::endl;                                                 \
            failExceptionTest();                                                    \
        }                                                                           \
    } while(false)

}  // namespace seqan

#endif // SEQAN_CORE_TESTS_ARG_PARSE_TEST_EXTENSIONS_H_
