#include <iostream>
#include <fstream>

#include <seqan/index.h>
#include <seqan/statistics.h>

using namespace std;
using namespace seqan;

int main()
{
    typedef Dna TAlphabet;
	typedef String<TAlphabet> TSequence;

	TSequence str2 = "CCCAAAGC";
	TSequence str3 = "CCCAAAGTAAATT";

    TSequence str1a =
	"AGAAGCCTCAGATGAGGAGGGTTTTGCTGTGTGCTGCAAGTATCAGGGAGAAAGCATTTCTGCCCTCTCT"
	"GGAACATGGTGTGAACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAG"
	"AGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTT"
	"TACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGAT"
	"TAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGA"
	"TGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTG"
	"TCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAG"
	"TCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGACATCTTGTTTGTGTCA"
	"TTTACTAGAGTTGGCACTGTCTTAAGATGGGGGCATGGCTGACATTTTCAACTATCATCAGTGAGTCACT"
	"TGCCCAAATGAGGACCATGGTATTAATCTTGCATGTTTTTGGAACTGTTTAAAAAATGTCTGATTTTTGT"
	"TGTTTAGTGTCTGTTTTTGAATTTCCCCTTCTCTGCAGTTCTTGGTTTCTATCTCACTGAGTGCAGAGGA"
	"TTTTAATTGTTGCTGTCTATCTGTGCTTCGCAGCATGAGAGAGCAATGCCTACGGGCTCTTGTGGTGCTT"
	"TGGGGTTGACGGGTTTTATGTCTGAGCAAGCAGATGTCATAGTAGCCATGCTGGATTGCAGTAATAAATG"
	"TGTCCTTTTTTTCCTTCTGTAGCATTGAAAGCCGAAAAGAGAAGAAAGCTGACTCAGGGAAAGGTGTTGA"
	"CAGGGAGACTTGTCTATGACTCGATCTTCAATTTATTTTTTACATATATATGAGAAGAGTGTCACAATTA"
	"TTAATAAAACTGCTTTGATCATGTATTGTAAATTCTGTCCCTCAACCCAAATCCACCTTCATACTGTAAG"
	"TAGTGCAATACTTGTTTCATTTCTGTGTTTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCAGATACAA"
	"TAGCCAATGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAG"
	"TTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGT"
	"GACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTTTTTAGTTTTT"
	"ATAGCTTAGCATTAGTGACTTATTTCAAAAGACCCAAATCAAAAAGTTAGTTTGAAAGCATTTTTTAATA"
	"ATTGTATTTATGCATTTCCTTGATTTAATATGATAAATTTAATACTTAACAATTTATATGTAACTAAAAC"
	"TTAAAGTCATTTGAAAAATATATAGAAACCTATTTACAACTTGTTAAGGACAATCAGACATAATGCAGAG"
	"TTAAGTAGTATTTGCTTAAAATTCAAGTTGTGACTAATGATCAAATACTAGGCTTGTACGAAATGCTTTA"
	"GAAAAACTTTGTAACAGTTTTGTGGGATTTTTCAATATAAACCTTTATCAGAAATATACTAAGTTTGTCT"
	"CCCACTGACAACAGATGTTTTCCAAATAAACATATTCTATACATACTTGTGGAATGCCACATGGTGAATC"
	"ATTGTATATGAAATTCCACTCCTGTACAGTTACTCTGCAGCTAATGGTCATGCACTGCTTAATGCTGGTC"
	"CTGAATCATGTTCTCATGTTAGACCAACAGCTCTCCAATTGTCATTTTTTTTCTGCAGAGTTTTTTTTTT"
	"CCACTTTTAAATTAAATGCATGTTGTGGAAAAACAGTCTTTTAAAATGAAATTTCAGATTCCATTTGAGA"
	"AGGTTCTGTAGATATTTCAGTCCATATAAAATAATACATCTTTACTAAACTTATATAAGGGGAGAGAAAG"
	"TTATGAAGTTTTGGACATTACTAAAAGTACAGTATTTGATTTCACTTTCAATGAATGTGAAGTTAATAAA"
	"ACTAAATCTCATAATGCTCTTGGTTCCTAAGAATGAGTAGTAATCATCAACTTTATAATACTCCAATATT"
	"CCGTTTTATAATAATTCAGAGCCCTGTGGCTTTTACACACCGTTAATTATGTACTCTGTTGGAAGTGCAC"
	"ATGAAAAGTGAAGAAAAGTTCCTCTTGTGATTAAACTAATGGGAGGAAATAAATCAACAAAGTCTCCATT"
	"AAGTTCTACATTTTGAGACCTTTTAAAAATTCCCCTCACAATTCTTTAAGGAGCCCCCCTTTTTATGGAA"
	"CATGAGCCTAAAAATTATAGAAAGAAGAATTTTAAGTTAATAAAGTTTGTATTTATAAATGCTGAAAAAA"
	"TACAGAAACTTTCTGTTCCAAATGTGTTGCTTTGTGTATTTTATAATACAGATACTACATTGTAAACATT"
	"TCCATTGTTTTATGATTTAGCCAGTGATTCCCCAAAGCAGCCTCTTAGTGTTTTAATATATTAATAACTG"
	"TTTTGTTAAAAATGATCATAGTGAATTTAAATCTTCACATGATCACCTATTTGAATAAGCAA";
	
	TSequence str1b =
	"TGAGGACCTCAGATGAGGAGGGTTTTGCTGTAAACAAGTATCAGGGAGAAAGCATTTCTGCCCTCTCTGC"
	"TGTGTGCTGCAAGTACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAG"
	"AGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTT"
	"TACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGAT"
	"TAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGA"
	"TGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTG"
	"TCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAG"
	"TCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGACATCTTGTTTGTGTCA"
	"TTTACTAGAGTTGGCACTGTCTTAAGATGGGGGCATGGCTGACATTTTCAACTATCATCAGTGAGTCACT"
	"TGCCCAAATGAGGACCATGGTATTAATCTTGCATGTTTTTGGAACTGTTTAAAAAATGTCTGATTTTTGT"
	"TGTTTAGTGTCTGTTTTTGAATTTCCCCTTCTCTGCAGTTCTTGGTTTCTATCTCACTGAGTGCAGAGGA"
	"TTTTAATTGTTGCTGTCTATCTGTGCTTCGCAGCATGAGAGAGCAATGCCTACGGGCTCTTGTGGTGCTT"
	"TGGGGTTGACGGGTTTTATGTCTGAGCAAGCAGATGTCATAGTAGCCATGCTGGATTGCAGTAATAAATG"
	"TGTCCTTTTTTTCCTTCTGTAGCATTGAAAGCCGAAAAGAGAAGAAAGCTGACTCAGGGAAAGGTGTTGA"
	"CAGGGAGACTTGTCTATGACTCGATCTTCAATTTATTTTTTACATATATATGAGAAGAGTGTCACAATTA"
	"TTAATAAAACTGCTTTGATCATGTATTGTAAATTCTGTCCCTCAACCCAAATCCACCTTCATACTGTAAG"
	"TAGTGCAATACTTGTTTCATTTCTGTGTTTAAACTTCTGAGCAGTGAGACATCCCTGTGAGCATTTGCTG"
	"TAAAGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACATTTGTAAACTGGATTCTGATTGTCAGTTTT"
	"ATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTACCTAGTTTGTATTTTCCTACTTTAGTGACC"
	"TGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAGGTAGTCTTACTTCTTTTTAGTTTTTATAG"
	"CTTAGCATTAGTGACTTATTTCAAAAGACCCAAATCAAAAAGTTAGTTTGAAAGCATTTTTTAATAATTG"
	"TATTTATGCATTTCCTTGATTTAATATGATAAATTTAATACTTAACAATTTATATGTAACTAAAACTTAA"
	"AGTCATTTGAAAAATATATAGAAACCTATTTACAACTTGTTAAGGACAATCAGACATAATGCAGAGTTAA"
	"GTAGTATTTGCTTAAAATTCAAGTTGTGACTAATGATCAAATACTAGGCTTGTACGAAATGCTTTAGAAA"
	"AACTTTGTAACAGTTTTGTGGGATTTTTCAATATAAACCTTTATCAGAAATATACTAAGTTTGTCTCCCA"
	"CTGACAACAGATGTTTTCCAAATAAACATATTCTATACATACTTGTGGAATGCCACATGGTGAATCATTG"
	"TATATGAAATTCCACTCCTGTACAGTTACTCTGCAGCTAATGGTCATGCACTGCTTAATGCTGGTCCTGA"
	"ATCATGTTCTCATGTTAGACCAACAGCTCTCCAATTGTCATTTTTTTTCTGCAGAGTTTTTTTTTTCCAC"
	"TTTTAAATTAAATGCATGTTGTGGAAAAACAGTCTTTTAAAATGAAATTTCAGATTCCATTTGAGAAGGT"
	"TCTGTAGATATTTCAGTCCATATAAAATAATACATCTTTACTAAACTTATATAAGGGGAGAGAAGTTTAC"
	"AAGGTAGTCTGGGATTACTAACAAAATAAACAAGAGCCTTTCTAGATAAATGTGTCCATATGCCAGTGCG"
	"GTTTAGGTCTTATTCAAGACACAAGTCATTACTT";
	TSequence str1c =
	"CATGGTGTGAACTTCATCCCTGTAATGATATTGTTTGAATTTTCCATGAAAAATTGTCAGCATGAGAGTA"
	"AGAAAAGTGTACGATGGGAAAATATTGAACCAAACAGACAAAAATGGTAGAGTCACATGACCAGTTTACT"
	"CATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAAATTGGTAAAGTTAATGAGAGGGTGAGATTAAA"
	"CAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTGAGGAGTGAGGTGAAGCATCATTCCTCTGATGCA"
	"CAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGTGTCTGGAGAGCAGCGTGCATGGTAACCTGTCCT"
	"CCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGGTACAGTCTTCATCAAAGGTCAGGATCCAGTCCA"
	"TGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAAATGCCTCCTGCGAGTTTTGCTGTAAACAAGTAT"
	"CAGGGAGAAAGCATTTCTGCCCTCTCTGCTGTGTGCTGCAAGTACTTCATCCCTGTAATGATATTGTTTG"
	"AATTTTCCATGAAAAATTGTCAGCATGAGAGTAAGAAAAGTGTACGATGGGAAAATATTGAACCAAACAG"
	"ACAAAAATGGTAGAGTCACATGACCAGTTTACTCATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGA"
	"AATTGGTAAAGTTAATGAGAGGGTGAGATTAAACAGAGGGTGAGATTAAACTTGGGAATGAGTTTGTCTG"
	"AGGAGTGAGGTGAAGCATCATTCCTCTGATGCACAGGGTAAGGGTTTGTCTGTAAAGAGATAGCACAGGT"
	"GTCTGGAGAGCAGCGTGCATGGTAACCTGTCCTCCAGGCCAGTGGAGCTGTCTGTCTAACCTGGCCAAGG"
	"TACAGTCTTCATCAAAGGTCAGGATCCAGTCCATGCACAAGGGAGGAGCCATTTGCAGCAGAGCCCAGAA"
	"ATGCCTCCTGCGACATCTTGTTTGTGTCATTTACTAGAGTTGGCACTGTCTTAAGATGGGGGCATGGCTG"
	"ACATTTTCAACTATCATCAGTGAGTCACTTGCCCAAATGAGGACCATGGTATTAATCTTGCATGTTTTTG"
	"GAACTGTTTAAAAAATGTCTGATTTTTGTTGTTTAGTGTCTGTTTTTGAATTTCCCCTTCTCTGCAGTTC"
	"TTGGTTTCTATCTCACTGAGTGCAGAGGATTTTAATTGTTGCTGTCTATCTGTGCTTCGCAGCATGAGAG"
	"AGCAATGCCTACGGGCTCTTGTGGTGCTTTGGGGTTGACGGGTTTTATGTCTGAGCAAGCAGATGTCATA"
	"GTAGCCATGCTGGATTGCAGTAATAAATGTGTCCTTTTTTTCCTTCTGTAGCATTGAAAGCCGAAAAGAG"
	"AAGAAAGCTGACTCAGGGAAAGGTGTTGACAGGGAGACTTGTCTATGACTCGATCTTCAATTTATTTTTT"
	"ACATATATATGAGAAGAGTGTCACAATTATTAATAAAACTGCTTTGATCATGTATTGTAAATTCTGTCCC"
	"TCAACCCAAATCCACCTTCATACTGTAAGTAGTGCAATACTTGTTTCATTTCTGTGTTTAAACTTCTGAG"
	"CAGTGAGACATCCCTGTGAGCATTTGCTGTAAAGCAAGAATCTGTGTGTTCCTTGCTGTACGTTAGACAT"
	"TTGTAAACTGGATTCTGATTGTCAGTTTTATGAGAGCAATAGCTTCCTTAAAGAGATAAGTCATATTTAC"
	"CTAGTTTGTATTTTCCTACTTTAGTGACCTGAAGATGCCTGATAATTTCATTCAGAAGAATTTTTGAAAG"
	"GTAGTCTTACTTCTTTTTAGTTTTTATAGCTTAGCATTAGTGACTTATTTCAAAAGACCCAAATCAAAAA"
	"GTTAGTTTGAAAGCATTTTTTAATAATTGTATTTATGCATTTCCTTGATTTAATATGATAAATTTAATAC"
	"TTAACAATTTATATGTAACTAAAACTTAAAGTCATTTGAAAAATATATAGAAACCTATTTACAACTTGTT"
	"AAGGACAATCAGACATAATGCAGAGTTAAGTAGTATTTGCTTAAAATTCA";

	MarkovModel<TAlphabet> mm(3);



	StringSet<TSequence> X;
	appendValue(X, str1a);
    	appendValue(X, str1b);
	appendValue(X, str1c);

	StringSet<TSequence> W;
	appendValue(W,str2);
	appendValue(W,str3);
// //TODO his path has to be set explicitely when calling the demo
// 	FILE *fd = fopen("projects/library/demos/zscore_human_mm.3","r");
// 	read(fd, mm);
// 	fclose(fd);
	buildMarkovModel(mm,X);
	std::cout << zscore(W, X, mm, AhoCorasick()) << std::endl;

	//std::cout << zscore(W, X, mm, WuManber()) << std::endl;

	return 0;
}
