//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
warning("off");

function r=testresult(eps)
  if argn(2)<=0 then eps=1d-10;end
  if or(isnan(real(y))<>isnan(real(yref)))  then r=%t,return,end;
  if or(isnan(imag(y))<>isnan(imag(yref)))  then r=%t,return,end;
  if or(size(y)<>size(yref)) then r=%t,return,end;
  if yref==[] then r=%f,return,end;
  k=find(abs(yref)==0);
  r=or(abs(y(k)-yref(k))>eps);
  k=find(abs(yref)<>0);
  r=r|or(max(abs(y(k)-yref(k))./abs(yref(k)))>eps);
endfunction
ieee(1)
// ------------------------------ besseli(alpha,x)------------------------------

//test of numerical precision reference computed by maple
exec(SCI+'/modules/special_functions/tests/unit_tests/besseli_ref.sce',-1)
besselI=besseli(alpha',x);
if norm((besselI-besselI_ref)./abs(besselI_ref),1)>1d6*%eps then pause,end


alpha=[];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[1];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[1];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[1.00000000000000244];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.999999900000007491];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[1.26606587775200818];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.465759607593640379];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[4.8807925858650254 11.3019219521363308 27.2398718236044566];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825416 0.207001921223986723 0.183540812609328363];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[222.658799873011844 621.944087256767148];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.15041465295234574 0.13985490269028536];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[ 4.8807925858650254
11.3019219521363308
27.2398718236044566];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825416
0.207001921223986723
0.183540812609328363];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[222.658799873011844
621.944087256767148];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.15041465295234574
0.13985490269028536];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[222.619934807221995-4.13558800345596822*%i 621.83359839173761+11.6724388635437393*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150388398093404263-0.00279375005456099917*%i 0.139830057354854626+0.00262475009388627757*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.565159103992485035];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.207910415349708472];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[3.95337021740261063 9.75946515370444878 24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.178750839502435338 0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-206.791670046225448 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[3.95337021740261063
9.75946515370444878
24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865
0.178750839502435338
0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448
 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735
 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-206.754860873488298+3.88638968263160223*%i 583.551791140428804+11.0485508359642992*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139670925479849994+0.00262540692613094304*%i 0.131221729793522368+0.00248445806253726892*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[0 0 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0 0 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08 1.25000000000000237e-15 2.08333333333333559e-23];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08 1.24999987500000653e-15 2.08333312500000894e-23];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.565159103992485035 0.135747669767038337 0.0221684249243319018];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.207910415349708472 0.0499387768942235674 0.00815530777281429572];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[3.95337021740261063 6.42218937528410549 10.3311501691511403];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.117626501472769041 0.0696107422793332264];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 3.9533702174026093 2.2452124409299512 0.959753629496007843
9.75946515370445056 6.42218937528410549 3.33727577842034417
24.3356421424505349 17.5056149666242433 10.3311501691511403];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.111782545296958177 0.0477833195680233067
0.178750839502435338 0.117626501472769041 0.0611243380296663044
0.163972266944542394 0.117951905831511425 0.0696107422793332264];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448 166.003547805552813 -115.830821933593796
 583.657019840486896 482.978130151889332 353.667434053872967];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735 0.112141833362395943 -0.0782482115787162397
 0.131245392289731255 0.10860599976415887 0.0795282495448936949];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[0 0 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0 0 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[1.57275203335609045e-09 3.57443643944565263e-17 5.58505693663381842e-25];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[1.57275187608089216e-09 3.57443608200202085e-17 5.58505637812814222e-25];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.441739185636620402 0.0970124431622260697 0.0148844357228258926];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.162506764755527944 0.0356888833771960221 0.00547567789586544083];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[3.6230444698358566 5.7349531249690191 9.0956750146270835];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.180380762719529131 0.105039330480750176 0.0612861761694632121];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 3.6230444698358566 1.93400965955616022 0.786496969153470338
 9.163110826209099 5.7349531249690191 2.85466238874315748
23.1703721117744479 15.9939739740310927 9.0956750146270835];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.180380762719529131 0.09628867114443182 0.0391573783743615969
0.167828228990296452 0.105039330480750176 0.0522849654614709822
0.156120739238224226 0.107766548941773857 0.0612861761694632121];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-161.961985727353465-117.672270551119524*%i 126.353774591426728+91.8013908146748179*%i -85.8035462475893382-62.3399254025485305*%i 
 567.604978846113681+0*%i 458.189976541412591+0*%i 327.600705419659278+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.109411601466219255-0.07949218152238198*%i 0.0853568741286115373+0.0620153991120368855*%i -0.0579636225393849042-0.0421130368521132753*%i 
 0.127635812783717384+0*%i 0.103031953990436756+0*%i 0.0736666940268219245+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[1
0
0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[1
0
0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 1.00000000000000244
5.00000000000000904e-08
1.25000000000000237e-15];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.999999900000007491
4.99999950000002575e-08
1.24999987500000653e-15];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[ 1.26606587775200818
0.565159103992485035
0.135747669767038337];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.465759607593640379
 0.207910415349708472
0.0499387768942235674];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[4.88079258586502363 3.9533702174026093 2.2452124409299512
11.3019219521363308 9.75946515370444878 6.42218937528410549
27.2398718236044566 24.3356421424505349 17.5056149666242433];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825444 0.196826713297300893 0.111782545296958191
0.207001921223986723 0.178750839502435338 0.117626501472769041
0.183540812609328363 0.163972266944542394 0.117951905831511425];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[222.658799873011844 -206.791670046225448 166.003547805552813
621.944087256767148 583.657019840486896 482.978130151889332];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.15041465295234574 -0.139695791503316735 0.112141833362395943
0.13985490269028536 0.131245392289731255 0.10860599976415887];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ 4.8807925858650254
9.75946515370444878
17.5056149666242433];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825416
0.178750839502435338
0.117951905831511425];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[222.619934807221995-4.13558800345596822*%i -206.754860873488298+3.88638968263160223*%i 165.972275485088261-3.22602277348055821*%i 
 621.83359839173761+11.6724388635437393*%i 583.551791140428804+11.0485508359642992*%i 482.887220066322243+9.37265623194608821*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150388398093404263-0.00279375005456099917*%i -0.139670925479849994+0.00262540692613094304*%i 0.112120707697331859-0.0021793034731445015*%i 
0.139830057354854626+0.00262475009388627757*%i 0.131221729793522368+0.00248445806253726892*%i 0.108585557056476545+0.00210760412732592488*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[0
0
0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0
0
0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[ 0.722522753107872062
3.54177820150917083e-08
8.76677772650785916e-16];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.722522680855600341
3.54177784733136219e-08
8.76677684983011487e-16];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[ 1.25736065030765642
0.551966122309252905
0.131349760796780485];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.462557133386141961
 0.203056988620695933
0.0483208765999222356];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[ 4.8796780239824038 3.92148431590033741 2.21306868917017452
11.3010265107873309 9.70283844788389693 6.35257890236654443
27.2385606429501266 24.2259535380059781 17.354371599443688];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.242944863393175281 0.195239207739236365 0.110182202130494566
0.206985520643592436 0.177713685207167515 0.116351541187937002
0.183531977943573288 0.163233190941391326 0.116932836039485649];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[222.212839976181669+13.9804468865899914*%i -205.769686737402196-12.9459313719714064*%i 164.710078202989877+10.3626797634637366*%i 
621.928251907138815+0*%i 582.163410999272628+0*%i 480.545709235886818+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150113389749855497+0.00944433396642959701*%i -0.139005402150605722-0.00874547862276512863*%i 0.111268044491330098+0.00700039199513633002*%i 
0.139851341837586962+0*%i 0.13090952846623749+0*%i 0.108059027781500699+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[4.87967802398240469
9.70283844788389693
 17.354371599443688];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.242944863393175253
0.177713685207167543
0.116932836039485649];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 222.43372171741305+9.85068170978665592*%i -205.976447380591082-9.07462886841791594*%i 164.880559993464033+7.1570781308754885*%i 
621.817765198579878+11.6721823301041212*%i 582.058389438462655+11.0240694655973073*%i 480.455154676931897+9.33148596112965834*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150262603930789579+0.00665451745705368178*%i -0.139145076982263832-0.00613026367110974021*%i 0.111383211551259853+0.00483488379449827435*%i 
0.139826496987075832+0.00262469240789814894*%i 0.130885912548876937+0.00247895300229060943*%i 0.108038665020136204+0.002098346278691713*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[0.565159103992485035];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.207910415349708472];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[3.95337021740261063 9.75946515370444878 24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.178750839502435338 0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-206.791670046225448 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[3.95337021740261063
9.75946515370444878
24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865
0.178750839502435338
0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448
 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735
 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-206.754860873488298+3.88638968263160223*%i 583.551791140428804+11.0485508359642992*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139670925479849994+0.00262540692613094304*%i 0.131221729793522368+0.00248445806253726892*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[ 0
-%inf];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0
-%inf];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08
 -25231325220.2014771];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08
 -25231322697.0690804];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[ 0.565159103992485035
-0.293525326347479576];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.207910415349708472
-0.107981933026376001];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[3.95337021740261063 3.06890365078710392
9.75946515370444878 8.16349962825509046
24.3356421424505349 21.1815571446980186];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.152791715876124834
0.178750839502435338 0.149519711259435889
0.163972266944542394 0.142720209399075454];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-206.791670046225448+0*%i -1.15500082553547188e-14+188.632179137459985*%i 
 583.657019840486896+0*%i 539.257850852657953+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735+0*%i -7.80247843030111646e-18+0.127428351256665628*%i 
 0.131245392289731255+0*%i 0.121261469963673568+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448
 539.257850852657953];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735
 0.121261469963673568];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-206.754860873488298+3.88638968263160223*%i 3.59605973322256212+188.597787293277349*%i 
 583.551791140428804+11.0485508359642992*%i 539.15884497998502+10.3160557682760921*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139670925479849994+0.00262540692613094304*%i 0.00242927778770507096+0.127405118232369857*%i 
 0.131221729793522368+0.00248445806253726892*%i 0.121239206778007647+0.00231974385669201809*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[0
0
0
1
0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0
0
0
1
0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[2.08333333333333559e-23
1.25000000000000237e-15
5.00000000000000904e-08
 1.00000000000000244
5.00000000000000904e-08];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[2.08333312500000894e-23
1.24999987500000653e-15
4.99999950000002575e-08
 0.999999900000007491
4.99999950000002575e-08];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[0.0221684249243319018
 0.135747669767038337
 0.565159103992485035
 1.26606587775200818
 0.565159103992485035];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.00815530777281429572
 0.0499387768942235674
 0.207910415349708472
 0.465759607593640379
 0.207910415349708472];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[0.959753629496007843 2.2452124409299512 3.95337021740261063 4.8807925858650254 3.95337021740261063
 3.33727577842034417 6.42218937528410549 9.75946515370444878 11.3019219521363308 9.75946515370444878
 10.3311501691511403 17.5056149666242433 24.3356421424505349 27.2398718236044566 24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0477833195680233067 0.111782545296958191 0.196826713297300865 0.243000354161825416 0.196826713297300865
0.0611243380296663044 0.117626501472769041 0.178750839502435338 0.207001921223986723 0.178750839502435338
0.0696107422793332264 0.117951905831511425 0.163972266944542394 0.183540812609328363 0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-115.830821933593796 166.003547805552813 -206.791670046225448 222.658799873011844 -206.791670046225448
 353.667434053872967 482.978130151889332 583.657019840486896 621.944087256767148 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0782482115787162397 0.112141833362395943 -0.139695791503316735 0.15041465295234574 -0.139695791503316735
 0.0795282495448936949 0.10860599976415887 0.131245392289731255 0.13985490269028536 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-115.806987973557767+2.36787822565576178*%i 165.972275485088261-3.22602277348055821*%i -206.754860873488298+3.88638968263160223*%i 222.619934807221995-4.13558800345596822*%i -206.754860873488298+3.88638968263160223*%i 
 353.59617287966239+7.13289457851560726*%i 482.887220066322243+9.37265623194608821*%i 583.551791140428804+11.0485508359642992*%i 621.83359839173761+11.6724388635437393*%i 583.551791140428804+11.0485508359642992*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0782321108145454941+0.00159959355636766533*%i 0.112120707697331859-0.0021793034731445015*%i -0.139670925479849994+0.00262540692613094304*%i 0.150388398093404263-0.00279375005456099917*%i -0.139670925479849994+0.00262540692613094304*%i 
 0.0795122252353311354+0.00160395491752061796*%i 0.108585557056476545+0.00210760412732592488*%i 0.131221729793522368+0.00248445806253726892*%i 0.139830057354854626+0.00262475009388627757*%i 0.131221729793522368+0.00248445806253726892*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
 0
 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
 0
 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -716418914.617634058
 119.4031524362738
8.52879660259097461e-06
2.50846958899735057e-13];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ -716418842.975746155
 119.40314049595915
 8.5287957497113638e-06
2.50846933815040007e-13];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[-0.00591345243084812067
 1.31287485767574874
 0.781811462174600069
 0.218338810631307279];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.00217543757565433205
 0.482979668969791387
 0.287612363806220073
 0.0803223596410826829];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[3.42784262863483091 4.79637514536136766 4.38711765770707274 2.74905357176475196
8.83635341206673885 11.1547232979699871 10.5095619067623254 7.47637663060326574
22.5339420651292528 26.9640105739216374 25.769623334000169 19.748516040401924];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.170662235306120791 0.238797457280029851 0.218421726762125123 0.136867318124372278
0.161843458188648509 0.204305883829368262 0.192489340763055378 0.136934614562300605
0.151832507315303511 0.181682074129864174 0.173634356210889323 0.133064454390817377];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-115.528257289707909+159.011004637095994*%i 130.005765210304077-178.93758479248288*%i -126.213662649461014+173.718203387166*%i 105.800405250135611-145.621764964810097*%i 
 558.692156624643758+0*%i 618.392276361135487+0*%i 602.863033507589421+0*%i 517.915104109878143+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0780438174297686527+0.107418099314886509*%i 0.0878239353983073789-0.120879276866858537*%i -0.0852622230789458618+0.117353382345041141*%i 0.0714722761776889204-0.0983731487458936044*%i 
 0.125631610299893642+0*%i 0.139056216478195355+0*%i 0.135564197191194807+0*%i 0.116462183612997774+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-112.495189456596478+161.170833250149371*%i 126.65593794917838-181.323571297084129*%i -122.946019082064936+176.045508070116654*%i 102.984927987823909-147.626271146547765*%i 
 558.590410007747664+10.6379090184516407*%i 618.282271535315886+11.6148531401744517*%i 602.755154351263172+11.3623872324082811*%i 517.819139778511499+9.96031986752753085*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0759948625007086653+0.108877147290777257*%i 0.0855609971932155405-0.122491103267805976*%i -0.083054803145657094+0.118925566900064547*%i 0.0695703121163207677-0.099727270396773135*%i 
 0.125608730810407965+0.00239211813583725934*%i 0.139031479987366591+0.00261180094636132183*%i 0.135539938693977013+0.00255502961323555641*%i 0.116440604370586717+0.00223975047657633264*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
 0
 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
 0
 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 18626891780058524
 -716418914.617634058
 119.4031524362738
8.52879660259097461e-06
2.50846958899735057e-13];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 18626889917369436
 -716418842.975746155
 119.40314049595915
 8.5287957497113638e-06
2.50846933815040007e-13];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 1.32824983399595298
-0.00591345243084812067
 1.31287485767574874
 0.781811462174600069
 0.218338810631307279];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.488635806666492145
-0.00217543757565433205
 0.482979668969791387
 0.287612363806220073
 0.0803223596410826829];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[1.82557820054454689 3.42784262863483091 4.79637514536136766 4.38711765770707274 2.74905357176475196
5.41109358012660024 8.83635341206673885 11.1547232979699871 10.5095619067623254 7.47637663060326574
15.2463607000543995 22.5339420651292528 26.9640105739216374 25.769623334000169 19.748516040401924];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0908901866813934256 0.170662235306120791 0.238797457280029851 0.218421726762125123 0.136867318124372278
0.0991076360067466022 0.161843458188648509 0.204305883829368262 0.192489340763055378 0.136934614562300605
 0.102729170325906158 0.151832507315303511 0.181682074129864174 0.173634356210889323 0.133064454390817377];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[88.8587146687642502-122.303528346393549*%i -115.528257289707909+159.011004637095994*%i 130.005765210304077-178.93758479248288*%i -126.213662649461014+173.718203387166*%i 105.800405250135611-145.621764964810097*%i 
445.463751691602113+0*%i 558.692156624643758+0*%i 618.392276361135487+0*%i 602.863033507589421+0*%i 517.915104109878143+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0600275072726362963-0.0826207757410083593*%i -0.0780438174297686527+0.107418099314886509*%i 0.0878239353983073789-0.120879276866858537*%i -0.0852622230789458618+0.117353382345041141*%i 0.0714722761776889204-0.0983731487458936044*%i 
 0.100170241861561399+0*%i 0.125631610299893642+0*%i 0.139056216478195355+0*%i 0.135564197191194807+0*%i 0.116462183612997774+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[86.4321907223755943-124.030462871624579*%i -112.495189456596478+161.170833250149371*%i 126.65593794917838-181.323571297084129*%i -122.946019082064936+176.045508070116654*%i 102.984927987823909-147.626271146547765*%i 
445.378380318171139+8.73384294688499807*%i 558.590410007747664+10.6379090184516407*%i 618.282271535315886+11.6148531401744517*%i 602.755154351263172+11.3623872324082811*%i 517.819139778511499+9.96031986752753085*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0583882962579143558-0.0837873869750229289*%i -0.0759948625007086653+0.108877147290777257*%i 0.0855609971932155405-0.122491103267805976*%i -0.083054803145657094+0.118925566900064547*%i 0.0695703121163207677-0.099727270396773135*%i 
 0.100151044629256544+0.0019639558932643352*%i 0.125608730810407965+0.00239211813583725934*%i 0.139031479987366591+0.00261180094636132183*%i 0.135539938693977013+0.00255502961323555641*%i 0.116440604370586717+0.00223975047657633264*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
