
#include <schroedinger/schrotables.h>

#define X(a,b) (((a)<<4)|(b))
const int16_t schro_table_unpack_sint[1024][10] = {
  /*   0 */ {  X(15,0), },
  /*   1 */ {  X(15,0), },
  /*   2 */ {  X(15,10), },
  /*   3 */ {  X(-15,10), },
  /*   4 */ {  X(16,0), },
  /*   5 */ {  X(16,0), },
  /*   6 */ {  X(16,10), },
  /*   7 */ {  X(-16,10), },
  /*   8 */ {  X(7,8), },
  /*   9 */ {  X(7,8), },
  /*  10 */ {  X(7,8),  X(0,9), },
  /*  11 */ {  X(7,8),  X(0,9),  X(0,10), },
  /*  12 */ {  X(-7,8), },
  /*  13 */ {  X(-7,8), },
  /*  14 */ {  X(-7,8),  X(0,9), },
  /*  15 */ {  X(-7,8),  X(0,9),  X(0,10), },
  /*  16 */ {  X(17,0), },
  /*  17 */ {  X(17,0), },
  /*  18 */ {  X(17,10), },
  /*  19 */ {  X(-17,10), },
  /*  20 */ {  X(18,0), },
  /*  21 */ {  X(18,0), },
  /*  22 */ {  X(18,10), },
  /*  23 */ {  X(-18,10), },
  /*  24 */ {  X(8,8), },
  /*  25 */ {  X(8,8), },
  /*  26 */ {  X(8,8),  X(0,9), },
  /*  27 */ {  X(8,8),  X(0,9),  X(0,10), },
  /*  28 */ {  X(-8,8), },
  /*  29 */ {  X(-8,8), },
  /*  30 */ {  X(-8,8),  X(0,9), },
  /*  31 */ {  X(-8,8),  X(0,9),  X(0,10), },
  /*  32 */ {  X(3,6), },
  /*  33 */ {  X(3,6), },
  /*  34 */ {  X(3,6),  X(1,10), },
  /*  35 */ {  X(3,6),  X(-1,10), },
  /*  36 */ {  X(3,6), },
  /*  37 */ {  X(3,6), },
  /*  38 */ {  X(3,6),  X(2,10), },
  /*  39 */ {  X(3,6),  X(-2,10), },
  /*  40 */ {  X(3,6),  X(0,7), },
  /*  41 */ {  X(3,6),  X(0,7), },
  /*  42 */ {  X(3,6),  X(0,7), },
  /*  43 */ {  X(3,6),  X(0,7), },
  /*  44 */ {  X(3,6),  X(0,7),  X(0,8), },
  /*  45 */ {  X(3,6),  X(0,7),  X(0,8), },
  /*  46 */ {  X(3,6),  X(0,7),  X(0,8),  X(0,9), },
  /*  47 */ {  X(3,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /*  48 */ {  X(-3,6), },
  /*  49 */ {  X(-3,6), },
  /*  50 */ {  X(-3,6),  X(1,10), },
  /*  51 */ {  X(-3,6),  X(-1,10), },
  /*  52 */ {  X(-3,6), },
  /*  53 */ {  X(-3,6), },
  /*  54 */ {  X(-3,6),  X(2,10), },
  /*  55 */ {  X(-3,6),  X(-2,10), },
  /*  56 */ {  X(-3,6),  X(0,7), },
  /*  57 */ {  X(-3,6),  X(0,7), },
  /*  58 */ {  X(-3,6),  X(0,7), },
  /*  59 */ {  X(-3,6),  X(0,7), },
  /*  60 */ {  X(-3,6),  X(0,7),  X(0,8), },
  /*  61 */ {  X(-3,6),  X(0,7),  X(0,8), },
  /*  62 */ {  X(-3,6),  X(0,7),  X(0,8),  X(0,9), },
  /*  63 */ {  X(-3,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /*  64 */ {  X(19,0), },
  /*  65 */ {  X(19,0), },
  /*  66 */ {  X(19,10), },
  /*  67 */ {  X(-19,10), },
  /*  68 */ {  X(20,0), },
  /*  69 */ {  X(20,0), },
  /*  70 */ {  X(20,10), },
  /*  71 */ {  X(-20,10), },
  /*  72 */ {  X(9,8), },
  /*  73 */ {  X(9,8), },
  /*  74 */ {  X(9,8),  X(0,9), },
  /*  75 */ {  X(9,8),  X(0,9),  X(0,10), },
  /*  76 */ {  X(-9,8), },
  /*  77 */ {  X(-9,8), },
  /*  78 */ {  X(-9,8),  X(0,9), },
  /*  79 */ {  X(-9,8),  X(0,9),  X(0,10), },
  /*  80 */ {  X(21,0), },
  /*  81 */ {  X(21,0), },
  /*  82 */ {  X(21,10), },
  /*  83 */ {  X(-21,10), },
  /*  84 */ {  X(22,0), },
  /*  85 */ {  X(22,0), },
  /*  86 */ {  X(22,10), },
  /*  87 */ {  X(-22,10), },
  /*  88 */ {  X(10,8), },
  /*  89 */ {  X(10,8), },
  /*  90 */ {  X(10,8),  X(0,9), },
  /*  91 */ {  X(10,8),  X(0,9),  X(0,10), },
  /*  92 */ {  X(-10,8), },
  /*  93 */ {  X(-10,8), },
  /*  94 */ {  X(-10,8),  X(0,9), },
  /*  95 */ {  X(-10,8),  X(0,9),  X(0,10), },
  /*  96 */ {  X(4,6), },
  /*  97 */ {  X(4,6), },
  /*  98 */ {  X(4,6),  X(1,10), },
  /*  99 */ {  X(4,6),  X(-1,10), },
  /* 100 */ {  X(4,6), },
  /* 101 */ {  X(4,6), },
  /* 102 */ {  X(4,6),  X(2,10), },
  /* 103 */ {  X(4,6),  X(-2,10), },
  /* 104 */ {  X(4,6),  X(0,7), },
  /* 105 */ {  X(4,6),  X(0,7), },
  /* 106 */ {  X(4,6),  X(0,7), },
  /* 107 */ {  X(4,6),  X(0,7), },
  /* 108 */ {  X(4,6),  X(0,7),  X(0,8), },
  /* 109 */ {  X(4,6),  X(0,7),  X(0,8), },
  /* 110 */ {  X(4,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 111 */ {  X(4,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 112 */ {  X(-4,6), },
  /* 113 */ {  X(-4,6), },
  /* 114 */ {  X(-4,6),  X(1,10), },
  /* 115 */ {  X(-4,6),  X(-1,10), },
  /* 116 */ {  X(-4,6), },
  /* 117 */ {  X(-4,6), },
  /* 118 */ {  X(-4,6),  X(2,10), },
  /* 119 */ {  X(-4,6),  X(-2,10), },
  /* 120 */ {  X(-4,6),  X(0,7), },
  /* 121 */ {  X(-4,6),  X(0,7), },
  /* 122 */ {  X(-4,6),  X(0,7), },
  /* 123 */ {  X(-4,6),  X(0,7), },
  /* 124 */ {  X(-4,6),  X(0,7),  X(0,8), },
  /* 125 */ {  X(-4,6),  X(0,7),  X(0,8), },
  /* 126 */ {  X(-4,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 127 */ {  X(-4,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 128 */ {  X(1,4), },
  /* 129 */ {  X(1,4), },
  /* 130 */ {  X(1,4),  X(3,10), },
  /* 131 */ {  X(1,4),  X(-3,10), },
  /* 132 */ {  X(1,4), },
  /* 133 */ {  X(1,4), },
  /* 134 */ {  X(1,4),  X(4,10), },
  /* 135 */ {  X(1,4),  X(-4,10), },
  /* 136 */ {  X(1,4),  X(1,8), },
  /* 137 */ {  X(1,4),  X(1,8), },
  /* 138 */ {  X(1,4),  X(1,8),  X(0,9), },
  /* 139 */ {  X(1,4),  X(1,8),  X(0,9),  X(0,10), },
  /* 140 */ {  X(1,4),  X(-1,8), },
  /* 141 */ {  X(1,4),  X(-1,8), },
  /* 142 */ {  X(1,4),  X(-1,8),  X(0,9), },
  /* 143 */ {  X(1,4),  X(-1,8),  X(0,9),  X(0,10), },
  /* 144 */ {  X(1,4), },
  /* 145 */ {  X(1,4), },
  /* 146 */ {  X(1,4),  X(5,10), },
  /* 147 */ {  X(1,4),  X(-5,10), },
  /* 148 */ {  X(1,4), },
  /* 149 */ {  X(1,4), },
  /* 150 */ {  X(1,4),  X(6,10), },
  /* 151 */ {  X(1,4),  X(-6,10), },
  /* 152 */ {  X(1,4),  X(2,8), },
  /* 153 */ {  X(1,4),  X(2,8), },
  /* 154 */ {  X(1,4),  X(2,8),  X(0,9), },
  /* 155 */ {  X(1,4),  X(2,8),  X(0,9),  X(0,10), },
  /* 156 */ {  X(1,4),  X(-2,8), },
  /* 157 */ {  X(1,4),  X(-2,8), },
  /* 158 */ {  X(1,4),  X(-2,8),  X(0,9), },
  /* 159 */ {  X(1,4),  X(-2,8),  X(0,9),  X(0,10), },
  /* 160 */ {  X(1,4),  X(0,5), },
  /* 161 */ {  X(1,4),  X(0,5), },
  /* 162 */ {  X(1,4),  X(0,5), },
  /* 163 */ {  X(1,4),  X(0,5), },
  /* 164 */ {  X(1,4),  X(0,5),  X(1,9), },
  /* 165 */ {  X(1,4),  X(0,5),  X(1,9),  X(0,10), },
  /* 166 */ {  X(1,4),  X(0,5),  X(-1,9), },
  /* 167 */ {  X(1,4),  X(0,5),  X(-1,9),  X(0,10), },
  /* 168 */ {  X(1,4),  X(0,5), },
  /* 169 */ {  X(1,4),  X(0,5), },
  /* 170 */ {  X(1,4),  X(0,5), },
  /* 171 */ {  X(1,4),  X(0,5), },
  /* 172 */ {  X(1,4),  X(0,5),  X(2,9), },
  /* 173 */ {  X(1,4),  X(0,5),  X(2,9),  X(0,10), },
  /* 174 */ {  X(1,4),  X(0,5),  X(-2,9), },
  /* 175 */ {  X(1,4),  X(0,5),  X(-2,9),  X(0,10), },
  /* 176 */ {  X(1,4),  X(0,5),  X(0,6), },
  /* 177 */ {  X(1,4),  X(0,5),  X(0,6), },
  /* 178 */ {  X(1,4),  X(0,5),  X(0,6),  X(1,10), },
  /* 179 */ {  X(1,4),  X(0,5),  X(0,6),  X(-1,10), },
  /* 180 */ {  X(1,4),  X(0,5),  X(0,6), },
  /* 181 */ {  X(1,4),  X(0,5),  X(0,6), },
  /* 182 */ {  X(1,4),  X(0,5),  X(0,6),  X(2,10), },
  /* 183 */ {  X(1,4),  X(0,5),  X(0,6),  X(-2,10), },
  /* 184 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 185 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 186 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 187 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 188 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 189 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 190 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 191 */ {  X(1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 192 */ {  X(-1,4), },
  /* 193 */ {  X(-1,4), },
  /* 194 */ {  X(-1,4),  X(3,10), },
  /* 195 */ {  X(-1,4),  X(-3,10), },
  /* 196 */ {  X(-1,4), },
  /* 197 */ {  X(-1,4), },
  /* 198 */ {  X(-1,4),  X(4,10), },
  /* 199 */ {  X(-1,4),  X(-4,10), },
  /* 200 */ {  X(-1,4),  X(1,8), },
  /* 201 */ {  X(-1,4),  X(1,8), },
  /* 202 */ {  X(-1,4),  X(1,8),  X(0,9), },
  /* 203 */ {  X(-1,4),  X(1,8),  X(0,9),  X(0,10), },
  /* 204 */ {  X(-1,4),  X(-1,8), },
  /* 205 */ {  X(-1,4),  X(-1,8), },
  /* 206 */ {  X(-1,4),  X(-1,8),  X(0,9), },
  /* 207 */ {  X(-1,4),  X(-1,8),  X(0,9),  X(0,10), },
  /* 208 */ {  X(-1,4), },
  /* 209 */ {  X(-1,4), },
  /* 210 */ {  X(-1,4),  X(5,10), },
  /* 211 */ {  X(-1,4),  X(-5,10), },
  /* 212 */ {  X(-1,4), },
  /* 213 */ {  X(-1,4), },
  /* 214 */ {  X(-1,4),  X(6,10), },
  /* 215 */ {  X(-1,4),  X(-6,10), },
  /* 216 */ {  X(-1,4),  X(2,8), },
  /* 217 */ {  X(-1,4),  X(2,8), },
  /* 218 */ {  X(-1,4),  X(2,8),  X(0,9), },
  /* 219 */ {  X(-1,4),  X(2,8),  X(0,9),  X(0,10), },
  /* 220 */ {  X(-1,4),  X(-2,8), },
  /* 221 */ {  X(-1,4),  X(-2,8), },
  /* 222 */ {  X(-1,4),  X(-2,8),  X(0,9), },
  /* 223 */ {  X(-1,4),  X(-2,8),  X(0,9),  X(0,10), },
  /* 224 */ {  X(-1,4),  X(0,5), },
  /* 225 */ {  X(-1,4),  X(0,5), },
  /* 226 */ {  X(-1,4),  X(0,5), },
  /* 227 */ {  X(-1,4),  X(0,5), },
  /* 228 */ {  X(-1,4),  X(0,5),  X(1,9), },
  /* 229 */ {  X(-1,4),  X(0,5),  X(1,9),  X(0,10), },
  /* 230 */ {  X(-1,4),  X(0,5),  X(-1,9), },
  /* 231 */ {  X(-1,4),  X(0,5),  X(-1,9),  X(0,10), },
  /* 232 */ {  X(-1,4),  X(0,5), },
  /* 233 */ {  X(-1,4),  X(0,5), },
  /* 234 */ {  X(-1,4),  X(0,5), },
  /* 235 */ {  X(-1,4),  X(0,5), },
  /* 236 */ {  X(-1,4),  X(0,5),  X(2,9), },
  /* 237 */ {  X(-1,4),  X(0,5),  X(2,9),  X(0,10), },
  /* 238 */ {  X(-1,4),  X(0,5),  X(-2,9), },
  /* 239 */ {  X(-1,4),  X(0,5),  X(-2,9),  X(0,10), },
  /* 240 */ {  X(-1,4),  X(0,5),  X(0,6), },
  /* 241 */ {  X(-1,4),  X(0,5),  X(0,6), },
  /* 242 */ {  X(-1,4),  X(0,5),  X(0,6),  X(1,10), },
  /* 243 */ {  X(-1,4),  X(0,5),  X(0,6),  X(-1,10), },
  /* 244 */ {  X(-1,4),  X(0,5),  X(0,6), },
  /* 245 */ {  X(-1,4),  X(0,5),  X(0,6), },
  /* 246 */ {  X(-1,4),  X(0,5),  X(0,6),  X(2,10), },
  /* 247 */ {  X(-1,4),  X(0,5),  X(0,6),  X(-2,10), },
  /* 248 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 249 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 250 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 251 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 252 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 253 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 254 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 255 */ {  X(-1,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 256 */ {  X(23,0), },
  /* 257 */ {  X(23,0), },
  /* 258 */ {  X(23,10), },
  /* 259 */ {  X(-23,10), },
  /* 260 */ {  X(24,0), },
  /* 261 */ {  X(24,0), },
  /* 262 */ {  X(24,10), },
  /* 263 */ {  X(-24,10), },
  /* 264 */ {  X(11,8), },
  /* 265 */ {  X(11,8), },
  /* 266 */ {  X(11,8),  X(0,9), },
  /* 267 */ {  X(11,8),  X(0,9),  X(0,10), },
  /* 268 */ {  X(-11,8), },
  /* 269 */ {  X(-11,8), },
  /* 270 */ {  X(-11,8),  X(0,9), },
  /* 271 */ {  X(-11,8),  X(0,9),  X(0,10), },
  /* 272 */ {  X(25,0), },
  /* 273 */ {  X(25,0), },
  /* 274 */ {  X(25,10), },
  /* 275 */ {  X(-25,10), },
  /* 276 */ {  X(26,0), },
  /* 277 */ {  X(26,0), },
  /* 278 */ {  X(26,10), },
  /* 279 */ {  X(-26,10), },
  /* 280 */ {  X(12,8), },
  /* 281 */ {  X(12,8), },
  /* 282 */ {  X(12,8),  X(0,9), },
  /* 283 */ {  X(12,8),  X(0,9),  X(0,10), },
  /* 284 */ {  X(-12,8), },
  /* 285 */ {  X(-12,8), },
  /* 286 */ {  X(-12,8),  X(0,9), },
  /* 287 */ {  X(-12,8),  X(0,9),  X(0,10), },
  /* 288 */ {  X(5,6), },
  /* 289 */ {  X(5,6), },
  /* 290 */ {  X(5,6),  X(1,10), },
  /* 291 */ {  X(5,6),  X(-1,10), },
  /* 292 */ {  X(5,6), },
  /* 293 */ {  X(5,6), },
  /* 294 */ {  X(5,6),  X(2,10), },
  /* 295 */ {  X(5,6),  X(-2,10), },
  /* 296 */ {  X(5,6),  X(0,7), },
  /* 297 */ {  X(5,6),  X(0,7), },
  /* 298 */ {  X(5,6),  X(0,7), },
  /* 299 */ {  X(5,6),  X(0,7), },
  /* 300 */ {  X(5,6),  X(0,7),  X(0,8), },
  /* 301 */ {  X(5,6),  X(0,7),  X(0,8), },
  /* 302 */ {  X(5,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 303 */ {  X(5,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 304 */ {  X(-5,6), },
  /* 305 */ {  X(-5,6), },
  /* 306 */ {  X(-5,6),  X(1,10), },
  /* 307 */ {  X(-5,6),  X(-1,10), },
  /* 308 */ {  X(-5,6), },
  /* 309 */ {  X(-5,6), },
  /* 310 */ {  X(-5,6),  X(2,10), },
  /* 311 */ {  X(-5,6),  X(-2,10), },
  /* 312 */ {  X(-5,6),  X(0,7), },
  /* 313 */ {  X(-5,6),  X(0,7), },
  /* 314 */ {  X(-5,6),  X(0,7), },
  /* 315 */ {  X(-5,6),  X(0,7), },
  /* 316 */ {  X(-5,6),  X(0,7),  X(0,8), },
  /* 317 */ {  X(-5,6),  X(0,7),  X(0,8), },
  /* 318 */ {  X(-5,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 319 */ {  X(-5,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 320 */ {  X(27,0), },
  /* 321 */ {  X(27,0), },
  /* 322 */ {  X(27,10), },
  /* 323 */ {  X(-27,10), },
  /* 324 */ {  X(28,0), },
  /* 325 */ {  X(28,0), },
  /* 326 */ {  X(28,10), },
  /* 327 */ {  X(-28,10), },
  /* 328 */ {  X(13,8), },
  /* 329 */ {  X(13,8), },
  /* 330 */ {  X(13,8),  X(0,9), },
  /* 331 */ {  X(13,8),  X(0,9),  X(0,10), },
  /* 332 */ {  X(-13,8), },
  /* 333 */ {  X(-13,8), },
  /* 334 */ {  X(-13,8),  X(0,9), },
  /* 335 */ {  X(-13,8),  X(0,9),  X(0,10), },
  /* 336 */ {  X(29,0), },
  /* 337 */ {  X(29,0), },
  /* 338 */ {  X(29,10), },
  /* 339 */ {  X(-29,10), },
  /* 340 */ {  X(30,0), },
  /* 341 */ {  X(30,0), },
  /* 342 */ {  X(30,10), },
  /* 343 */ {  X(-30,10), },
  /* 344 */ {  X(14,8), },
  /* 345 */ {  X(14,8), },
  /* 346 */ {  X(14,8),  X(0,9), },
  /* 347 */ {  X(14,8),  X(0,9),  X(0,10), },
  /* 348 */ {  X(-14,8), },
  /* 349 */ {  X(-14,8), },
  /* 350 */ {  X(-14,8),  X(0,9), },
  /* 351 */ {  X(-14,8),  X(0,9),  X(0,10), },
  /* 352 */ {  X(6,6), },
  /* 353 */ {  X(6,6), },
  /* 354 */ {  X(6,6),  X(1,10), },
  /* 355 */ {  X(6,6),  X(-1,10), },
  /* 356 */ {  X(6,6), },
  /* 357 */ {  X(6,6), },
  /* 358 */ {  X(6,6),  X(2,10), },
  /* 359 */ {  X(6,6),  X(-2,10), },
  /* 360 */ {  X(6,6),  X(0,7), },
  /* 361 */ {  X(6,6),  X(0,7), },
  /* 362 */ {  X(6,6),  X(0,7), },
  /* 363 */ {  X(6,6),  X(0,7), },
  /* 364 */ {  X(6,6),  X(0,7),  X(0,8), },
  /* 365 */ {  X(6,6),  X(0,7),  X(0,8), },
  /* 366 */ {  X(6,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 367 */ {  X(6,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 368 */ {  X(-6,6), },
  /* 369 */ {  X(-6,6), },
  /* 370 */ {  X(-6,6),  X(1,10), },
  /* 371 */ {  X(-6,6),  X(-1,10), },
  /* 372 */ {  X(-6,6), },
  /* 373 */ {  X(-6,6), },
  /* 374 */ {  X(-6,6),  X(2,10), },
  /* 375 */ {  X(-6,6),  X(-2,10), },
  /* 376 */ {  X(-6,6),  X(0,7), },
  /* 377 */ {  X(-6,6),  X(0,7), },
  /* 378 */ {  X(-6,6),  X(0,7), },
  /* 379 */ {  X(-6,6),  X(0,7), },
  /* 380 */ {  X(-6,6),  X(0,7),  X(0,8), },
  /* 381 */ {  X(-6,6),  X(0,7),  X(0,8), },
  /* 382 */ {  X(-6,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 383 */ {  X(-6,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 384 */ {  X(2,4), },
  /* 385 */ {  X(2,4), },
  /* 386 */ {  X(2,4),  X(3,10), },
  /* 387 */ {  X(2,4),  X(-3,10), },
  /* 388 */ {  X(2,4), },
  /* 389 */ {  X(2,4), },
  /* 390 */ {  X(2,4),  X(4,10), },
  /* 391 */ {  X(2,4),  X(-4,10), },
  /* 392 */ {  X(2,4),  X(1,8), },
  /* 393 */ {  X(2,4),  X(1,8), },
  /* 394 */ {  X(2,4),  X(1,8),  X(0,9), },
  /* 395 */ {  X(2,4),  X(1,8),  X(0,9),  X(0,10), },
  /* 396 */ {  X(2,4),  X(-1,8), },
  /* 397 */ {  X(2,4),  X(-1,8), },
  /* 398 */ {  X(2,4),  X(-1,8),  X(0,9), },
  /* 399 */ {  X(2,4),  X(-1,8),  X(0,9),  X(0,10), },
  /* 400 */ {  X(2,4), },
  /* 401 */ {  X(2,4), },
  /* 402 */ {  X(2,4),  X(5,10), },
  /* 403 */ {  X(2,4),  X(-5,10), },
  /* 404 */ {  X(2,4), },
  /* 405 */ {  X(2,4), },
  /* 406 */ {  X(2,4),  X(6,10), },
  /* 407 */ {  X(2,4),  X(-6,10), },
  /* 408 */ {  X(2,4),  X(2,8), },
  /* 409 */ {  X(2,4),  X(2,8), },
  /* 410 */ {  X(2,4),  X(2,8),  X(0,9), },
  /* 411 */ {  X(2,4),  X(2,8),  X(0,9),  X(0,10), },
  /* 412 */ {  X(2,4),  X(-2,8), },
  /* 413 */ {  X(2,4),  X(-2,8), },
  /* 414 */ {  X(2,4),  X(-2,8),  X(0,9), },
  /* 415 */ {  X(2,4),  X(-2,8),  X(0,9),  X(0,10), },
  /* 416 */ {  X(2,4),  X(0,5), },
  /* 417 */ {  X(2,4),  X(0,5), },
  /* 418 */ {  X(2,4),  X(0,5), },
  /* 419 */ {  X(2,4),  X(0,5), },
  /* 420 */ {  X(2,4),  X(0,5),  X(1,9), },
  /* 421 */ {  X(2,4),  X(0,5),  X(1,9),  X(0,10), },
  /* 422 */ {  X(2,4),  X(0,5),  X(-1,9), },
  /* 423 */ {  X(2,4),  X(0,5),  X(-1,9),  X(0,10), },
  /* 424 */ {  X(2,4),  X(0,5), },
  /* 425 */ {  X(2,4),  X(0,5), },
  /* 426 */ {  X(2,4),  X(0,5), },
  /* 427 */ {  X(2,4),  X(0,5), },
  /* 428 */ {  X(2,4),  X(0,5),  X(2,9), },
  /* 429 */ {  X(2,4),  X(0,5),  X(2,9),  X(0,10), },
  /* 430 */ {  X(2,4),  X(0,5),  X(-2,9), },
  /* 431 */ {  X(2,4),  X(0,5),  X(-2,9),  X(0,10), },
  /* 432 */ {  X(2,4),  X(0,5),  X(0,6), },
  /* 433 */ {  X(2,4),  X(0,5),  X(0,6), },
  /* 434 */ {  X(2,4),  X(0,5),  X(0,6),  X(1,10), },
  /* 435 */ {  X(2,4),  X(0,5),  X(0,6),  X(-1,10), },
  /* 436 */ {  X(2,4),  X(0,5),  X(0,6), },
  /* 437 */ {  X(2,4),  X(0,5),  X(0,6), },
  /* 438 */ {  X(2,4),  X(0,5),  X(0,6),  X(2,10), },
  /* 439 */ {  X(2,4),  X(0,5),  X(0,6),  X(-2,10), },
  /* 440 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 441 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 442 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 443 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 444 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 445 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 446 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 447 */ {  X(2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 448 */ {  X(-2,4), },
  /* 449 */ {  X(-2,4), },
  /* 450 */ {  X(-2,4),  X(3,10), },
  /* 451 */ {  X(-2,4),  X(-3,10), },
  /* 452 */ {  X(-2,4), },
  /* 453 */ {  X(-2,4), },
  /* 454 */ {  X(-2,4),  X(4,10), },
  /* 455 */ {  X(-2,4),  X(-4,10), },
  /* 456 */ {  X(-2,4),  X(1,8), },
  /* 457 */ {  X(-2,4),  X(1,8), },
  /* 458 */ {  X(-2,4),  X(1,8),  X(0,9), },
  /* 459 */ {  X(-2,4),  X(1,8),  X(0,9),  X(0,10), },
  /* 460 */ {  X(-2,4),  X(-1,8), },
  /* 461 */ {  X(-2,4),  X(-1,8), },
  /* 462 */ {  X(-2,4),  X(-1,8),  X(0,9), },
  /* 463 */ {  X(-2,4),  X(-1,8),  X(0,9),  X(0,10), },
  /* 464 */ {  X(-2,4), },
  /* 465 */ {  X(-2,4), },
  /* 466 */ {  X(-2,4),  X(5,10), },
  /* 467 */ {  X(-2,4),  X(-5,10), },
  /* 468 */ {  X(-2,4), },
  /* 469 */ {  X(-2,4), },
  /* 470 */ {  X(-2,4),  X(6,10), },
  /* 471 */ {  X(-2,4),  X(-6,10), },
  /* 472 */ {  X(-2,4),  X(2,8), },
  /* 473 */ {  X(-2,4),  X(2,8), },
  /* 474 */ {  X(-2,4),  X(2,8),  X(0,9), },
  /* 475 */ {  X(-2,4),  X(2,8),  X(0,9),  X(0,10), },
  /* 476 */ {  X(-2,4),  X(-2,8), },
  /* 477 */ {  X(-2,4),  X(-2,8), },
  /* 478 */ {  X(-2,4),  X(-2,8),  X(0,9), },
  /* 479 */ {  X(-2,4),  X(-2,8),  X(0,9),  X(0,10), },
  /* 480 */ {  X(-2,4),  X(0,5), },
  /* 481 */ {  X(-2,4),  X(0,5), },
  /* 482 */ {  X(-2,4),  X(0,5), },
  /* 483 */ {  X(-2,4),  X(0,5), },
  /* 484 */ {  X(-2,4),  X(0,5),  X(1,9), },
  /* 485 */ {  X(-2,4),  X(0,5),  X(1,9),  X(0,10), },
  /* 486 */ {  X(-2,4),  X(0,5),  X(-1,9), },
  /* 487 */ {  X(-2,4),  X(0,5),  X(-1,9),  X(0,10), },
  /* 488 */ {  X(-2,4),  X(0,5), },
  /* 489 */ {  X(-2,4),  X(0,5), },
  /* 490 */ {  X(-2,4),  X(0,5), },
  /* 491 */ {  X(-2,4),  X(0,5), },
  /* 492 */ {  X(-2,4),  X(0,5),  X(2,9), },
  /* 493 */ {  X(-2,4),  X(0,5),  X(2,9),  X(0,10), },
  /* 494 */ {  X(-2,4),  X(0,5),  X(-2,9), },
  /* 495 */ {  X(-2,4),  X(0,5),  X(-2,9),  X(0,10), },
  /* 496 */ {  X(-2,4),  X(0,5),  X(0,6), },
  /* 497 */ {  X(-2,4),  X(0,5),  X(0,6), },
  /* 498 */ {  X(-2,4),  X(0,5),  X(0,6),  X(1,10), },
  /* 499 */ {  X(-2,4),  X(0,5),  X(0,6),  X(-1,10), },
  /* 500 */ {  X(-2,4),  X(0,5),  X(0,6), },
  /* 501 */ {  X(-2,4),  X(0,5),  X(0,6), },
  /* 502 */ {  X(-2,4),  X(0,5),  X(0,6),  X(2,10), },
  /* 503 */ {  X(-2,4),  X(0,5),  X(0,6),  X(-2,10), },
  /* 504 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 505 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 506 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 507 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 508 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 509 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 510 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 511 */ {  X(-2,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 512 */ {  X(0,1), },
  /* 513 */ {  X(0,1), },
  /* 514 */ {  X(0,1), },
  /* 515 */ {  X(0,1), },
  /* 516 */ {  X(0,1),  X(7,9), },
  /* 517 */ {  X(0,1),  X(7,9),  X(0,10), },
  /* 518 */ {  X(0,1),  X(-7,9), },
  /* 519 */ {  X(0,1),  X(-7,9),  X(0,10), },
  /* 520 */ {  X(0,1), },
  /* 521 */ {  X(0,1), },
  /* 522 */ {  X(0,1), },
  /* 523 */ {  X(0,1), },
  /* 524 */ {  X(0,1),  X(8,9), },
  /* 525 */ {  X(0,1),  X(8,9),  X(0,10), },
  /* 526 */ {  X(0,1),  X(-8,9), },
  /* 527 */ {  X(0,1),  X(-8,9),  X(0,10), },
  /* 528 */ {  X(0,1),  X(3,7), },
  /* 529 */ {  X(0,1),  X(3,7), },
  /* 530 */ {  X(0,1),  X(3,7), },
  /* 531 */ {  X(0,1),  X(3,7), },
  /* 532 */ {  X(0,1),  X(3,7),  X(0,8), },
  /* 533 */ {  X(0,1),  X(3,7),  X(0,8), },
  /* 534 */ {  X(0,1),  X(3,7),  X(0,8),  X(0,9), },
  /* 535 */ {  X(0,1),  X(3,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 536 */ {  X(0,1),  X(-3,7), },
  /* 537 */ {  X(0,1),  X(-3,7), },
  /* 538 */ {  X(0,1),  X(-3,7), },
  /* 539 */ {  X(0,1),  X(-3,7), },
  /* 540 */ {  X(0,1),  X(-3,7),  X(0,8), },
  /* 541 */ {  X(0,1),  X(-3,7),  X(0,8), },
  /* 542 */ {  X(0,1),  X(-3,7),  X(0,8),  X(0,9), },
  /* 543 */ {  X(0,1),  X(-3,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 544 */ {  X(0,1), },
  /* 545 */ {  X(0,1), },
  /* 546 */ {  X(0,1), },
  /* 547 */ {  X(0,1), },
  /* 548 */ {  X(0,1),  X(9,9), },
  /* 549 */ {  X(0,1),  X(9,9),  X(0,10), },
  /* 550 */ {  X(0,1),  X(-9,9), },
  /* 551 */ {  X(0,1),  X(-9,9),  X(0,10), },
  /* 552 */ {  X(0,1), },
  /* 553 */ {  X(0,1), },
  /* 554 */ {  X(0,1), },
  /* 555 */ {  X(0,1), },
  /* 556 */ {  X(0,1),  X(10,9), },
  /* 557 */ {  X(0,1),  X(10,9),  X(0,10), },
  /* 558 */ {  X(0,1),  X(-10,9), },
  /* 559 */ {  X(0,1),  X(-10,9),  X(0,10), },
  /* 560 */ {  X(0,1),  X(4,7), },
  /* 561 */ {  X(0,1),  X(4,7), },
  /* 562 */ {  X(0,1),  X(4,7), },
  /* 563 */ {  X(0,1),  X(4,7), },
  /* 564 */ {  X(0,1),  X(4,7),  X(0,8), },
  /* 565 */ {  X(0,1),  X(4,7),  X(0,8), },
  /* 566 */ {  X(0,1),  X(4,7),  X(0,8),  X(0,9), },
  /* 567 */ {  X(0,1),  X(4,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 568 */ {  X(0,1),  X(-4,7), },
  /* 569 */ {  X(0,1),  X(-4,7), },
  /* 570 */ {  X(0,1),  X(-4,7), },
  /* 571 */ {  X(0,1),  X(-4,7), },
  /* 572 */ {  X(0,1),  X(-4,7),  X(0,8), },
  /* 573 */ {  X(0,1),  X(-4,7),  X(0,8), },
  /* 574 */ {  X(0,1),  X(-4,7),  X(0,8),  X(0,9), },
  /* 575 */ {  X(0,1),  X(-4,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 576 */ {  X(0,1),  X(1,5), },
  /* 577 */ {  X(0,1),  X(1,5), },
  /* 578 */ {  X(0,1),  X(1,5), },
  /* 579 */ {  X(0,1),  X(1,5), },
  /* 580 */ {  X(0,1),  X(1,5),  X(1,9), },
  /* 581 */ {  X(0,1),  X(1,5),  X(1,9),  X(0,10), },
  /* 582 */ {  X(0,1),  X(1,5),  X(-1,9), },
  /* 583 */ {  X(0,1),  X(1,5),  X(-1,9),  X(0,10), },
  /* 584 */ {  X(0,1),  X(1,5), },
  /* 585 */ {  X(0,1),  X(1,5), },
  /* 586 */ {  X(0,1),  X(1,5), },
  /* 587 */ {  X(0,1),  X(1,5), },
  /* 588 */ {  X(0,1),  X(1,5),  X(2,9), },
  /* 589 */ {  X(0,1),  X(1,5),  X(2,9),  X(0,10), },
  /* 590 */ {  X(0,1),  X(1,5),  X(-2,9), },
  /* 591 */ {  X(0,1),  X(1,5),  X(-2,9),  X(0,10), },
  /* 592 */ {  X(0,1),  X(1,5),  X(0,6), },
  /* 593 */ {  X(0,1),  X(1,5),  X(0,6), },
  /* 594 */ {  X(0,1),  X(1,5),  X(0,6),  X(1,10), },
  /* 595 */ {  X(0,1),  X(1,5),  X(0,6),  X(-1,10), },
  /* 596 */ {  X(0,1),  X(1,5),  X(0,6), },
  /* 597 */ {  X(0,1),  X(1,5),  X(0,6), },
  /* 598 */ {  X(0,1),  X(1,5),  X(0,6),  X(2,10), },
  /* 599 */ {  X(0,1),  X(1,5),  X(0,6),  X(-2,10), },
  /* 600 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7), },
  /* 601 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7), },
  /* 602 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7), },
  /* 603 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7), },
  /* 604 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 605 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 606 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 607 */ {  X(0,1),  X(1,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 608 */ {  X(0,1),  X(-1,5), },
  /* 609 */ {  X(0,1),  X(-1,5), },
  /* 610 */ {  X(0,1),  X(-1,5), },
  /* 611 */ {  X(0,1),  X(-1,5), },
  /* 612 */ {  X(0,1),  X(-1,5),  X(1,9), },
  /* 613 */ {  X(0,1),  X(-1,5),  X(1,9),  X(0,10), },
  /* 614 */ {  X(0,1),  X(-1,5),  X(-1,9), },
  /* 615 */ {  X(0,1),  X(-1,5),  X(-1,9),  X(0,10), },
  /* 616 */ {  X(0,1),  X(-1,5), },
  /* 617 */ {  X(0,1),  X(-1,5), },
  /* 618 */ {  X(0,1),  X(-1,5), },
  /* 619 */ {  X(0,1),  X(-1,5), },
  /* 620 */ {  X(0,1),  X(-1,5),  X(2,9), },
  /* 621 */ {  X(0,1),  X(-1,5),  X(2,9),  X(0,10), },
  /* 622 */ {  X(0,1),  X(-1,5),  X(-2,9), },
  /* 623 */ {  X(0,1),  X(-1,5),  X(-2,9),  X(0,10), },
  /* 624 */ {  X(0,1),  X(-1,5),  X(0,6), },
  /* 625 */ {  X(0,1),  X(-1,5),  X(0,6), },
  /* 626 */ {  X(0,1),  X(-1,5),  X(0,6),  X(1,10), },
  /* 627 */ {  X(0,1),  X(-1,5),  X(0,6),  X(-1,10), },
  /* 628 */ {  X(0,1),  X(-1,5),  X(0,6), },
  /* 629 */ {  X(0,1),  X(-1,5),  X(0,6), },
  /* 630 */ {  X(0,1),  X(-1,5),  X(0,6),  X(2,10), },
  /* 631 */ {  X(0,1),  X(-1,5),  X(0,6),  X(-2,10), },
  /* 632 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7), },
  /* 633 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7), },
  /* 634 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7), },
  /* 635 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7), },
  /* 636 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 637 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 638 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 639 */ {  X(0,1),  X(-1,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 640 */ {  X(0,1), },
  /* 641 */ {  X(0,1), },
  /* 642 */ {  X(0,1), },
  /* 643 */ {  X(0,1), },
  /* 644 */ {  X(0,1),  X(11,9), },
  /* 645 */ {  X(0,1),  X(11,9),  X(0,10), },
  /* 646 */ {  X(0,1),  X(-11,9), },
  /* 647 */ {  X(0,1),  X(-11,9),  X(0,10), },
  /* 648 */ {  X(0,1), },
  /* 649 */ {  X(0,1), },
  /* 650 */ {  X(0,1), },
  /* 651 */ {  X(0,1), },
  /* 652 */ {  X(0,1),  X(12,9), },
  /* 653 */ {  X(0,1),  X(12,9),  X(0,10), },
  /* 654 */ {  X(0,1),  X(-12,9), },
  /* 655 */ {  X(0,1),  X(-12,9),  X(0,10), },
  /* 656 */ {  X(0,1),  X(5,7), },
  /* 657 */ {  X(0,1),  X(5,7), },
  /* 658 */ {  X(0,1),  X(5,7), },
  /* 659 */ {  X(0,1),  X(5,7), },
  /* 660 */ {  X(0,1),  X(5,7),  X(0,8), },
  /* 661 */ {  X(0,1),  X(5,7),  X(0,8), },
  /* 662 */ {  X(0,1),  X(5,7),  X(0,8),  X(0,9), },
  /* 663 */ {  X(0,1),  X(5,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 664 */ {  X(0,1),  X(-5,7), },
  /* 665 */ {  X(0,1),  X(-5,7), },
  /* 666 */ {  X(0,1),  X(-5,7), },
  /* 667 */ {  X(0,1),  X(-5,7), },
  /* 668 */ {  X(0,1),  X(-5,7),  X(0,8), },
  /* 669 */ {  X(0,1),  X(-5,7),  X(0,8), },
  /* 670 */ {  X(0,1),  X(-5,7),  X(0,8),  X(0,9), },
  /* 671 */ {  X(0,1),  X(-5,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 672 */ {  X(0,1), },
  /* 673 */ {  X(0,1), },
  /* 674 */ {  X(0,1), },
  /* 675 */ {  X(0,1), },
  /* 676 */ {  X(0,1),  X(13,9), },
  /* 677 */ {  X(0,1),  X(13,9),  X(0,10), },
  /* 678 */ {  X(0,1),  X(-13,9), },
  /* 679 */ {  X(0,1),  X(-13,9),  X(0,10), },
  /* 680 */ {  X(0,1), },
  /* 681 */ {  X(0,1), },
  /* 682 */ {  X(0,1), },
  /* 683 */ {  X(0,1), },
  /* 684 */ {  X(0,1),  X(14,9), },
  /* 685 */ {  X(0,1),  X(14,9),  X(0,10), },
  /* 686 */ {  X(0,1),  X(-14,9), },
  /* 687 */ {  X(0,1),  X(-14,9),  X(0,10), },
  /* 688 */ {  X(0,1),  X(6,7), },
  /* 689 */ {  X(0,1),  X(6,7), },
  /* 690 */ {  X(0,1),  X(6,7), },
  /* 691 */ {  X(0,1),  X(6,7), },
  /* 692 */ {  X(0,1),  X(6,7),  X(0,8), },
  /* 693 */ {  X(0,1),  X(6,7),  X(0,8), },
  /* 694 */ {  X(0,1),  X(6,7),  X(0,8),  X(0,9), },
  /* 695 */ {  X(0,1),  X(6,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 696 */ {  X(0,1),  X(-6,7), },
  /* 697 */ {  X(0,1),  X(-6,7), },
  /* 698 */ {  X(0,1),  X(-6,7), },
  /* 699 */ {  X(0,1),  X(-6,7), },
  /* 700 */ {  X(0,1),  X(-6,7),  X(0,8), },
  /* 701 */ {  X(0,1),  X(-6,7),  X(0,8), },
  /* 702 */ {  X(0,1),  X(-6,7),  X(0,8),  X(0,9), },
  /* 703 */ {  X(0,1),  X(-6,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 704 */ {  X(0,1),  X(2,5), },
  /* 705 */ {  X(0,1),  X(2,5), },
  /* 706 */ {  X(0,1),  X(2,5), },
  /* 707 */ {  X(0,1),  X(2,5), },
  /* 708 */ {  X(0,1),  X(2,5),  X(1,9), },
  /* 709 */ {  X(0,1),  X(2,5),  X(1,9),  X(0,10), },
  /* 710 */ {  X(0,1),  X(2,5),  X(-1,9), },
  /* 711 */ {  X(0,1),  X(2,5),  X(-1,9),  X(0,10), },
  /* 712 */ {  X(0,1),  X(2,5), },
  /* 713 */ {  X(0,1),  X(2,5), },
  /* 714 */ {  X(0,1),  X(2,5), },
  /* 715 */ {  X(0,1),  X(2,5), },
  /* 716 */ {  X(0,1),  X(2,5),  X(2,9), },
  /* 717 */ {  X(0,1),  X(2,5),  X(2,9),  X(0,10), },
  /* 718 */ {  X(0,1),  X(2,5),  X(-2,9), },
  /* 719 */ {  X(0,1),  X(2,5),  X(-2,9),  X(0,10), },
  /* 720 */ {  X(0,1),  X(2,5),  X(0,6), },
  /* 721 */ {  X(0,1),  X(2,5),  X(0,6), },
  /* 722 */ {  X(0,1),  X(2,5),  X(0,6),  X(1,10), },
  /* 723 */ {  X(0,1),  X(2,5),  X(0,6),  X(-1,10), },
  /* 724 */ {  X(0,1),  X(2,5),  X(0,6), },
  /* 725 */ {  X(0,1),  X(2,5),  X(0,6), },
  /* 726 */ {  X(0,1),  X(2,5),  X(0,6),  X(2,10), },
  /* 727 */ {  X(0,1),  X(2,5),  X(0,6),  X(-2,10), },
  /* 728 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7), },
  /* 729 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7), },
  /* 730 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7), },
  /* 731 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7), },
  /* 732 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 733 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 734 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 735 */ {  X(0,1),  X(2,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 736 */ {  X(0,1),  X(-2,5), },
  /* 737 */ {  X(0,1),  X(-2,5), },
  /* 738 */ {  X(0,1),  X(-2,5), },
  /* 739 */ {  X(0,1),  X(-2,5), },
  /* 740 */ {  X(0,1),  X(-2,5),  X(1,9), },
  /* 741 */ {  X(0,1),  X(-2,5),  X(1,9),  X(0,10), },
  /* 742 */ {  X(0,1),  X(-2,5),  X(-1,9), },
  /* 743 */ {  X(0,1),  X(-2,5),  X(-1,9),  X(0,10), },
  /* 744 */ {  X(0,1),  X(-2,5), },
  /* 745 */ {  X(0,1),  X(-2,5), },
  /* 746 */ {  X(0,1),  X(-2,5), },
  /* 747 */ {  X(0,1),  X(-2,5), },
  /* 748 */ {  X(0,1),  X(-2,5),  X(2,9), },
  /* 749 */ {  X(0,1),  X(-2,5),  X(2,9),  X(0,10), },
  /* 750 */ {  X(0,1),  X(-2,5),  X(-2,9), },
  /* 751 */ {  X(0,1),  X(-2,5),  X(-2,9),  X(0,10), },
  /* 752 */ {  X(0,1),  X(-2,5),  X(0,6), },
  /* 753 */ {  X(0,1),  X(-2,5),  X(0,6), },
  /* 754 */ {  X(0,1),  X(-2,5),  X(0,6),  X(1,10), },
  /* 755 */ {  X(0,1),  X(-2,5),  X(0,6),  X(-1,10), },
  /* 756 */ {  X(0,1),  X(-2,5),  X(0,6), },
  /* 757 */ {  X(0,1),  X(-2,5),  X(0,6), },
  /* 758 */ {  X(0,1),  X(-2,5),  X(0,6),  X(2,10), },
  /* 759 */ {  X(0,1),  X(-2,5),  X(0,6),  X(-2,10), },
  /* 760 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7), },
  /* 761 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7), },
  /* 762 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7), },
  /* 763 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7), },
  /* 764 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 765 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 766 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 767 */ {  X(0,1),  X(-2,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 768 */ {  X(0,1),  X(0,2), },
  /* 769 */ {  X(0,1),  X(0,2), },
  /* 770 */ {  X(0,1),  X(0,2),  X(7,10), },
  /* 771 */ {  X(0,1),  X(0,2),  X(-7,10), },
  /* 772 */ {  X(0,1),  X(0,2), },
  /* 773 */ {  X(0,1),  X(0,2), },
  /* 774 */ {  X(0,1),  X(0,2),  X(8,10), },
  /* 775 */ {  X(0,1),  X(0,2),  X(-8,10), },
  /* 776 */ {  X(0,1),  X(0,2),  X(3,8), },
  /* 777 */ {  X(0,1),  X(0,2),  X(3,8), },
  /* 778 */ {  X(0,1),  X(0,2),  X(3,8),  X(0,9), },
  /* 779 */ {  X(0,1),  X(0,2),  X(3,8),  X(0,9),  X(0,10), },
  /* 780 */ {  X(0,1),  X(0,2),  X(-3,8), },
  /* 781 */ {  X(0,1),  X(0,2),  X(-3,8), },
  /* 782 */ {  X(0,1),  X(0,2),  X(-3,8),  X(0,9), },
  /* 783 */ {  X(0,1),  X(0,2),  X(-3,8),  X(0,9),  X(0,10), },
  /* 784 */ {  X(0,1),  X(0,2), },
  /* 785 */ {  X(0,1),  X(0,2), },
  /* 786 */ {  X(0,1),  X(0,2),  X(9,10), },
  /* 787 */ {  X(0,1),  X(0,2),  X(-9,10), },
  /* 788 */ {  X(0,1),  X(0,2), },
  /* 789 */ {  X(0,1),  X(0,2), },
  /* 790 */ {  X(0,1),  X(0,2),  X(10,10), },
  /* 791 */ {  X(0,1),  X(0,2),  X(-10,10), },
  /* 792 */ {  X(0,1),  X(0,2),  X(4,8), },
  /* 793 */ {  X(0,1),  X(0,2),  X(4,8), },
  /* 794 */ {  X(0,1),  X(0,2),  X(4,8),  X(0,9), },
  /* 795 */ {  X(0,1),  X(0,2),  X(4,8),  X(0,9),  X(0,10), },
  /* 796 */ {  X(0,1),  X(0,2),  X(-4,8), },
  /* 797 */ {  X(0,1),  X(0,2),  X(-4,8), },
  /* 798 */ {  X(0,1),  X(0,2),  X(-4,8),  X(0,9), },
  /* 799 */ {  X(0,1),  X(0,2),  X(-4,8),  X(0,9),  X(0,10), },
  /* 800 */ {  X(0,1),  X(0,2),  X(1,6), },
  /* 801 */ {  X(0,1),  X(0,2),  X(1,6), },
  /* 802 */ {  X(0,1),  X(0,2),  X(1,6),  X(1,10), },
  /* 803 */ {  X(0,1),  X(0,2),  X(1,6),  X(-1,10), },
  /* 804 */ {  X(0,1),  X(0,2),  X(1,6), },
  /* 805 */ {  X(0,1),  X(0,2),  X(1,6), },
  /* 806 */ {  X(0,1),  X(0,2),  X(1,6),  X(2,10), },
  /* 807 */ {  X(0,1),  X(0,2),  X(1,6),  X(-2,10), },
  /* 808 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7), },
  /* 809 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7), },
  /* 810 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7), },
  /* 811 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7), },
  /* 812 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7),  X(0,8), },
  /* 813 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7),  X(0,8), },
  /* 814 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 815 */ {  X(0,1),  X(0,2),  X(1,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 816 */ {  X(0,1),  X(0,2),  X(-1,6), },
  /* 817 */ {  X(0,1),  X(0,2),  X(-1,6), },
  /* 818 */ {  X(0,1),  X(0,2),  X(-1,6),  X(1,10), },
  /* 819 */ {  X(0,1),  X(0,2),  X(-1,6),  X(-1,10), },
  /* 820 */ {  X(0,1),  X(0,2),  X(-1,6), },
  /* 821 */ {  X(0,1),  X(0,2),  X(-1,6), },
  /* 822 */ {  X(0,1),  X(0,2),  X(-1,6),  X(2,10), },
  /* 823 */ {  X(0,1),  X(0,2),  X(-1,6),  X(-2,10), },
  /* 824 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7), },
  /* 825 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7), },
  /* 826 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7), },
  /* 827 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7), },
  /* 828 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7),  X(0,8), },
  /* 829 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7),  X(0,8), },
  /* 830 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 831 */ {  X(0,1),  X(0,2),  X(-1,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 832 */ {  X(0,1),  X(0,2), },
  /* 833 */ {  X(0,1),  X(0,2), },
  /* 834 */ {  X(0,1),  X(0,2),  X(11,10), },
  /* 835 */ {  X(0,1),  X(0,2),  X(-11,10), },
  /* 836 */ {  X(0,1),  X(0,2), },
  /* 837 */ {  X(0,1),  X(0,2), },
  /* 838 */ {  X(0,1),  X(0,2),  X(12,10), },
  /* 839 */ {  X(0,1),  X(0,2),  X(-12,10), },
  /* 840 */ {  X(0,1),  X(0,2),  X(5,8), },
  /* 841 */ {  X(0,1),  X(0,2),  X(5,8), },
  /* 842 */ {  X(0,1),  X(0,2),  X(5,8),  X(0,9), },
  /* 843 */ {  X(0,1),  X(0,2),  X(5,8),  X(0,9),  X(0,10), },
  /* 844 */ {  X(0,1),  X(0,2),  X(-5,8), },
  /* 845 */ {  X(0,1),  X(0,2),  X(-5,8), },
  /* 846 */ {  X(0,1),  X(0,2),  X(-5,8),  X(0,9), },
  /* 847 */ {  X(0,1),  X(0,2),  X(-5,8),  X(0,9),  X(0,10), },
  /* 848 */ {  X(0,1),  X(0,2), },
  /* 849 */ {  X(0,1),  X(0,2), },
  /* 850 */ {  X(0,1),  X(0,2),  X(13,10), },
  /* 851 */ {  X(0,1),  X(0,2),  X(-13,10), },
  /* 852 */ {  X(0,1),  X(0,2), },
  /* 853 */ {  X(0,1),  X(0,2), },
  /* 854 */ {  X(0,1),  X(0,2),  X(14,10), },
  /* 855 */ {  X(0,1),  X(0,2),  X(-14,10), },
  /* 856 */ {  X(0,1),  X(0,2),  X(6,8), },
  /* 857 */ {  X(0,1),  X(0,2),  X(6,8), },
  /* 858 */ {  X(0,1),  X(0,2),  X(6,8),  X(0,9), },
  /* 859 */ {  X(0,1),  X(0,2),  X(6,8),  X(0,9),  X(0,10), },
  /* 860 */ {  X(0,1),  X(0,2),  X(-6,8), },
  /* 861 */ {  X(0,1),  X(0,2),  X(-6,8), },
  /* 862 */ {  X(0,1),  X(0,2),  X(-6,8),  X(0,9), },
  /* 863 */ {  X(0,1),  X(0,2),  X(-6,8),  X(0,9),  X(0,10), },
  /* 864 */ {  X(0,1),  X(0,2),  X(2,6), },
  /* 865 */ {  X(0,1),  X(0,2),  X(2,6), },
  /* 866 */ {  X(0,1),  X(0,2),  X(2,6),  X(1,10), },
  /* 867 */ {  X(0,1),  X(0,2),  X(2,6),  X(-1,10), },
  /* 868 */ {  X(0,1),  X(0,2),  X(2,6), },
  /* 869 */ {  X(0,1),  X(0,2),  X(2,6), },
  /* 870 */ {  X(0,1),  X(0,2),  X(2,6),  X(2,10), },
  /* 871 */ {  X(0,1),  X(0,2),  X(2,6),  X(-2,10), },
  /* 872 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7), },
  /* 873 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7), },
  /* 874 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7), },
  /* 875 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7), },
  /* 876 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7),  X(0,8), },
  /* 877 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7),  X(0,8), },
  /* 878 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 879 */ {  X(0,1),  X(0,2),  X(2,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 880 */ {  X(0,1),  X(0,2),  X(-2,6), },
  /* 881 */ {  X(0,1),  X(0,2),  X(-2,6), },
  /* 882 */ {  X(0,1),  X(0,2),  X(-2,6),  X(1,10), },
  /* 883 */ {  X(0,1),  X(0,2),  X(-2,6),  X(-1,10), },
  /* 884 */ {  X(0,1),  X(0,2),  X(-2,6), },
  /* 885 */ {  X(0,1),  X(0,2),  X(-2,6), },
  /* 886 */ {  X(0,1),  X(0,2),  X(-2,6),  X(2,10), },
  /* 887 */ {  X(0,1),  X(0,2),  X(-2,6),  X(-2,10), },
  /* 888 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7), },
  /* 889 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7), },
  /* 890 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7), },
  /* 891 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7), },
  /* 892 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7),  X(0,8), },
  /* 893 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7),  X(0,8), },
  /* 894 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 895 */ {  X(0,1),  X(0,2),  X(-2,6),  X(0,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 896 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 897 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 898 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 899 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 900 */ {  X(0,1),  X(0,2),  X(0,3),  X(3,9), },
  /* 901 */ {  X(0,1),  X(0,2),  X(0,3),  X(3,9),  X(0,10), },
  /* 902 */ {  X(0,1),  X(0,2),  X(0,3),  X(-3,9), },
  /* 903 */ {  X(0,1),  X(0,2),  X(0,3),  X(-3,9),  X(0,10), },
  /* 904 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 905 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 906 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 907 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 908 */ {  X(0,1),  X(0,2),  X(0,3),  X(4,9), },
  /* 909 */ {  X(0,1),  X(0,2),  X(0,3),  X(4,9),  X(0,10), },
  /* 910 */ {  X(0,1),  X(0,2),  X(0,3),  X(-4,9), },
  /* 911 */ {  X(0,1),  X(0,2),  X(0,3),  X(-4,9),  X(0,10), },
  /* 912 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7), },
  /* 913 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7), },
  /* 914 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7), },
  /* 915 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7), },
  /* 916 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7),  X(0,8), },
  /* 917 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7),  X(0,8), },
  /* 918 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7),  X(0,8),  X(0,9), },
  /* 919 */ {  X(0,1),  X(0,2),  X(0,3),  X(1,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 920 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7), },
  /* 921 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7), },
  /* 922 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7), },
  /* 923 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7), },
  /* 924 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7),  X(0,8), },
  /* 925 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7),  X(0,8), },
  /* 926 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7),  X(0,8),  X(0,9), },
  /* 927 */ {  X(0,1),  X(0,2),  X(0,3),  X(-1,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 928 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 929 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 930 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 931 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 932 */ {  X(0,1),  X(0,2),  X(0,3),  X(5,9), },
  /* 933 */ {  X(0,1),  X(0,2),  X(0,3),  X(5,9),  X(0,10), },
  /* 934 */ {  X(0,1),  X(0,2),  X(0,3),  X(-5,9), },
  /* 935 */ {  X(0,1),  X(0,2),  X(0,3),  X(-5,9),  X(0,10), },
  /* 936 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 937 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 938 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 939 */ {  X(0,1),  X(0,2),  X(0,3), },
  /* 940 */ {  X(0,1),  X(0,2),  X(0,3),  X(6,9), },
  /* 941 */ {  X(0,1),  X(0,2),  X(0,3),  X(6,9),  X(0,10), },
  /* 942 */ {  X(0,1),  X(0,2),  X(0,3),  X(-6,9), },
  /* 943 */ {  X(0,1),  X(0,2),  X(0,3),  X(-6,9),  X(0,10), },
  /* 944 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7), },
  /* 945 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7), },
  /* 946 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7), },
  /* 947 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7), },
  /* 948 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7),  X(0,8), },
  /* 949 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7),  X(0,8), },
  /* 950 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7),  X(0,8),  X(0,9), },
  /* 951 */ {  X(0,1),  X(0,2),  X(0,3),  X(2,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 952 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7), },
  /* 953 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7), },
  /* 954 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7), },
  /* 955 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7), },
  /* 956 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7),  X(0,8), },
  /* 957 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7),  X(0,8), },
  /* 958 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7),  X(0,8),  X(0,9), },
  /* 959 */ {  X(0,1),  X(0,2),  X(0,3),  X(-2,7),  X(0,8),  X(0,9),  X(0,10), },
  /* 960 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 961 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 962 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(3,10), },
  /* 963 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-3,10), },
  /* 964 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 965 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 966 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(4,10), },
  /* 967 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-4,10), },
  /* 968 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(1,8), },
  /* 969 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(1,8), },
  /* 970 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(1,8),  X(0,9), },
  /* 971 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(1,8),  X(0,9),  X(0,10), },
  /* 972 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-1,8), },
  /* 973 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-1,8), },
  /* 974 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-1,8),  X(0,9), },
  /* 975 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-1,8),  X(0,9),  X(0,10), },
  /* 976 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 977 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 978 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(5,10), },
  /* 979 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-5,10), },
  /* 980 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 981 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4), },
  /* 982 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(6,10), },
  /* 983 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-6,10), },
  /* 984 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(2,8), },
  /* 985 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(2,8), },
  /* 986 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(2,8),  X(0,9), },
  /* 987 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(2,8),  X(0,9),  X(0,10), },
  /* 988 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-2,8), },
  /* 989 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-2,8), },
  /* 990 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-2,8),  X(0,9), },
  /* 991 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(-2,8),  X(0,9),  X(0,10), },
  /* 992 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 993 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 994 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 995 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 996 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(1,9), },
  /* 997 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(1,9),  X(0,10), },
  /* 998 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(-1,9), },
  /* 999 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(-1,9),  X(0,10), },
  /* 1000 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 1001 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 1002 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 1003 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5), },
  /* 1004 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(2,9), },
  /* 1005 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(2,9),  X(0,10), },
  /* 1006 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(-2,9), },
  /* 1007 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(-2,9),  X(0,10), },
  /* 1008 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6), },
  /* 1009 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6), },
  /* 1010 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(1,10), },
  /* 1011 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(-1,10), },
  /* 1012 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6), },
  /* 1013 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6), },
  /* 1014 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(2,10), },
  /* 1015 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(-2,10), },
  /* 1016 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 1017 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 1018 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 1019 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7), },
  /* 1020 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 1021 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8), },
  /* 1022 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
  /* 1023 */ {  X(0,1),  X(0,2),  X(0,3),  X(0,4),  X(0,5),  X(0,6),  X(0,7),  X(0,8),  X(0,9), },
};
