
if(ZSYNC_INCLUDE_DIR AND ZSYNC_LIBRARY)
	# Already in cache, be silent
	set(ZSYNC_FIND_QUIETLY TRUE)	
endif(ZSYNC_INCLUDE_DIR AND ZSYNC_LIBRARY)

set(ZSYNC_LIBRARY)
set(ZSYNC_INCLUDE_DIR)

FIND_PATH(ZSYNC_INCLUDE_DIR zsync.h
	/usr/include
	/usr/local/include
)

FIND_LIBRARY(ZSYNC_LIBRARY NAMES zsync
	PATHS
	/usr/lib
	/usr/local/lib
)

FIND_LIBRARY(RCKSUM_LIBRARY NAMES rcksum
  PATHS
  /usr/lib
  /usr/local/lib
)

if(ZSYNC_INCLUDE_DIR AND ZSYNC_LIBRARY AND RCKSUM_LIBRARY)
   MESSAGE( STATUS "zsync found: includes in ${ZSYNC_INCLUDE_DIR}, library in ${ZSYNC_LIBRARY}")
   set(ZSYNC_FOUND TRUE)
else(ZSYNC_INCLUDE_DIR AND ZSYNC_LIBRARY)
   MESSAGE( STATUS "zsync not found")
endif(ZSYNC_INCLUDE_DIR AND ZSYNC_LIBRARY AND RCKSUM_LIBRARY)

MARK_AS_ADVANCED(ZSYNC_INCLUDE_DIR ZSYNC_LIBRARY RCKSUM_LIBRARY)