/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "checkbutton.h"
using namespace std;

checkbutton::checkbutton (int left, int bottom, int what, const string& label, int clr_blnd) : button (left, bottom, label), state (-1), lsnr (0) {
  set_state (what);
  color_blend (clr_blnd);
}

int checkbutton::handle_input () {
  int ret = button::handle_input ();
  if (clicked ()) toggle ();
  return ret;
}

void checkbutton::draw () {
  button::draw ();
}

void checkbutton::turn_on () {
  if (state != 1) {
    state = 1;
    if (!color_blend ()) set_color (on_color);
    if (lsnr) lsnr->changed (*this);
  }
}

void checkbutton::turn_off () {
  if (state != 0) {
    state = 0;
    if (!color_blend ()) set_color (off_color);
    if (lsnr) lsnr->changed (*this);
  }
}

void checkbutton::set_state (int s) {
  if (s) turn_on (); else turn_off ();
}

void checkbutton::toggle () {
  if (is_on ()) turn_off (); else turn_on ();
}

void checkbutton::blend_on_off_color (float blend) {

  static color result;

  if (state)
    ::blend_color (off_color, on_color, result, blend);
  else
    ::blend_color (on_color, off_color, result, blend);

  set_color (result);

}
