/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2010  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4objects.Db4o;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Tests.Common.Api;
using Db4objects.Db4o.Tests.Common.Assorted;

namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class PreventMultipleOpenTestCase : Db4oTestWithTempFile
	{
		public static void Main(string[] args)
		{
			new ConsoleTestRunner(typeof(PreventMultipleOpenTestCase)).Run();
		}

		public virtual void TestOpenTwice()
		{
			IObjectContainer oc = OpenFile();
			Assert.Expect(typeof(DatabaseFileLockedException), new _ICodeBlock_21(this));
			oc.Close();
		}

		private sealed class _ICodeBlock_21 : ICodeBlock
		{
			public _ICodeBlock_21(PreventMultipleOpenTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			/// <exception cref="System.Exception"></exception>
			public void Run()
			{
				this._enclosing.OpenFile();
			}

			private readonly PreventMultipleOpenTestCase _enclosing;
		}

		public virtual void TestReopen()
		{
			IObjectContainer oc = OpenFile();
			oc.Close();
			oc = OpenFile();
			Assert.IsNotNull(oc);
			oc.Close();
		}

		private IObjectContainer OpenFile()
		{
			return Db4oEmbedded.OpenFile(NewConfiguration(), TempFile());
		}
	}
}
