﻿// Copyright (c) Microsoft Corporation.  All Rights Reserved.  See License.txt in the project root for license information.

module FSharp.Editor.Tests.CodeFixes.ConvertCSharpUsingToFSharpOpenTests

open Microsoft.VisualStudio.FSharp.Editor
open Xunit

open CodeFixTestFramework

let private codeFix = ConvertCSharpUsingToFSharpOpenCodeFixProvider()

[<Theory>]
[<InlineData "">]
[<InlineData ";">]
let ``Fixes FS0039 - simple namespace`` optionalSemicolon =
    let code =
        $"""
using System{optionalSemicolon}
"""

    let expected =
        Some
            {
                Message = "Convert C# 'using' to F# 'open'"
                FixedCode =
                    """
open System
"""
            }

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)

[<Theory>]
[<InlineData "">]
[<InlineData ";">]
let ``Fixes FS0039 - complex namespace`` optionalSemicolon =
    let code =
        $"""
using System.IO{optionalSemicolon}
"""

    let expected =
        Some
            {
                Message = "Convert C# 'using' to F# 'open'"
                FixedCode =
                    """
open System.IO
"""
            }

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)

[<Fact>]
let ``Doesn't fix random FS0039`` () =
    let code = """namespa"""

    let expected = None

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)

[<Theory>]
[<InlineData "">]
[<InlineData ";">]
let ``Fixes FS0201 - simple namespace`` optionalSemicolon =
    let code =
        $"""
namespace Test

using System{optionalSemicolon}
"""

    let expected =
        Some
            {
                Message = "Convert C# 'using' to F# 'open'"
                FixedCode =
                    """
namespace Test

open System
"""
            }

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)

[<Theory>]
[<InlineData "">]
[<InlineData ";">]
let ``Fixes FS0201 - complex namespace`` optionalSemicolon =
    let code =
        $"""
namespace Test

using System.IO{optionalSemicolon}
"""

    let expected =
        Some
            {
                Message = "Convert C# 'using' to F# 'open'"
                FixedCode =
                    """
namespace Test

open System.IO
"""
            }

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)

[<Fact>]
let ``Doesn't fix random FS0201`` () =
    let code =
        """
namespace Test

let x = 42
"""

    let expected = None

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)

[<Fact>]
let ``Handles spaces before semicolons`` () =
    let code =
        $"""
using System   ;
"""

    let expected =
        Some
            {
                Message = "Convert C# 'using' to F# 'open'"
                FixedCode =
                    """
open System   
"""
            }

    let actual = codeFix |> tryFix code Auto

    Assert.Equal(expected, actual)
