/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef SHAREMAIN_H
#define SHAREMAIN_H

#include <QWidget>
#include <QFrame>
#include <QCheckBox>
#include <QLabel>
#include <QRadioButton>
#include <QVBoxLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QByteArray>
#include <QDebug>
#include <QGSettings/QGSettings>
#include <QPushButton>
#include "inputpwddialog.h"
#include "titlelabel.h"
#include "kswitchbutton.h"
#include "switchwidget.h"
#include "settinggroup.h"
#include "ukccframe.h"
using namespace kdk;

const QByteArray kVinoSchemas = "org.gnome.Vino";
const QString kVinoViewOnlyKey = "view-only";
const QString kVinoPromptKey = "prompt-enabled";
const QString kAuthenticationKey = "authentication-methods";
const QString kVncPwdKey = "vnc-password";

const QByteArray kUkccVnoSchmas = "org.ukui.control-center.vino";
const QString kUkccPromptKey = "remote";

enum RequestPwd {
    NOPWD,
    NEEDPWD
};

class ShareMain : public QWidget
{
    Q_OBJECT
public:
    ShareMain(QWidget *parent = nullptr);
    ~ShareMain();

private:
    SwitchWidget *mEnableWidget;
    SwitchWidget *mViewWidget;
    SwitchWidget *mSecurityWidget;
    SwitchWidget *mSecurityPwdWidget;

    TitleLabel *mVinoTitleLabel;

    QPushButton *mPwdinputBtn;
    QVBoxLayout *mVlayout;
    QGSettings *mVinoGsetting;
    QString secpwd;

private:
    void initUI();
    void initConnection();
    void initShareStatus(bool isConnnect, bool isPwd);
    void initEnableStatus();
    void setFrameVisible(bool visible);
    void setVinoService(bool status);

private slots:
    void enableSlot(bool status);
    void viewBoxSlot(bool status);
    void accessSlot(bool status);
    void pwdEnableSlot(bool status);
    void pwdInputSlot();
};

#endif // SHAREMAIN_H
