/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/

#ifndef CREATEGROUPDIALOG_H
#define CREATEGROUPDIALOG_H

#include <QDialog>
#include <QPainter>
#include <QPainterPath>
#include <QCheckBox>
#include <QIntValidator>
#include <QRegExpValidator>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QFrame>
#include <QLineEdit>
#include <QLabel>
#include <QPushButton>

#include "widgets/Label/fixlabel.h"

class changeUserGroup;
namespace Ui {
class CreateGroupDialog;
}

class CreateGroupDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CreateGroupDialog(QWidget *parent = nullptr);
    ~CreateGroupDialog();

public:
    void limitInput();
    void refreshCertainBtnStatus();
    QPushButton * certainBtnComponent();
    QLineEdit * lineNameComponent();
    QLineEdit * lineIdComponent();

private:
    QVBoxLayout *vlayout = nullptr;
    changeUserGroup *cgDialog = nullptr;

    QFrame *mGroupNameFrame;
    QFrame *mGroupIdFrame;
    QFrame *mConfirmFrame;

    QLabel *mGroupNameLabel;
    QLabel *mGroupIdLabel;

    QLineEdit *mGroupNameEdit;
    QLineEdit *mGroupIdEdit;

    QPushButton *mCancelBtn;
    QPushButton *mConfirmBtn;

    QHBoxLayout *mGroupNameHLayout;
    QHBoxLayout *mGroupIdHLayout;
    QHBoxLayout *mConfirmHLaout;
    QHBoxLayout *mGroupNameTipHLayout;

    bool _nameHasModified;
    bool _idHasModified;

    QString oldGroupName;
    FixLabel *mGroupNameTipLabel;
    QString mGroupNameTip;

    void initUI();
    void signalsBind();

protected:
    bool eventFilter(QObject *watched, QEvent *event);
};

#endif // CREATEGROUPDIALOG_H
