'''OpenGL extension EXT.blend_logic_op

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.blend_logic_op to provide a more 
Python-friendly API

Overview (from the spec)
	
	A single additional blending equation is specified using the interface
	defined by EXT_blend_minmax.  This equation is a simple logical
	combination of the source and destination colors, where the specific
	logical operation is as specified by LogicOp.  While only the XOR
	operation may find wide application, the generality of full logical
	operations is allowed.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/blend_logic_op.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.EXT.blend_logic_op import *
from OpenGL.raw.GL.EXT.blend_logic_op import _EXTENSION_NAME

def glInitBlendLogicOpEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION