/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.DaaRuleViolation;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.pathfinder.CurrentPath;
import net.sourceforge.pmd.dfa.pathfinder.DAAPathFinder;
import net.sourceforge.pmd.dfa.pathfinder.Executable;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.pmd.properties.IntegerProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaaRule
extends AbstractRule
implements Executable {
    private RuleContext rc;
    private List<DaaRuleViolation> daaRuleViolations;
    private int maxRuleViolations;
    private int currentRuleViolationCount;
    private static final PropertyDescriptor maxPathDescriptor = new IntegerProperty("maxpaths", "Maximum number of paths per method", 5000, 1.0f);
    private static final PropertyDescriptor maxViolationsDescriptor = new IntegerProperty("maxviolations", "Maximum number of anomalys per class", 1000, 2.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = DaaRule.asFixedMap(new PropertyDescriptor[]{maxPathDescriptor, maxViolationsDescriptor});

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.maxRuleViolations = this.getIntProperty(maxViolationsDescriptor);
        this.currentRuleViolationCount = 0;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object data) {
        this.rc = (RuleContext)data;
        this.daaRuleViolations = new ArrayList<DaaRuleViolation>();
        IDataFlowNode node = methodDeclaration.getDataFlowNode().getFlow().get(0);
        DAAPathFinder pathFinder = new DAAPathFinder(node, this, this.getIntProperty(maxPathDescriptor));
        pathFinder.run();
        super.visit(methodDeclaration, data);
        return data;
    }

    @Override
    public void execute(CurrentPath path) {
        if (this.maxNumberOfViolationsReached()) {
            return;
        }
        HashMap<String, Usage> hash = new HashMap<String, Usage>();
        Iterator<IDataFlowNode> pathIterator = path.iterator();
        while (pathIterator.hasNext()) {
            IDataFlowNode inode = pathIterator.next();
            if (inode.getVariableAccess() == null) continue;
            for (int g = 0; g < inode.getVariableAccess().size(); ++g) {
                VariableAccess va = inode.getVariableAccess().get(g);
                Usage lastUsage = (Usage)hash.get(va.getVariableName());
                if (lastUsage != null) {
                    this.checkVariableAccess(inode, va, lastUsage);
                }
                Usage newUsage = new Usage(va.getAccessType(), inode);
                hash.put(va.getVariableName(), newUsage);
            }
        }
    }

    private void checkVariableAccess(IDataFlowNode inode, VariableAccess va, Usage u) {
        int startLine = u.node.getLine();
        int endLine = inode.getLine();
        SimpleNode lastNode = inode.getSimpleNode();
        SimpleNode firstNode = u.node.getSimpleNode();
        if (va.accessTypeMatches(u.accessType) && va.isDefinition()) {
            this.addDaaViolation(this.rc, lastNode, "DD", va.getVariableName(), startLine, endLine);
        } else if (u.accessType == 2 && va.isReference()) {
            this.addDaaViolation(this.rc, lastNode, "UR", va.getVariableName(), startLine, endLine);
        } else if (u.accessType == 0 && va.isUndefinition()) {
            this.addDaaViolation(this.rc, firstNode, "DU", va.getVariableName(), startLine, endLine);
        }
    }

    private final void addDaaViolation(Object data, SimpleNode node, String type, String var, int startLine, int endLine) {
        if (!this.maxNumberOfViolationsReached() && !this.violationAlreadyExists(type, var, startLine, endLine) && node != null) {
            RuleContext ctx = (RuleContext)data;
            String msg = type;
            if (this.getMessage() != null) {
                msg = MessageFormat.format(this.getMessage(), type, var, startLine, endLine);
            }
            DaaRuleViolation violation = new DaaRuleViolation(this, ctx, node, type, msg, var, startLine, endLine);
            ctx.getReport().addRuleViolation(violation);
            this.daaRuleViolations.add(violation);
            ++this.currentRuleViolationCount;
        }
    }

    private boolean maxNumberOfViolationsReached() {
        return this.currentRuleViolationCount >= this.maxRuleViolations;
    }

    private boolean violationAlreadyExists(String type, String var, int startLine, int endLine) {
        for (DaaRuleViolation violation : this.daaRuleViolations) {
            if (violation.getBeginLine() != startLine || violation.getEndLine() != endLine || !violation.getType().equals(type) || !violation.getVariableName().equals(var)) continue;
            return true;
        }
        return false;
    }

    private static class Usage {
        public int accessType;
        public IDataFlowNode node;

        public Usage(int accessType, IDataFlowNode node) {
            this.accessType = accessType;
            this.node = node;
        }

        public String toString() {
            return "accessType = " + this.accessType + ", line = " + this.node.getLine();
        }
    }
}

