/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.weathericons;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on Weather Icons v2.0
 *
 * @author Jens Deters (mail@jensd.de)
 * @version 2.0 (222 Icons)
 */
public enum WeatherIcon implements GlyphIcons {

    ALIEN('\uf075'),
    BAROMETER('\uf079'),
    CELSIUS('\uf03C'),
    CLOUD('\uf041'),
    CLOUD_DOWN('\uf03D'),
    CLOUD_REFRESH('\uf03E'),
    CLOUD_UP('\uf040'),
    CLOUDY('\uf013'),
    CLOUDY_GUSTS('\uf011'),
    CLOUDY_WINDY('\uf012'),
    DAY_CLOUDY('\uf002'),
    DAY_CLOUDY_GUSTS('\uf000'),
    DAY_CLOUDY_HIGH('\uf07D'),
    DAY_CLOUDY_WINDY('\uf001'),
    DAY_FOG('\uf003'),
    DAY_HAIL('\uf004'),
    DAY_HAZE('\uf0B6'),
    DAY_LIGHT_WIND('\uf0C4'),
    DAY_LIGHTNING('\uf005'),
    DAY_RAIN('\uf008'),
    DAY_RAIN_MIX('\uf006'),
    DAY_RAIN_WIND('\uf007'),
    DAY_SHOWERS('\uf009'),
    DAY_SLEET('\uf0B2'),
    DAY_SLEET_STORM('\uf068'),
    DAY_SNOW('\uf00A'),
    DAY_SNOW_THUNDERSTORM('\uf06B'),
    DAY_SNOW_WIND('\uf065'),
    DAY_SPRINKLE('\uf00B'),
    DAY_STORM_SHOWERS('\uf00E'),
    DAY_SUNNY('\uf00D'),
    DAY_SUNNY_OVERCAST('\uf00C'),
    DAY_THUNDERSTORM('\uf010'),
    DAY_WINDY('\uf085'),
    DEGREES('\uf042'),
    DIRECTION_DOWN('\uf044'),
    DIRECTION_DOWN_LEFT('\uf043'),
    DIRECTION_DOWN_RIGHT('\uf088'),
    DIRECTION_LEFT('\uf048'),
    DIRECTION_RIGHT('\uf04D'),
    DIRECTION_UP('\uf058'),
    DIRECTION_UP_LEFT('\uf087'),
    DIRECTION_UP_RIGHT('\uf057'),
    DUST('\uf063'),
    EARTHQUAKE('\uf0C6'),
    FAHRENHEIT('\uf045'),
    FIRE('\uf0C7'),
    FLOOD('\uf07C'),
    FOG('\uf014'),
    FORECAST_IO_CLEAR_DAY('\uf00D'),
    FORECAST_IO_CLEAR_NIGHT('\uf02E'),
    FORECAST_IO_CLOUDY('\uf013'),
    FORECAST_IO_FOG('\uf014'),
    FORECAST_IO_HAIL('\uf015'),
    FORECAST_IO_PARTLY_CLOUDY_DAY('\uf002'),
    FORECAST_IO_PARTLY_CLOUDY_NIGHT('\uf031'),
    FORECAST_IO_RAIN('\uf019'),
    FORECAST_IO_SLEET('\uf0B5'),
    FORECAST_IO_SNOW('\uf01B'),
    FORECAST_IO_THUNDERSTORM('\uf01E'),
    FORECAST_IO_TORNADO('\uf056'),
    FORECAST_IO_WIND('\uf050'),
    GALE_WARNING('\uf0CD'),
    HAIL('\uf015'),
    HORIZON('\uf047'),
    HORIZON_ALT('\uf046'),
    HOT('\uf072'),
    HUMIDITY('\uf07A'),
    HURRICANE('\uf073'),
    HURRICANE_WARNING('\uf0CF'),
    LIGHTNING('\uf016'),
    LUNAR_ECLIPSE('\uf070'),
    METEOR('\uf071'),
    MOON_0('\uf095'),
    MOON_1('\uf096'),
    MOON_10('\uf09F'),
    MOON_11('\uf0A0'),
    MOON_12('\uf0A1'),
    MOON_13('\uf0A2'),
    MOON_14('\uf0A3'),
    MOON_15('\uf0A4'),
    MOON_16('\uf0A5'),
    MOON_17('\uf0A6'),
    MOON_18('\uf0A7'),
    MOON_19('\uf0A8'),
    MOON_2('\uf097'),
    MOON_20('\uf0A9'),
    MOON_21('\uf0AA'),
    MOON_22('\uf0AB'),
    MOON_23('\uf0AC'),
    MOON_24('\uf0AD'),
    MOON_25('\uf0AE'),
    MOON_26('\uf0AF'),
    MOON_27('\uf0B0'),
    MOON_3('\uf098'),
    MOON_4('\uf099'),
    MOON_5('\uf09A'),
    MOON_6('\uf09B'),
    MOON_7('\uf09C'),
    MOON_8('\uf09D'),
    MOON_9('\uf09E'),
    MOON_ALT_FIRST_QUARTER('\uf0D6'),
    MOON_ALT_FULL('\uf0DD'),
    MOON_ALT_NEW('\uf0EB'),
    MOON_ALT_THIRD_QUARTER('\uf0E4'),
    MOON_ALT_WANING_CRESCENT_1('\uf0E5'),
    MOON_ALT_WANING_CRESCENT_2('\uf0E6'),
    MOON_ALT_WANING_CRESCENT_3('\uf0E7'),
    MOON_ALT_WANING_CRESCENT_4('\uf0E8'),
    MOON_ALT_WANING_CRESCENT_5('\uf0E9'),
    MOON_ALT_WANING_CRESCENT_6('\uf0EA'),
    MOON_ALT_WANING_GIBBOUS_1('\uf0DE'),
    MOON_ALT_WANING_GIBBOUS_2('\uf0DF'),
    MOON_ALT_WANING_GIBBOUS_3('\uf0E0'),
    MOON_ALT_WANING_GIBBOUS_4('\uf0E1'),
    MOON_ALT_WANING_GIBBOUS_5('\uf0E2'),
    MOON_ALT_WANING_GIBBOUS_6('\uf0E3'),
    MOON_ALT_WAXING_CRESCENT_1('\uf0D0'),
    MOON_ALT_WAXING_CRESCENT_2('\uf0D1'),
    MOON_ALT_WAXING_CRESCENT_3('\uf0D2'),
    MOON_ALT_WAXING_CRESCENT_4('\uf0D3'),
    MOON_ALT_WAXING_CRESCENT_5('\uf0D4'),
    MOON_ALT_WAXING_CRESCENT_6('\uf0D5'),
    MOON_ALT_WAXING_GIBBOUS_1('\uf0D7'),
    MOON_ALT_WAXING_GIBBOUS_2('\uf0D8'),
    MOON_ALT_WAXING_GIBBOUS_3('\uf0D9'),
    MOON_ALT_WAXING_GIBBOUS_4('\uf0DA'),
    MOON_ALT_WAXING_GIBBOUS_5('\uf0DB'),
    MOON_ALT_WAXING_GIBBOUS_6('\uf0DC'),
    MOON_FIRST_QUARTER('\uf09C'),
    MOON_FULL('\uf0A3'),
    MOON_NEW('\uf095'),
    MOON_THIRD_QUARTER('\uf0AA'),
    MOON_WANING_CRESCENT_1('\uf0AB'),
    MOON_WANING_CRESCENT_2('\uf0AC'),
    MOON_WANING_CRESCENT_3('\uf0AD'),
    MOON_WANING_CRESCENT_4('\uf0AE'),
    MOON_WANING_CRESCENT_5('\uf0AF'),
    MOON_WANING_CRESCENT_6('\uf0B0'),
    MOON_WANING_GIBBOUS_1('\uf0A4'),
    MOON_WANING_GIBBOUS_2('\uf0A5'),
    MOON_WANING_GIBBOUS_3('\uf0A6'),
    MOON_WANING_GIBBOUS_4('\uf0A7'),
    MOON_WANING_GIBBOUS_5('\uf0A8'),
    MOON_WANING_GIBBOUS_6('\uf0A9'),
    MOON_WAXING_CRESCENT_1('\uf096'),
    MOON_WAXING_CRESCENT_2('\uf097'),
    MOON_WAXING_CRESCENT_3('\uf098'),
    MOON_WAXING_CRESCENT_4('\uf099'),
    MOON_WAXING_CRESCENT_5('\uf09A'),
    MOON_WAXING_CRESCENT_6('\uf09B'),
    MOON_WAXING_GIBBOUS_1('\uf09D'),
    MOON_WAXING_GIBBOUS_2('\uf09E'),
    MOON_WAXING_GIBBOUS_3('\uf09F'),
    MOON_WAXING_GIBBOUS_4('\uf0A0'),
    MOON_WAXING_GIBBOUS_5('\uf0A1'),
    MOON_WAXING_GIBBOUS_6('\uf0A2'),
    MOONRISE('\uf0C9'),
    MOONSET('\uf0CA'),
    NA('\uf07B'),
    NIGHT_ALT_CLOUDY('\uf086'),
    NIGHT_ALT_CLOUDY_GUSTS('\uf022'),
    NIGHT_ALT_CLOUDY_HIGH('\uf07E'),
    NIGHT_ALT_CLOUDY_WINDY('\uf023'),
    NIGHT_ALT_HAIL('\uf024'),
    NIGHT_ALT_LIGHTNING('\uf025'),
    NIGHT_ALT_PARTLY_CLOUDY('\uf081'),
    NIGHT_ALT_RAIN('\uf028'),
    NIGHT_ALT_RAIN_MIX('\uf026'),
    NIGHT_ALT_RAIN_WIND('\uf027'),
    NIGHT_ALT_SHOWERS('\uf029'),
    NIGHT_ALT_SLEET('\uf0B4'),
    NIGHT_ALT_SLEET_STORM('\uf06A'),
    NIGHT_ALT_SNOW('\uf02A'),
    NIGHT_ALT_SNOW_THUNDERSTORM('\uf06D'),
    NIGHT_ALT_SNOW_WIND('\uf067'),
    NIGHT_ALT_SPRINKLE('\uf02B'),
    NIGHT_ALT_STORM_SHOWERS('\uf02C'),
    NIGHT_ALT_THUNDERSTORM('\uf02D'),
    NIGHT_CLEAR('\uf02E'),
    NIGHT_CLOUDY('\uf031'),
    NIGHT_CLOUDY_GUSTS('\uf02F'),
    NIGHT_CLOUDY_HIGH('\uf080'),
    NIGHT_CLOUDY_WINDY('\uf030'),
    NIGHT_FOG('\uf04A'),
    NIGHT_HAIL('\uf032'),
    NIGHT_LIGHTNING('\uf033'),
    NIGHT_PARTLY_CLOUDY('\uf083'),
    NIGHT_RAIN('\uf036'),
    NIGHT_RAIN_MIX('\uf034'),
    NIGHT_RAIN_WIND('\uf035'),
    NIGHT_SHOWERS('\uf037'),
    NIGHT_SLEET('\uf0B3'),
    NIGHT_SLEET_STORM('\uf069'),
    NIGHT_SNOW('\uf038'),
    NIGHT_SNOW_THUNDERSTORM('\uf06C'),
    NIGHT_SNOW_WIND('\uf066'),
    NIGHT_SPRINKLE('\uf039'),
    NIGHT_STORM_SHOWERS('\uf03A'),
    NIGHT_THUNDERSTORM('\uf03B'),
    OWM_200('\uf01E'),
    OWM_201('\uf01E'),
    OWM_202('\uf01E'),
    OWM_210('\uf016'),
    OWM_211('\uf016'),
    OWM_212('\uf016'),
    OWM_221('\uf016'),
    OWM_230('\uf01E'),
    OWM_231('\uf01E'),
    OWM_232('\uf01E'),
    OWM_300('\uf01C'),
    OWM_301('\uf01C'),
    OWM_302('\uf019'),
    OWM_310('\uf017'),
    OWM_311('\uf019'),
    OWM_312('\uf019'),
    OWM_313('\uf01A'),
    OWM_314('\uf019'),
    OWM_321('\uf01C'),
    OWM_500('\uf01C'),
    OWM_501('\uf019'),
    OWM_502('\uf019'),
    OWM_503('\uf019'),
    OWM_504('\uf019'),
    OWM_511('\uf017'),
    OWM_520('\uf01A'),
    OWM_521('\uf01A'),
    OWM_522('\uf01A'),
    OWM_531('\uf01D'),
    OWM_600('\uf01B'),
    OWM_601('\uf01B'),
    OWM_602('\uf0B5'),
    OWM_611('\uf017'),
    OWM_612('\uf017'),
    OWM_615('\uf017'),
    OWM_616('\uf017'),
    OWM_620('\uf017'),
    OWM_621('\uf01B'),
    OWM_622('\uf01B'),
    OWM_701('\uf01A'),
    OWM_711('\uf062'),
    OWM_721('\uf0B6'),
    OWM_731('\uf063'),
    OWM_741('\uf014'),
    OWM_761('\uf063'),
    OWM_762('\uf063'),
    OWM_771('\uf011'),
    OWM_781('\uf056'),
    OWM_800('\uf00D'),
    OWM_801('\uf011'),
    OWM_802('\uf011'),
    OWM_803('\uf012'),
    OWM_804('\uf013'),
    OWM_900('\uf056'),
    OWM_901('\uf01D'),
    OWM_902('\uf073'),
    OWM_903('\uf076'),
    OWM_904('\uf072'),
    OWM_905('\uf021'),
    OWM_906('\uf015'),
    OWM_957('\uf050'),
    OWM_DAY_200('\uf010'),
    OWM_DAY_201('\uf010'),
    OWM_DAY_202('\uf010'),
    OWM_DAY_210('\uf005'),
    OWM_DAY_211('\uf005'),
    OWM_DAY_212('\uf005'),
    OWM_DAY_221('\uf005'),
    OWM_DAY_230('\uf010'),
    OWM_DAY_231('\uf010'),
    OWM_DAY_232('\uf010'),
    OWM_DAY_300('\uf00B'),
    OWM_DAY_301('\uf00B'),
    OWM_DAY_302('\uf008'),
    OWM_DAY_310('\uf008'),
    OWM_DAY_311('\uf008'),
    OWM_DAY_312('\uf008'),
    OWM_DAY_313('\uf008'),
    OWM_DAY_314('\uf008'),
    OWM_DAY_321('\uf00B'),
    OWM_DAY_500('\uf00B'),
    OWM_DAY_501('\uf008'),
    OWM_DAY_502('\uf008'),
    OWM_DAY_503('\uf008'),
    OWM_DAY_504('\uf008'),
    OWM_DAY_511('\uf006'),
    OWM_DAY_520('\uf009'),
    OWM_DAY_521('\uf009'),
    OWM_DAY_522('\uf009'),
    OWM_DAY_531('\uf00E'),
    OWM_DAY_600('\uf00A'),
    OWM_DAY_601('\uf0B2'),
    OWM_DAY_602('\uf00A'),
    OWM_DAY_611('\uf006'),
    OWM_DAY_612('\uf006'),
    OWM_DAY_615('\uf006'),
    OWM_DAY_616('\uf006'),
    OWM_DAY_620('\uf006'),
    OWM_DAY_621('\uf00A'),
    OWM_DAY_622('\uf00A'),
    OWM_DAY_701('\uf009'),
    OWM_DAY_711('\uf062'),
    OWM_DAY_721('\uf0B6'),
    OWM_DAY_731('\uf063'),
    OWM_DAY_741('\uf003'),
    OWM_DAY_761('\uf063'),
    OWM_DAY_762('\uf063'),
    OWM_DAY_781('\uf056'),
    OWM_DAY_800('\uf00D'),
    OWM_DAY_801('\uf000'),
    OWM_DAY_802('\uf000'),
    OWM_DAY_803('\uf000'),
    OWM_DAY_804('\uf00C'),
    OWM_DAY_900('\uf056'),
    OWM_DAY_902('\uf073'),
    OWM_DAY_903('\uf076'),
    OWM_DAY_904('\uf072'),
    OWM_DAY_906('\uf004'),
    OWM_DAY_957('\uf050'),
    OWM_NIGHT_200('\uf02D'),
    OWM_NIGHT_201('\uf02D'),
    OWM_NIGHT_202('\uf02D'),
    OWM_NIGHT_210('\uf025'),
    OWM_NIGHT_211('\uf025'),
    OWM_NIGHT_212('\uf025'),
    OWM_NIGHT_221('\uf025'),
    OWM_NIGHT_230('\uf02D'),
    OWM_NIGHT_231('\uf02D'),
    OWM_NIGHT_232('\uf02D'),
    OWM_NIGHT_300('\uf02B'),
    OWM_NIGHT_301('\uf02B'),
    OWM_NIGHT_302('\uf028'),
    OWM_NIGHT_310('\uf028'),
    OWM_NIGHT_311('\uf028'),
    OWM_NIGHT_312('\uf028'),
    OWM_NIGHT_313('\uf028'),
    OWM_NIGHT_314('\uf028'),
    OWM_NIGHT_321('\uf02B'),
    OWM_NIGHT_500('\uf02B'),
    OWM_NIGHT_501('\uf028'),
    OWM_NIGHT_502('\uf028'),
    OWM_NIGHT_503('\uf028'),
    OWM_NIGHT_504('\uf028'),
    OWM_NIGHT_511('\uf026'),
    OWM_NIGHT_520('\uf029'),
    OWM_NIGHT_521('\uf029'),
    OWM_NIGHT_522('\uf029'),
    OWM_NIGHT_531('\uf02C'),
    OWM_NIGHT_600('\uf02A'),
    OWM_NIGHT_601('\uf0B4'),
    OWM_NIGHT_602('\uf02A'),
    OWM_NIGHT_611('\uf026'),
    OWM_NIGHT_612('\uf026'),
    OWM_NIGHT_615('\uf026'),
    OWM_NIGHT_616('\uf026'),
    OWM_NIGHT_620('\uf026'),
    OWM_NIGHT_621('\uf02A'),
    OWM_NIGHT_622('\uf02A'),
    OWM_NIGHT_701('\uf029'),
    OWM_NIGHT_711('\uf062'),
    OWM_NIGHT_721('\uf0B6'),
    OWM_NIGHT_731('\uf063'),
    OWM_NIGHT_741('\uf04A'),
    OWM_NIGHT_761('\uf063'),
    OWM_NIGHT_762('\uf063'),
    OWM_NIGHT_781('\uf056'),
    OWM_NIGHT_800('\uf02E'),
    OWM_NIGHT_801('\uf022'),
    OWM_NIGHT_802('\uf022'),
    OWM_NIGHT_803('\uf022'),
    OWM_NIGHT_804('\uf086'),
    OWM_NIGHT_900('\uf056'),
    OWM_NIGHT_902('\uf073'),
    OWM_NIGHT_903('\uf076'),
    OWM_NIGHT_904('\uf072'),
    OWM_NIGHT_906('\uf024'),
    OWM_NIGHT_957('\uf050'),
    RAIN('\uf019'),
    RAIN_MIX('\uf017'),
    RAIN_WIND('\uf018'),
    RAINDROP('\uf078'),
    RAINDROPS('\uf04E'),
    REFRESH('\uf04C'),
    REFRESH_ALT('\uf04B'),
    SANDSTORM('\uf082'),
    SHOWERS('\uf01A'),
    SLEET('\uf0B5'),
    SMALL_CRAFT_ADVISORY('\uf0CC'),
    SMOG('\uf074'),
    SMOKE('\uf062'),
    SNOW('\uf01B'),
    SNOW_WIND('\uf064'),
    SNOWFLAKE_COLD('\uf076'),
    SOLAR_ECLIPSE('\uf06E'),
    SPRINKLE('\uf01C'),
    STARS('\uf077'),
    STORM_SHOWERS('\uf01D'),
    STORM_WARNING('\uf0CE'),
    STRONG_WIND('\uf050'),
    SUNRISE('\uf051'),
    SUNSET('\uf052'),
    THERMOMETER('\uf055'),
    THERMOMETER_EXTERIOR('\uf053'),
    THERMOMETER_INTERNAL('\uf054'),
    THUNDERSTORM('\uf01E'),
    TIME_1('\uf08A'),
    TIME_10('\uf093'),
    TIME_11('\uf094'),
    TIME_12('\uf089'),
    TIME_2('\uf08B'),
    TIME_3('\uf08C'),
    TIME_4('\uf08D'),
    TIME_5('\uf08E'),
    TIME_6('\uf08F'),
    TIME_7('\uf090'),
    TIME_8('\uf091'),
    TIME_9('\uf092'),
    TORNADO('\uf056'),
    TRAIN('\uf0CB'),
    TSUNAMI('\uf0C5'),
    UMBRELLA('\uf084'),
    VOLCANO('\uf0C8'),
    WIND_BEAUFORT_0('\uf0B7'),
    WIND_BEAUFORT_1('\uf0B8'),
    WIND_BEAUFORT_10('\uf0C1'),
    WIND_BEAUFORT_11('\uf0C2'),
    WIND_BEAUFORT_12('\uf0C3'),
    WIND_BEAUFORT_2('\uf0B9'),
    WIND_BEAUFORT_3('\uf0BA'),
    WIND_BEAUFORT_4('\uf0BB'),
    WIND_BEAUFORT_5('\uf0BC'),
    WIND_BEAUFORT_6('\uf0BD'),
    WIND_BEAUFORT_7('\uf0BE'),
    WIND_BEAUFORT_8('\uf0BF'),
    WIND_BEAUFORT_9('\uf0C0'),
    WIND_DIRECTION('\uf0B1'),
    WINDY('\uf021'),
    WMO4680_00('\uf055'),
    WMO4680_01('\uf013'),
    WMO4680_02('\uf055'),
    WMO4680_03('\uf013'),
    WMO4680_04('\uf014'),
    WMO4680_05('\uf014'),
    WMO4680_0('\uf014'),
    WMO4680_10('\uf014'),
    WMO4680_11('\uf014'),
    WMO4680_12('\uf016'),
    WMO4680_18('\uf050'),
    WMO4680_1('\uf014'),
    WMO4680_20('\uf014'),
    WMO4680_21('\uf017'),
    WMO4680_22('\uf017'),
    WMO4680_23('\uf019'),
    WMO4680_24('\uf01B'),
    WMO4680_25('\uf015'),
    WMO4680_26('\uf01E'),
    WMO4680_27('\uf063'),
    WMO4680_28('\uf063'),
    WMO4680_29('\uf063'),
    WMO4680_2('\uf014'),
    WMO4680_30('\uf014'),
    WMO4680_31('\uf014'),
    WMO4680_32('\uf014'),
    WMO4680_33('\uf014'),
    WMO4680_34('\uf014'),
    WMO4680_35('\uf014'),
    WMO4680_3('\uf017'),
    WMO4680_40('\uf017'),
    WMO4680_41('\uf01C'),
    WMO4680_42('\uf019'),
    WMO4680_43('\uf01C'),
    WMO4680_44('\uf019'),
    WMO4680_45('\uf015'),
    WMO4680_46('\uf015'),
    WMO4680_47('\uf01B'),
    WMO4680_48('\uf01B'),
    WMO4680_4('\uf01C'),
    WMO4680_50('\uf01C'),
    WMO4680_51('\uf01C'),
    WMO4680_52('\uf019'),
    WMO4680_53('\uf019'),
    WMO4680_54('\uf076'),
    WMO4680_55('\uf076'),
    WMO4680_56('\uf076'),
    WMO4680_57('\uf01C'),
    WMO4680_58('\uf019'),
    WMO4680_5('\uf01C'),
    WMO4680_60('\uf01C'),
    WMO4680_61('\uf01C'),
    WMO4680_62('\uf019'),
    WMO4680_63('\uf019'),
    WMO4680_64('\uf015'),
    WMO4680_65('\uf015'),
    WMO4680_66('\uf015'),
    WMO4680_67('\uf017'),
    WMO4680_68('\uf017'),
    WMO4680_70('\uf01B'),
    WMO4680_71('\uf01B'),
    WMO4680_72('\uf01B'),
    WMO4680_73('\uf01B'),
    WMO4680_74('\uf076'),
    WMO4680_75('\uf076'),
    WMO4680_76('\uf076'),
    WMO4680_77('\uf01B'),
    WMO4680_78('\uf076'),
    WMO4680_80('\uf019'),
    WMO4680_81('\uf01C'),
    WMO4680_82('\uf019'),
    WMO4680_83('\uf019'),
    WMO4680_84('\uf01D'),
    WMO4680_85('\uf017'),
    WMO4680_86('\uf017'),
    WMO4680_87('\uf017'),
    WMO4680_89('\uf015'),
    WMO4680_90('\uf016'),
    WMO4680_91('\uf01D'),
    WMO4680_92('\uf01E'),
    WMO4680_93('\uf01E'),
    WMO4680_94('\uf016'),
    WMO4680_95('\uf01E'),
    WMO4680_96('\uf01E'),
    WMO4680_99('\uf056'),
    WU_CHANCEFLURRIES('\uf064'),
    WU_CHANCERAIN('\uf019'),
    WU_CHANCESLEAT('\uf0B5'),
    WU_CHANCESNOW('\uf01B'),
    WU_CHANCETSTORMS('\uf01E'),
    WU_CLEAR('\uf00D'),
    WU_CLOUDY('\uf002'),
    WU_FLURRIES('\uf064'),
    WU_HAZY('\uf0B6'),
    WU_MOSTLYCLOUDY('\uf002'),
    WU_MOSTLYSUNNY('\uf00D'),
    WU_PARTLYCLOUDY('\uf002'),
    WU_PARTLYSUNNY('\uf00D'),
    WU_RAIN('\uf01A'),
    WU_SLEAT('\uf0B5'),
    WU_SNOW('\uf01B'),
    WU_SUNNY('\uf00D'),
    WU_TSTORMS('\uf01E'),
    WU_UNKNOWN('\uf00D'),
    YAHOO_0('\uf056'),
    YAHOO_1('\uf00E'),
    YAHOO_10('\uf015'),
    YAHOO_11('\uf01A'),
    YAHOO_12('\uf01A'),
    YAHOO_13('\uf01B'),
    YAHOO_14('\uf00A'),
    YAHOO_15('\uf064'),
    YAHOO_16('\uf01B'),
    YAHOO_17('\uf015'),
    YAHOO_18('\uf017'),
    YAHOO_19('\uf063'),
    YAHOO_2('\uf073'),
    YAHOO_20('\uf014'),
    YAHOO_21('\uf021'),
    YAHOO_22('\uf062'),
    YAHOO_23('\uf050'),
    YAHOO_24('\uf050'),
    YAHOO_25('\uf076'),
    YAHOO_26('\uf013'),
    YAHOO_27('\uf031'),
    YAHOO_28('\uf002'),
    YAHOO_29('\uf031'),
    YAHOO_3('\uf01E'),
    YAHOO_30('\uf002'),
    YAHOO_31('\uf02E'),
    YAHOO_32('\uf00D'),
    YAHOO_3200('\uf077'),
    YAHOO_33('\uf083'),
    YAHOO_34('\uf00C'),
    YAHOO_35('\uf017'),
    YAHOO_36('\uf072'),
    YAHOO_37('\uf00E'),
    YAHOO_38('\uf00E'),
    YAHOO_39('\uf00E'),
    YAHOO_4('\uf01E'),
    YAHOO_40('\uf01A'),
    YAHOO_41('\uf064'),
    YAHOO_42('\uf01B'),
    YAHOO_43('\uf064'),
    YAHOO_44('\uf00C'),
    YAHOO_45('\uf00E'),
    YAHOO_46('\uf01B'),
    YAHOO_47('\uf00E'),
    YAHOO_5('\uf017'),
    YAHOO_6('\uf017'),
    YAHOO_7('\uf017'),
    YAHOO_8('\uf015'),
    YAHOO_9('\uf01A');

    private final char character;

    private WeatherIcon(char character) {
        this.character = character;
    }

    @Override
    public char getChar() {
        return character;
    }

    @Override
    public String unicodeToString() {
        return String.format("\\u%04x", (int) character);
    }

    @Override
    public String characterToString() {
        return Character.toString(character);
    }

    @Override
    public String getFontFamily() {
        return "\'weather icons\'";
    }

}
