/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class GridVectorType
extends RealVectorType {
    public GridVectorType(RealType[] types) throws VisADException {
        this(types, null);
    }

    public GridVectorType(RealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super(types, coord_sys);
        if (types.length != 2 && types.length != 3) {
            throw new TypeException("GridVectorType must be 2-D or 3-D: " + types.length);
        }
        for (int i = 0; i < types.length; ++i) {
            if (Unit.canConvert(CommonUnit.meterPerSecond, types[i].getDefaultUnit())) continue;
            throw new TypeException("GridVectorType components must be convertable with meter / second: " + types[i].getDefaultUnit());
        }
    }

    public double[][] transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, ErrorEstimate[] errors_in, ErrorEstimate[] errors_out, double[][] inloc, double[][] outloc, double[][] value) throws VisADException, RemoteException {
        int n = value.length;
        double[][] new_value = new double[n][];
        if (n > 2) {
            new_value[2] = value[2];
        }
        return new_value;
    }

    public float[][] transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, ErrorEstimate[] errors_in, ErrorEstimate[] errors_out, float[][] inloc, float[][] outloc, float[][] value) throws VisADException, RemoteException {
        int n = value.length;
        float[][] new_value = new float[n][];
        if (n > 2) {
            new_value[2] = value[2];
        }
        return new_value;
    }
}

