/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.ui.IndependentWindow;
import thredds.ui.TextHistoryPane;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.hdf4.H4header;
import ucar.nc2.iosp.hdf4.H4iosp;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Hdf4Table
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted tagTable;
    private JSplitPane split;
    private TextHistoryPane dumpTA;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private H4header header;
    private String location;

    public Hdf4Table(PreferencesExt prefs) {
        this.prefs = prefs;
        this.tagTable = new BeanTableSorted(TagBean.class, (PreferencesExt)prefs.node("Hdf4Object"), false);
        this.tagTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TagBean bean = (TagBean)Hdf4Table.this.tagTable.getSelectedBean();
                Hdf4Table.this.dumpTA.setText("Tag=\n ");
                Hdf4Table.this.dumpTA.appendLine(bean.tag.detail());
                Hdf4Table.this.dumpTA.appendLine("\nVinfo=");
                Hdf4Table.this.dumpTA.appendLine(bean.tag.getVinfo());
            }
        });
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.tagTable, this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.tagTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setHdf4File(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
        long start = System.nanoTime();
        ArrayList<TagBean> beanList = new ArrayList<TagBean>();
        H4iosp iosp = new H4iosp();
        MyNetcdfFile ncfile = new MyNetcdfFile(iosp);
        try {
            iosp.open(raf, ncfile, null);
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(20000);
            PrintStream s = new PrintStream(bos);
            t.printStackTrace(s);
            this.dumpTA.setText(bos.toString());
        }
        this.header = (H4header)iosp.sendIospMessage("header");
        for (H4header.Tag tag : this.header.getTags()) {
            beanList.add(new TagBean(tag));
        }
        this.tagTable.setBeans(beanList);
    }

    public void getEosInfo(Formatter f) throws IOException {
        this.header.getEosInfo(f);
    }

    public class TagBean {
        H4header.Tag tag;

        public TagBean() {
        }

        public TagBean(H4header.Tag tag) {
            this.tag = tag;
        }

        public short getCode() {
            return this.tag.getCode();
        }

        public String getType() {
            return this.tag.getType();
        }

        public short getRefno() {
            return this.tag.getRefno();
        }

        public boolean isExtended() {
            return this.tag.isExtended();
        }

        public String getVClass() {
            return this.tag.getVClass();
        }

        public int getOffset() {
            return this.tag.getOffset();
        }

        public int getLength() {
            return this.tag.getLength();
        }

        public boolean isUsed() {
            return this.tag.isUsed();
        }

        public String getVinfo() {
            return this.tag.getVinfo();
        }
    }

    private class MyNetcdfFile
    extends NetcdfFile {
        public MyNetcdfFile(H4iosp iosp) {
            this.spi = iosp;
        }
    }
}

