/******************************************************************************

	error.c -- error handling/printing
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: error.c 223 2011-12-02 10:53:44Z wsl $
	$URL: https://svn.fair.uvt.nl/branches/0.5/src/error.c $

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdarg.h>

#include <avl.h>

#include "error.h"

void error_exit(const char *msg, ...) {
	va_list ap;

	va_start(ap, msg);
	vfprintf(stderr, msg, ap);
	va_end(ap);
	fputc('\n', stderr);
	fflush(stderr);

	exit(1);
}

int eprintf(const char *msg, ...) {
	int r;

	va_list ap;

	va_start(ap, msg);
	r = vfprintf(stderr, msg, ap);
	va_end(ap);
	fflush(stderr);

	return r;
}

int eputs(const char *msg) {
	return eprintf("%s\n", msg);
}

void perror_exit(const char *msg) {
	perror(msg);
	fflush(stderr);
	exit(1);
}

void *xalloc(size_t z) {
	void *r;
	r = malloc(z);
	if(!r)
		syslog_exit(LOG_CRIT, "malloc() failed: %m. Program exit.");
	return memset(r, 'A', z);
}

void *xrealloc(void *r, size_t z) {
	r = realloc(r, z);
	if(!r)
		syslog_exit(LOG_CRIT, "realloc() failed: %m. Program exit.");
	return r;
}

char *xstrdup(const char *s) {
	char *d;

	if(!s)
		syslog_exit(LOG_CRIT, "xstrdup(NULL)\n. Program exit.");

	d = strdup(s);
	if(!d)
		syslog_exit(LOG_CRIT, "strdup() failed\n: %m. Program exit.");

	return d;
}
