#include "echoplugin.h"

EchoPlugin::EchoPlugin(Cordova *cordova): CPlugin(cordova) {
}

void EchoPlugin::echo(int scId, int ecId, const QString &str) {
    Q_UNUSED(ecId)
    this->callback(scId, QString("'%1'").arg(str));
}

Q_DECL_EXPORT QList<QSharedPointer<CPlugin>> cordovaGetPluginInstances(const QList<QString> &pluginNames, Cordova *cordova) {
    QList<QSharedPointer<CPlugin>> res;
    if (pluginNames.contains(EchoPlugin::fullID()))
        res.prepend(QSharedPointer<EchoPlugin>(new EchoPlugin(cordova)));
    return res;
}
