/****************************************************************************
 *    lib/main.cpp - This file is part of coala								*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "main.h"
#include "c/Compiler.h"
#include "b/Compiler.h"
#include "c_taid/compiler.h"

namespace Coala {

Compiler::Compiler() {
	options_ = new CompilerOptions();
}

Compiler::~Compiler() {
	delete options_;
	//delete compiler_; // segfault with from options
}

int Compiler::compile() {
	if(!options_->checkOptions()) {
		throw std::runtime_error("Invalid combination of options set.");
	}
	
	if(options_->getLanguage() == "c" || options_->getLanguage() == "m") {
		compiler_ = new C::Compiler(options_);
	}
	else if(options_->getLanguage() == "b") {
		compiler_ = new B::Compiler(options_);
	}
	else if(options_->getLanguage() == "c_taid") {
		compiler_ = new C_taid::Compiler(options_);
	}
	else {
		throw std::runtime_error("Unknown input language to compile.");
	}
	
	if(options_->getDebug() > 99) {
		cout << "% Options\n";
		cout << "% \n";
		cout << "% Language: " << options_->getLanguage() << "\n";
		cout << "% Debug Level: " << options_->getDebug() << "\n";
		cout << "% Simulated Classical Negation: " << (options_->getFakeClassicalNegation() ? "true" : "false") << "\n";
		cout << "% Direct Encoding: " << (options_->getDirectEncoding() ? "true" : "false") << "\n";
		cout << "% Incremental: " << (options_->getIncremental() ? "true" : "false") << "\n";
		cout << "% Reverse Incremental: " << (options_->getReverseIncremental() ? "true" : "false") << "\n";
		cout << "% Where Check: " << (options_->getWhereCheck() ? "true" : "false") << "\n";
	}
	
	return compiler_->compile();
}

void Compiler::setLanguage(string language) {
	options_->setLanguage(language);
}

void Compiler::setInputStream(istream& inputStream) {
	options_->setInputStream(inputStream);
}

void Compiler::setOutputStream(ostream& outputStream) {
	options_->setOutputStream(outputStream);
}

void Compiler::setFakeClassicalNegation(bool fakeClassicalNegation) {
	options_->setFakeClassicalNegation(fakeClassicalNegation);
}

void Compiler::setDebug(int debug) {
	options_->setDebug(debug);
}

void Compiler::setDirectEncoding(bool directEncoding) {
	options_->setDirectEncoding(directEncoding);
}

void Compiler::setIncremental(bool incremental) {
	options_->setIncremental(incremental);
}

void Compiler::setReverseIncremental(bool reverseIncremental) {
	options_->setReverseIncremental(reverseIncremental);
}

void Compiler::setWhereCheck(bool whereCheck) {
	options_->setWhereCheck(whereCheck);
}


};
