#ifndef H_CDW_WIDGETS
#define H_CDW_WIDGETS

#include <stddef.h> /* size_t */

#include "main.h"
#include "cdw_colors.h"
#include "cdw_ncurses.h"
#include "cdw_dropdown.h"
#include "cdw_button.h"
#include "cdw_checkbox.h"
#include "cdw_input_line.h"
#include "cdw_dialog.h"
#include "cdw_string.h"


/* widget IDs, useful e.g. for selecting constructors
   when building form with many widgets */
#define CDW_WIDGET_LABEL     1
#define CDW_WIDGET_CHECKBOX  2
#define CDW_WIDGET_INPUT     3
#define CDW_WIDGET_DROPDOWN  4
#define CDW_WIDGET_BUTTON    5
#define CDW_WIDGET_TEXT      6 /* like label, but larger, and with special requirements */


/* some widgets have table of return keys - keys on which
   a driver returns control to caller; 20 seems to be reasonable
   limit at this time; there is no guard, widgets have to maintain
   n_return_keys counter */
#define N_RETURN_KEYS_MAX 20




#endif /* ifndef H_CDW_WIDGETS */
