/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include <LO_BCTYPES.H>
#include <TestMCViscBndry.H>

void
MCViscBndry::setBndryConds (const BCRec& bc,
			    int          ratio,
			    int          comp)
{
#if BL_SPACEDIM == 2
    BL_ASSERT(comp<2*2); // u and v, plus derivs of same
#elif BL_SPACEDIM == 3
    BL_ASSERT(comp<3*(3+1)); // u and v, plus derivs of same
#endif

    const REAL* dx = geom.CellSize();
    const BOX& domain = geom.Domain();

    for (OrientationIter fi; fi; ++fi)
    {
	Array<REAL> &bloc = bcloc[fi()];
	Array< Array<BoundCond> >& bctag = bcond[fi()];
	
	int dir = fi().coordDir();
	REAL delta = dx[dir]*ratio;
	int p_bc = (fi().isLow() ? bc.lo(dir): bc.hi(dir));
	
	for (int i = 0; i < boxes().length(); i++)
	{
	    if (domain[fi()] == boxes()[i][fi()] && !geom.isPeriodic(dir))
	    {
		// All physical bc values are located on face
		if (p_bc == EXT_DIR ) {
		    bctag[i][comp] = LO_DIRICHLET;
		    bloc[i] = 0.0;
		} else if (p_bc == FOEXTRAP      ||
			   p_bc == HOEXTRAP      || 
			   p_bc == REFLECT_EVEN)
		{
		    bctag[i][comp] = LO_NEUMANN;
		    bloc[i] = 0.0;
		} else if( p_bc == REFLECT_ODD )
		{
		    bctag[i][comp] = LO_REFLECT_ODD;
		    bloc[i] = 0.0;
		}
	    }
	    else
	    {
		// internal bndry, distance is half of crse
		bctag[i][comp] = LO_DIRICHLET;
		bloc[i] = 0.5*delta;
	    }
	}
    }
}


// *************************************************************************

void
MCViscBndry::setHomogValues()
{
    for (int grd = 0; grd < boxes().length(); grd++)
        for (OrientationIter fi; fi; ++fi)
	    bndry[fi()][grd].setVal(0.);
}
