/*
 * Copyright (c) 2011-2012 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE file for licensing information.
 */
package eu.emi.security.authn.x509.proxy;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import eu.emi.security.authn.x509.X509Credential;


/**
 * Wraps information about a new proxy which was generated by the {@link ProxyGenerator}.
 * 
 * @author K. Benedyczak
 * @see ProxyGenerator
 */
public interface ProxyCertificate
{
	/**
	 * Returns the certificate chain of the proxy.
	 * 
	 * @return the Certificate chain starting with the generated proxy certificate.
	 */
	public X509Certificate[] getCertificateChain();

	/**
	 * Returns the generated private key of this proxy.
	 * 
	 * If public key was manually set an exception is thrown.
	 * 
	 * @return The private key.
	 * @throws IllegalStateException if the private and public keys were not generated
	 */
	public PrivateKey getPrivateKey() throws IllegalStateException;
	
	/**
	 * Returns the X509Credential wrapping the generated private key and proxy certificate.
	 * This method is useful if KeyStore or KeyManager with the newly generated 
	 * proxy certificate is needed.  
	 * @return The generated credential wrapped in {@link X509Credential}
	 * @throws IllegalStateException if the private and public keys were not generated
	 */
	public X509Credential getCredential() throws IllegalStateException;
	
	/**
	 * @return true if private key was generated and is available through 
	 * {@link #getPrivateKey()} and {@link #getCredential()}
	 */
	public boolean hasPrivateKey();
}
