from typing import Any, Callable, Iterable, Text

DEBUG: int
INFO: int
WARN: int
ERROR: int
FATAL: int

class Log:
    def __init__(self, threshold: int = ...) -> None: ...
    def log(self, level: int, msg: Text, *args: Any) -> None: ...
    def debug(self, msg: Text, *args: Any) -> None: ...
    def info(self, msg: Text, *args: Any) -> None: ...
    def warn(self, msg: Text, *args: Any) -> None: ...
    def error(self, msg: Text, *args: Any) -> None: ...
    def fatal(self, msg: Text, *args: Any) -> None: ...

_LogFunc = Callable[[Text, Iterable[Any]], None]

log: Callable[[int, Text, Iterable[Any]], None]
debug: _LogFunc
info: _LogFunc
warn: _LogFunc
error: _LogFunc
fatal: _LogFunc

def set_threshold(level: int) -> int: ...
def set_verbosity(v: int) -> None: ...
