GET_FILENAME_COMPONENT(dir "${CMAKE_CURRENT_LIST_FILE}" PATH)

SET(CMAKE_BACKWARDS_COMPATIBILITY ${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION})

FOREACH(v
  CMAKE_BACKWARDS_COMPATIBILITY
  CMAKE_CTEST_COMMAND
  CMAKE_CURRENT_LIST_FILE
  CMAKE_MAJOR_VERSION
  CMAKE_MINOR_VERSION
  dir
  MCAB_BINARY_DIR
  MCAB_CONFIG
  MCAB_EXECUTABLE_OUTPUT_PATH
  MCAB_GENERATOR
  MCAB_LIBRARY_OUTPUT_PATH
  MCAB_Mummy_64_JUST_BUILD_RUNTIME
  MCAB_Mummy_SNKEYFILE
  MCAB_PROJECT
  MCAB_SCRIPT
  MCAB_SOURCE_DIR
  )
  #MESSAGE("${v}='${${v}}'")
ENDFOREACH(v)

CONFIGURE_FILE(
  "${dir}/ConfigureAndBuild.cmake.in"
  "${MCAB_SCRIPT}"
  @ONLY
  )

EXECUTE_PROCESS(COMMAND ${CMAKE_CTEST_COMMAND}
  -VV -C "${MCAB_CONFIG}" -S "${MCAB_SCRIPT}"
  )
