#!/bin/bash

set -e

VERSION="$2"
DOWNLOADED_FILE="$3"
PACKAGE="$(dpkg-parsechangelog | sed -n 's/^Source: //p')"
TEMPDIR="$(mktemp -d)"
DIR="${PACKAGE}-${VERSION}"

rm -f "$DOWNLOADED_FILE"
svn export "https://svn.java.net/svn/msv~svn/tags/msv-$VERSION" "$TEMPDIR/$DIR"
find "$TEMPDIR/$DIR" -name '*.vsd' -delete
GZIP=--best tar -c -z -f "../${PACKAGE}_$VERSION.orig.tar.gz" -C "$TEMPDIR" "$DIR"
rm -fr "$TEMPDIR"
