/* +---------------------------------------------------------------------------+
   |                     Mobile Robot Programming Toolkit (MRPT)               |
   |                          http://www.mrpt.org/                             |
   |                                                                           |
   | Copyright (c) 2005 2017, Individual contributors, see AUTHORS file        |
   | See: http://www.mrpt.org/Authors - All rights reserved.                   |
   | Released under BSD License. See details in http://www.mrpt.org/License    |
   +---------------------------------------------------------------------------+ */

/** \page maps_observations Maps and observations compatibility matrix
 *

There exists many kinds of metric maps and observations in MRPT, but some operations
involving a map and an observation (for example "inserting" an observation in a map to update it)
only make sense for a small subset of map-observation combinations.

See:
- List of all observations: see derived classes from mrpt::obs::CObservation
- List of all metric maps: see derived classes from mrpt::maps::CMetricMap

## Map-observation compatibility matrix

The following tables summarize the valid combinations, as implemented so far:


### Valid implementations of `insertObservation()`

See: mrpt::maps::CMetricMaps::insertObservation()

| Observations \ Maps (right)                 | mrpt::maps::CBeaconMap | mrpt::maps::CColouredOctoMap | mrpt::maps::CColouredPointsMap | mrpt::maps::CGasConcentrationGridMap2D | mrpt::maps::CHeightGridMap2D | mrpt::maps::CHeightGridMap2D_MRF | mrpt::maps::COccupancyGridMap2D | mrpt::maps::COctoMap | mrpt::maps::CReflectivityGridMap2D | mrpt::maps::CSimplePointsMap | mrpt::maps::CWeightedPointsMap | mrpt::maps::CWirelessPowerGridMap2D |  mrpt::maps::CLandmarksMap   |
|---------------------------------------------|------------------------|------------------------------|--------------------------------|----------------------------------------|------------------------------|----------------------------------|---------------------------------|----------------------|------------------------------------|------------------------------|--------------------------------|-------------------------------------|------------------------------|
| mrpt::obs::CObservation2DRangeScan          |                        |           YES                |            YES                 |                                        |          YES                 |              YES                 |              YES                |        YES           |                                    |           YES                |            YES                 |                                     |                              |
| mrpt::obs::CObservation3DRangeScan          |                        |           YES                |            YES                 |                                        |                              |                                  |                                 |        YES           |                                    |           YES                |            YES                 |                                     |                              |
| mrpt::obs::CObservation6DFeatures           |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationBeaconRanges         |   YES (see [RO-SLAM](http://www.mrpt.org/tutorials/slam-algorithms/rangeonly_slam/)) |          |         |                     |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationBearingRange         |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationGasSensors           |                        |                              |                                |               YES                      |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationGPS                  |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationImage                |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |  YES (Extract SIFT feats)    |
| mrpt::obs::CObservationIMU                  |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationOdometry             |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationRange                |                        |                              |            YES                 |                                        |                              |                                  |            YES                  |                      |                                    |           YES                |           YES                  |                                     |                              |
| mrpt::obs::CObservationReflectivity         |                        |                              |                                |                                        |                              |                                  |                                 |                      |               YES                  |                              |                                |                                     |                              |
| mrpt::obs::CObservationRFID                 |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationRGBD360              |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationRobotPose            |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationStereoImages         |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |  YES (Extract SIFT feats)    |
| mrpt::obs::CObservationStereoImagesFeatures |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |  YES (Append/fuse landmarks) |
| mrpt::obs::CObservationVelodyneScan         |                        |                              |            YES                 |                                        |           YES                |            YES                   |                                 |                      |                                    |           YES                |           YES                  |                                     |                              |
| mrpt::obs::CObservationWindSensor           |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                              |
| mrpt::obs::CObservationWirelessPower        |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |               YES                   |                              |


### Valid implementations of `computeObservationLikelihood()`

See: mrpt::maps::CMetricMaps::computeObservationLikelihood()

| Observations \ Maps (right)                 | mrpt::maps::CBeaconMap | mrpt::maps::CColouredOctoMap | mrpt::maps::CColouredPointsMap | mrpt::maps::CGasConcentrationGridMap2D | mrpt::maps::CHeightGridMap2D | mrpt::maps::CHeightGridMap2D_MRF | mrpt::maps::COccupancyGridMap2D | mrpt::maps::COctoMap | mrpt::maps::CReflectivityGridMap2D | mrpt::maps::CSimplePointsMap | mrpt::maps::CWeightedPointsMap | mrpt::maps::CWirelessPowerGridMap2D |  mrpt::maps::CLandmarksMap       |
|---------------------------------------------|------------------------|------------------------------|--------------------------------|----------------------------------------|------------------------------|----------------------------------|---------------------------------|----------------------|------------------------------------|------------------------------|--------------------------------|-------------------------------------|----------------------------------|
| mrpt::obs::CObservation2DRangeScan          |                        |           YES                |            YES                 |                                        |                              |                                  |             YES                 |       YES            |                                    |           YES                |            YES                 |                                     |          YES                     |
| mrpt::obs::CObservation3DRangeScan          |                        |  YES (must have pointcloud)  |                                |                                        |                              |                                  |                                 |YES (must have pointcloud)|                                |                              |                                |                                     |                                  |
| mrpt::obs::CObservation6DFeatures           |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationBeaconRanges         |  YES (Used for SLAM)   |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     | YES (Used for localization-only) |
| mrpt::obs::CObservationBearingRange         |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationGasSensors           |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationGPS                  |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     | YES (NMEA GGA datum)             |
| mrpt::obs::CObservationImage                |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationIMU                  |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationOdometry             |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationRange                |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationReflectivity         |                        |                              |                                |                                        |                              |                                  |                                 |                      |              YES                   |                              |                                |                                     |                                  |
| mrpt::obs::CObservationRFID                 |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationRGBD360              |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationRobotPose            |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |  YES                             |
| mrpt::obs::CObservationStereoImages         |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |  YES (Convert to SIFT features)  |
| mrpt::obs::CObservationStereoImagesFeatures |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationVelodyneScan         |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationWindSensor           |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |
| mrpt::obs::CObservationWirelessPower        |                        |                              |                                |                                        |                              |                                  |                                 |                      |                                    |                              |                                |                                     |                                  |


*/
