import logging; logger = logging.getLogger("morse." + __name__)
import morse.core.actuator
from morse.helpers.components import add_data

class ExternalForce(morse.core.actuator.Actuator):
    """
    This class will read force and torque as input from an external
    middleware, and applys them to the associated robot in the global
    frame.

    It allows to simulate impact of the environment on the robot, such
    as wind, flow, ...
    """

    _name = "External Force/Torque "
    _short_desc= "Force and torque generated by the environment"

    add_data('force', [0.0, 0.0, 0.0], "vec3<float>", "force along x, y, z")
    add_data('torque', [0.0, 0.0, 0.0], "vec3<float>", "torque around x, y, z")

    def __init__(self, obj, parent=None):
        logger.info('%s initialization' % obj.name)
        morse.core.actuator.Actuator.__init__(self, obj, parent)
        logger.info('Component initialized')

    def default_action(self):
        robot = self.robot_parent.bge_object

        robot.applyForce(self.local_data['force'], False)
        robot.applyTorque(self.local_data['torque'], False)
