// 
// BuildMessagePanel.cs
//  
// Author:
//       Mike Krüger <mkrueger@novell.com>
// 
// Copyright (c) 2009 Novell, Inc (http://www.novell.com)
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

using System;
using MonoDevelop.Core;
using MonoDevelop.Ide.Gui.Dialogs;
using Gtk;

namespace MonoDevelop.Ide.Gui.OptionPanels
{
	
	internal class BuildMessagePanel : OptionsPanel
	{
		BuildMessagePanelWidget widget;

		public override Widget CreatePanelWidget ()
		{
			return widget = new BuildMessagePanelWidget ();
		}

		public override void ApplyChanges ()
		{
			widget.Store ();
		}
	}
	
	[System.ComponentModel.ToolboxItem(true)]
	internal partial class BuildMessagePanelWidget : Gtk.Bin
	{

		public BuildMessagePanelWidget ()
		{
			this.Build ();
			//comboboxJumpToFirst.AppendText (GettextCatalog.GetString ("Never"));
			comboboxJumpToFirst.AppendText (GettextCatalog.GetString ("Error"));
			comboboxJumpToFirst.AppendText (GettextCatalog.GetString ("Error or Warning"));
			comboboxJumpToFirst.Active = (int)IdeApp.Preferences.JumpToFirstErrorOrWarning;
			
	/*		//comboboxBuildResultsDuring.AppendText (GettextCatalog.GetString ("Never"));
			comboboxBuildResultsDuring.AppendText (GettextCatalog.GetString ("Always"));
			comboboxBuildResultsDuring.AppendText (GettextCatalog.GetString ("On Errors"));
			comboboxBuildResultsDuring.AppendText (GettextCatalog.GetString ("On Errors or Warnings"));
			comboboxBuildResultsDuring.Active = (int)IdeApp.Preferences.ShowOutputPadDuringBuild;
			*/
			
		/*	//comboboxErrorPadDuring.AppendText (GettextCatalog.GetString ("Never"));
			comboboxErrorPadDuring.AppendText (GettextCatalog.GetString ("Always"));
			comboboxErrorPadDuring.AppendText (GettextCatalog.GetString ("On Errors"));
			comboboxErrorPadDuring.AppendText (GettextCatalog.GetString ("On Errors or Warnings"));
			comboboxErrorPadDuring.Active = (int)IdeApp.Preferences.ShowErrorPadDuringBuild;
			*/
			//comboboxErrorPadAfter.AppendText (GettextCatalog.GetString ("Never"));
			comboboxErrorPadAfter.AppendText (GettextCatalog.GetString ("Always"));
			comboboxErrorPadAfter.AppendText (GettextCatalog.GetString ("On Errors"));
			comboboxErrorPadAfter.AppendText (GettextCatalog.GetString ("On Errors or Warnings"));
			comboboxErrorPadAfter.Active = (int)IdeApp.Preferences.ShowErrorPadAfterBuild;
			
			//comboboxMessageBubbles.AppendText (GettextCatalog.GetString ("Never"));
			comboboxMessageBubbles.AppendText (GettextCatalog.GetString ("For Errors"));
			comboboxMessageBubbles.AppendText (GettextCatalog.GetString ("For Errors and Warnings"));
			comboboxMessageBubbles.Active = (int)IdeApp.Preferences.ShowMessageBubbles;
			this.QueueResize ();
		}
		
		public void Store ()
		{
			IdeApp.Preferences.JumpToFirstErrorOrWarning = (JumpToFirst)comboboxJumpToFirst.Active;
//			IdeApp.Preferences.ShowErrorPadDuringBuild = (BuildResultStates)comboboxErrorPadDuring.Active;
//			IdeApp.Preferences.ShowOutputPadDuringBuild = (BuildResultStates)comboboxBuildResultsDuring.Active;
			
			IdeApp.Preferences.ShowErrorPadAfterBuild = (BuildResultStates)comboboxErrorPadAfter.Active;
			IdeApp.Preferences.ShowMessageBubbles = (ShowMessageBubbles)comboboxMessageBubbles.Active;
		}
	}
}
