import java.lang.annotation.Annotation;

/*
 * Copyright (c) 2004, Codehaus.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import org.codehaus.modello.plugin.java.AbstractAnnotationsVerifier;

/**
 * @author Brian Demers
 * @version $Id: AnnotationsVerifier.java 1410 2010-02-13 10:29:16Z hboutemy $
 */
public class AnnotationsVerifier
    extends AbstractAnnotationsVerifier
{
    public void verify()
        throws Exception
    {
        assertAnnotations( "class annotation test", model.Group.class.getAnnotations(),
                           javax.xml.bind.annotation.XmlRootElement.class );

        assertAnnotations( "field annotation test", model.Group.class.getDeclaredField( "id" ).getAnnotations(),
                           javax.persistence.Id.class, javax.persistence.SequenceGenerator.class,
                           javax.persistence.GeneratedValue.class, javax.persistence.Column.class );

        assertAnnotations( "interface annotation test", model.SimpleInterface.class.getAnnotations(),
                           javax.xml.bind.annotation.XmlRootElement.class );
    }
}
