/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQContentsWidget_H
#define MvQContentsWidget_H

#include <QModelIndex>
#include <QWidget>

class QAction;
class QLabel;
class QSlider;
class QSpinBox;
class QSplitter;
class QTextBrowser;
class QToolButton;
class QTreeView;

class MvQContentsModel;
class MvQContentsTree;

class Presentable;


class MvQContentsWidget : public QWidget
{
	Q_OBJECT

public:
	MvQContentsWidget(QWidget *parent=0);
	~MvQContentsWidget();
	MvQContentsModel* model() {return model_;}
	void dataIsAboutToChange();
	void reset(Presentable*);
	
public slots:
	void slotShowContextMenu(const QPoint&);

protected:	
	QTreeView *view_;
	MvQContentsModel *model_;
	MvQContentsTree *tree_;
	QMap<QString,QAction*> actions_;
};

#endif

