/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ScrolledText.h


#ifndef ScrolledText_H
#define ScrolledText_H

#include "UIScrolledText.h"
#include "RequestPanelLine.h"

class ScrolledText : public XRequestPanelLine<UIScrolledText_c> {
public:

// -- Contructors

	ScrolledText(RequestPanel&,const Parameter&);

// -- Destructor

	virtual ~ScrolledText(); 

private:

// No copy allowed

	ScrolledText(const ScrolledText&);
	ScrolledText& operator=(const ScrolledText&);

// -- Members
	
	bool changed_;

// -- Overridden methods

	// From XD

	virtual void activateCB(Widget,XtPointer);
	virtual void changedCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void refresh(const vector<string>&);
	virtual void apply();
	virtual void set(Request&);
	virtual void update();

};

#endif
