/*******************************************************************
 * libfaxophone                                                    *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file debug.c
 * \brief Debug message function
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>

static void ( *fopLogHandler )( int nLevel, const char *pnText ) = NULL;

/**
 * \brief Internal debug message function
 * \param nLevel requested message debug level
 * \param pnName function name
 * \param pnFormat string format + parameters
 */
void FopDebugIntern( unsigned char nLevel, const char *pnName, char *pnFormat, ... ) {
	GString *psString = g_string_new( "" );
	va_list args;

	/* Prepend time and function name */
	va_start( args, pnFormat );
	/* Now print message */
	g_string_vprintf( psString, pnFormat, args );
	if ( psString != NULL && psString -> len > 0 ) {
		if ( fopLogHandler != NULL ) {
			fopLogHandler( nLevel, psString -> str );
		} else {
			time_t sTime = time( NULL );
			struct tm *psNow = localtime( &sTime );

			fprintf( stdout, "%02d:%02d:%02d %s(): ", psNow -> tm_hour, psNow -> tm_min, psNow -> tm_sec, pnName );
			fprintf( stdout, "%s", psString -> str );
		}
		g_string_free( psString, TRUE );
	}
	va_end( args );

	/* flush output */
	fflush( stdout );
}

void FopSetLogHandler( void ( *logFunc )( int nLevel, const char *pnText ) ) {
	fopLogHandler = logFunc;
}
