/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribIndexName;
import ucar.grib.GribReadIndex;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grid.GridIndex;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grib2WriteIndex {
    private static boolean debugTiming = false;
    private static boolean verbose = false;
    public static int indexRafBufferSize = 300;
    private static boolean maintainIndexType = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(File grib, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(gribName, "r");
            raf.order(0);
            GridIndex gridIndex = this.writeGribIndex(grib, gbxName, raf, makeIndex);
            return gridIndex;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(File grib, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        boolean success;
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName, false)));
            success = this.writeGribIndex(raf, grib.lastModified(), out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (success && makeIndex) {
            try {
                Thread.sleep(2000L);
                return new GribReadIndex().open(gbxName);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeGribIndex(RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2WriteIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(indexRafBufferSize);
        try {
            inputRaf.seek(0L);
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 8.0");
            sb.append(" grid_edition 2");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            Date baseTime = null;
            List<Grib2Product> products = g2i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    sb.append(" center " + id.getCenter_id());
                    sb.append(" sub_center " + id.getSubcenter_id());
                    sb.append(" table_version " + id.getLocal_table_version());
                    baseTime = product.getBaseTime();
                    sb.append(" basetime " + dateFormat.format(baseTime));
                    sb.append(" ensemble ");
                    sb.append(pds.getPdsVars().isEnsemble() ? "true" : "false");
                    out.writeUTF(sb.toString());
                    out.writeInt(products.size());
                    if (verbose) {
                        System.out.println("Index created with number records =" + products.size());
                    }
                }
                out.writeInt(product.getDiscipline());
                out.writeLong(product.getRefTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getGdsOffset());
                out.writeLong(product.getPdsOffset());
                int length = pds.getPdsVars().getPDSBytes().length;
                out.writeInt(length);
                out.write(pds.getPdsVars().getPDSBytes(), 0, length);
                ++count;
            }
            Map<String, Grib2GridDefinitionSection> gdsHM = g2i.getGDSs();
            Set<String> keys = gdsHM.keySet();
            out.writeInt(keys.size());
            for (String key : keys) {
                Grib2GridDefinitionSection gds = gdsHM.get(key);
                int length = gds.getGdsVars().getGDSBytes().length;
                out.writeInt(length);
                out.write(gds.getGdsVars().getGDSBytes(), 0, length);
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
            boolean bl = false;
            return bl;
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(File grib, File gbx, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(gribName, "r");
            raf.order(0);
            GridIndex gridIndex = this.extendGribIndex(grib, gbx, gbxName, raf, makeIndex);
            return gridIndex;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(File grib, File gbx, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        DataOutputStream out = null;
        boolean success = false;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName + ".tmp", false)));
            success = this.extendGribIndex(gbxName, raf, grib.lastModified(), out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (!success || out.size() == 8) {
            File tidx = new File(gbxName + ".tmp");
            tidx.delete();
            gbx.setLastModified(grib.lastModified() + 1000L);
        } else {
            gbx.delete();
            File tidx = new File(gbxName + ".tmp");
            tidx.renameTo(gbx);
        }
        if (success && makeIndex) {
            try {
                Thread.sleep(2000L);
                return new GribReadIndex().open(gbxName);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extendGribIndex(String gbxName, RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2ExtendIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(indexRafBufferSize);
        try {
            ArrayList<RawRecord> recordList = new ArrayList<RawRecord>();
            HashMap<String, GribGDSVariablesIF> gdsMap = new HashMap<String, GribGDSVariablesIF>();
            boolean newversion = this.rawGridIndex(gbxName, recordList, gdsMap);
            if (newversion) {
                RawRecord rr = (RawRecord)recordList.get(recordList.size() - 1);
                inputRaf.seek(rr.offset2);
            } else {
                inputRaf.seek(0L);
            }
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 8.0");
            sb.append(" grid_edition 2");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            Date baseTime = null;
            List<Grib2Product> products = g2i.getProducts();
            if (products.size() == 0) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    sb.append(" center " + id.getCenter_id());
                    sb.append(" sub_center " + id.getSubcenter_id());
                    sb.append(" table_version " + id.getLocal_table_version());
                    baseTime = product.getBaseTime();
                    sb.append(" basetime " + dateFormat.format(baseTime));
                    sb.append(" ensemble ");
                    sb.append(pds.getPdsVars().isEnsemble() ? "true" : "false");
                    out.writeUTF(sb.toString());
                    out.writeInt(products.size() + recordList.size());
                    if (verbose) {
                        System.out.println("Index extended with old new records " + recordList.size() + "  " + products.size());
                    }
                    for (RawRecord raw : recordList) {
                        out.writeInt(raw.discipline);
                        out.writeLong(raw.refTime);
                        out.writeInt(raw.gdsKey);
                        out.writeLong(raw.offset1);
                        out.writeLong(raw.offset2);
                        out.writeInt(raw.pdsSize);
                        out.write(raw.pdsData, 0, raw.pdsSize);
                    }
                    count = recordList.size();
                }
                out.writeInt(product.getDiscipline());
                out.writeLong(product.getRefTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getGdsOffset());
                out.writeLong(product.getPdsOffset());
                int length = pds.getPdsVars().getPDSBytes().length;
                out.writeInt(length);
                out.write(pds.getPdsVars().getPDSBytes(), 0, length);
                ++count;
            }
            Map<String, Grib2GridDefinitionSection> gdsHM = g2i.getGDSs();
            Set<String> keysHM = gdsHM.keySet();
            for (String key : keysHM) {
                Grib2GridDefinitionSection gds = gdsHM.get(key);
                if (gdsMap.containsKey(key)) continue;
                gdsMap.put(key, gds.getGdsVars());
            }
            out.writeInt(gdsMap.size());
            Set keyAll = gdsMap.keySet();
            for (String key : keyAll) {
                GribGDSVariablesIF gdsv = (GribGDSVariablesIF)gdsMap.get(key);
                int length = gdsv.getGDSBytes().length;
                out.writeInt(length);
                out.write(gdsv.getGDSBytes(), 0, length);
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
            boolean bl = false;
            return bl;
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rawGridIndex(String gbxName, List<RawRecord> recordList, Map<String, GribGDSVariablesIF> gdsMap) throws IOException {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(gbxName)));
            ((DataInputStream)dis).readLong();
            String attributes = ((DataInputStream)dis).readUTF();
            if (attributes.contains("index_version 7")) {
                boolean bl = false;
                return bl;
            }
            boolean grid_edition_2 = attributes.contains("grid_edition 2");
            int number = ((DataInputStream)dis).readInt();
            for (int i = 0; i < number; ++i) {
                RawRecord rr = new RawRecord();
                rr.discipline = ((DataInputStream)dis).readInt();
                rr.refTime = ((DataInputStream)dis).readLong();
                rr.gdsKey = ((DataInputStream)dis).readInt();
                rr.offset1 = ((DataInputStream)dis).readLong();
                rr.offset2 = ((DataInputStream)dis).readLong();
                rr.pdsSize = ((DataInputStream)dis).readInt();
                rr.pdsData = new byte[rr.pdsSize];
                ((DataInputStream)dis).read(rr.pdsData);
                recordList.add(rr);
            }
            number = ((DataInputStream)dis).readInt();
            for (int j = 0; j < number; ++j) {
                GribGDSVariablesIF gdsv;
                int gdsSize = ((DataInputStream)dis).readInt();
                if (gdsSize == 4) {
                    recordList.removeAll(recordList);
                    boolean bl = false;
                    return bl;
                }
                byte[] gdsData = new byte[gdsSize];
                ((DataInputStream)dis).read(gdsData);
                if (grid_edition_2) {
                    gdsv = new Grib2GDSVariables(gdsData);
                    gdsMap.put(Integer.toString(((Grib2GDSVariables)gdsv).getGdsKey()), gdsv);
                    continue;
                }
                gdsv = new Grib1GDSVariables(gdsData);
                gdsMap.put(Integer.toString(((Grib1GDSVariables)gdsv).getGdsKey()), gdsv);
            }
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
        return true;
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> scans for index creation");
        System.out.println("<IndexFile.idx> where to write index, default name + .gbx8");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        verbose = flag;
    }

    public static void main(String[] args) throws IOException {
        Grib2WriteIndex indexer = new Grib2WriteIndex();
        debugTiming = true;
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib2WriteIndex.usage(cl.getName());
            System.exit(0);
        }
        String gribName = args[0];
        File grib = new File(args[0]);
        long rafLastModified = grib.lastModified();
        String gbxName = GribIndexName.getCurrentSuffix(gribName);
        if (args.length == 2) {
            File gbx = new File(gbxName);
            if (gbx.exists() && gbx.lastModified() > rafLastModified) {
                return;
            }
            if (gbx.exists()) {
                indexer.extendGribIndex(grib, gbx, gribName, gbxName, false);
            } else {
                indexer.writeGribIndex(grib, gribName, gbxName, false);
            }
        } else if (args.length == 1) {
            indexer.writeGribIndex(grib, gribName, gbxName, false);
        }
    }

    public class RawRecord {
        public int discipline;
        public long refTime;
        public int gdsKey;
        public long offset1;
        public long offset2;
        public int pdsSize;
        public byte[] pdsData;

        public void RawRecord() {
        }

        public void RawRecord(int discipline, long refTime, int gdsKey, long offset1, long offset2, int pdsSize, byte[] pdsData) {
            this.discipline = discipline;
            this.refTime = refTime;
            this.gdsKey = gdsKey;
            this.offset1 = offset1;
            this.offset2 = offset2;
            this.pdsSize = pdsSize;
            this.pdsData = pdsData;
        }
    }
}

