/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribIndexName;
import ucar.grib.GribNumbers;
import ucar.grib.GribPDSVariablesIF;
import ucar.grib.GribReadTextIndex;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1Grid;
import ucar.grib.grib1.Grib1PDSVariables;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2PDSVariables;
import ucar.grib.grib2.Grib2Tables;
import ucar.grid.GridIndex;

public class GribReadIndex {
    private static Logger log = LoggerFactory.getLogger(GribReadIndex.class);
    private static boolean debugTiming = false;
    private static boolean debugParse = false;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Calendar calendar;

    public GribReadIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        if (ios == null) {
            return null;
        }
        return this.open(location, ios);
    }

    public final GridIndex open(String location, InputStream ios) throws IOException {
        int tpasses = 5;
        for (int pass = 0; pass < tpasses; ++pass) {
            if (pass != 0) {
                ios = new FileInputStream(location);
            }
            long start = System.currentTimeMillis();
            GridIndex gridIndex = null;
            FilterInputStream dis = null;
            try {
                gridIndex = new GridIndex();
                dis = new DataInputStream(new BufferedInputStream(ios));
                long lastModified = ((DataInputStream)dis).readLong();
                if (lastModified == 7597120008394602085L) {
                    dis.close();
                    dis = null;
                    GridIndex gridIndex2 = new GribReadTextIndex().open(location);
                    return gridIndex2;
                }
                Date baseTime = null;
                boolean grid_edition_1 = false;
                String index_version = "";
                int center = 0;
                int sub_center = 0;
                int table_version = 0;
                String line = ((DataInputStream)dis).readUTF();
                if (debugParse) {
                    System.out.println(line);
                }
                String[] split = line.split("\\s");
                for (int i = 0; i < split.length; i += 2) {
                    gridIndex.addGlobalAttribute(split[i], split[i + 1]);
                    if (split[i].equals("basetime")) {
                        baseTime = this.dateFormat.parse(split[i + 1]);
                        continue;
                    }
                    if (split[i].equals("grid_edition")) {
                        grid_edition_1 = split[i + 1].equals("1");
                        continue;
                    }
                    if (split[i].equals("index_version")) {
                        index_version = split[i + 1];
                        if (!index_version.equals("7.1")) continue;
                        File f = new File(location);
                        f.delete();
                        GridIndex gridIndex3 = null;
                        return gridIndex3;
                    }
                    if (split[i].equals("center")) {
                        center = Integer.parseInt(split[i + 1]);
                        continue;
                    }
                    if (split[i].equals("sub_center")) {
                        sub_center = Integer.parseInt(split[i + 1]);
                        continue;
                    }
                    if (!split[i].equals("table_version")) continue;
                    table_version = Integer.parseInt(split[i + 1]);
                }
                int number = ((DataInputStream)dis).readInt();
                for (int i = 0; i < number; ++i) {
                    long refTime;
                    GribGridRecord ggr = new GribGridRecord();
                    if (index_version.equals("7.0")) {
                        ggr.productType = ((DataInputStream)dis).readInt();
                        ggr.discipline = ((DataInputStream)dis).readInt();
                        ggr.category = ((DataInputStream)dis).readInt();
                        ggr.paramNumber = ((DataInputStream)dis).readInt();
                        ggr.typeGenProcess = ((DataInputStream)dis).readInt();
                        ggr.levelType1 = ((DataInputStream)dis).readInt();
                        ggr.levelValue1 = ((DataInputStream)dis).readFloat();
                        ggr.levelType2 = ((DataInputStream)dis).readInt();
                        ggr.levelValue2 = ((DataInputStream)dis).readFloat();
                        refTime = ((DataInputStream)dis).readLong();
                        this.calendar.setTimeInMillis(refTime);
                        ggr.refTime = this.calendar.getTime();
                        ggr.forecastTime = ((DataInputStream)dis).readInt();
                        this.calendar.add(10, ggr.forecastTime);
                        ggr.setValidTime(this.calendar.getTime());
                        ggr.gdsKey = ((DataInputStream)dis).readInt();
                        ggr.offset1 = ((DataInputStream)dis).readLong();
                        ggr.offset2 = ((DataInputStream)dis).readLong();
                        if (grid_edition_1) {
                            ggr.decimalScale = ((DataInputStream)dis).readInt();
                            ggr.bmsExists = ((DataInputStream)dis).readBoolean();
                            ggr.center = ((DataInputStream)dis).readInt();
                            ggr.subCenter = ((DataInputStream)dis).readInt();
                            ggr.table = ((DataInputStream)dis).readInt();
                        }
                    } else {
                        int tunit;
                        GribPDSVariablesIF pdsv;
                        ggr.discipline = ((DataInputStream)dis).readInt();
                        refTime = ((DataInputStream)dis).readLong();
                        this.calendar.setTimeInMillis(refTime);
                        ggr.refTime = this.calendar.getTime();
                        ggr.gdsKey = ((DataInputStream)dis).readInt();
                        ggr.offset1 = ((DataInputStream)dis).readLong();
                        ggr.offset2 = ((DataInputStream)dis).readLong();
                        int pdsSize = ((DataInputStream)dis).readInt();
                        byte[] pdsData = new byte[pdsSize];
                        ((DataInputStream)dis).readFully(pdsData);
                        if (grid_edition_1) {
                            pdsv = new Grib1PDSVariables(pdsData);
                            ggr.productType = ((Grib1PDSVariables)pdsv).getProductDefinition();
                            ggr.category = ((Grib1PDSVariables)pdsv).getParameterCategory();
                            ggr.paramNumber = ((Grib1PDSVariables)pdsv).getParameterNumber();
                            ggr.typeGenProcess = ((Grib1PDSVariables)pdsv).getTypeGenProcess();
                            ggr.levelType1 = ((Grib1PDSVariables)pdsv).getTypeFirstFixedSurface();
                            ggr.levelValue1 = ((Grib1PDSVariables)pdsv).getValueFirstFixedSurface();
                            ggr.levelType2 = ((Grib1PDSVariables)pdsv).getTypeSecondFixedSurface();
                            ggr.levelValue2 = ((Grib1PDSVariables)pdsv).getValueSecondFixedSurface();
                            ggr.forecastTime = ((Grib1PDSVariables)pdsv).getForecastTime();
                            tunit = ((Grib1PDSVariables)pdsv).getTimeRangeUnit();
                            ggr.decimalScale = ((Grib1PDSVariables)pdsv).getDecimalScale();
                            ggr.bmsExists = ((Grib1PDSVariables)pdsv).bmsExists();
                            ggr.center = ((Grib1PDSVariables)pdsv).getCenter();
                            ggr.subCenter = ((Grib1PDSVariables)pdsv).getSubCenter();
                            ggr.table = ((Grib1PDSVariables)pdsv).getTableVersion();
                            if (((Grib1PDSVariables)pdsv).isEnsemble()) {
                                ggr.isEnsemble = true;
                                ggr.type = ((Grib1PDSVariables)pdsv).getType();
                                ggr.ensembleNumber = ((Grib1PDSVariables)pdsv).getEnsembleNumber();
                                ggr.numberForecasts = ((Grib1PDSVariables)pdsv).getNumberForecasts();
                                ggr.lowerLimit = ((Grib1PDSVariables)pdsv).getValueLowerLimit();
                                ggr.upperLimit = ((Grib1PDSVariables)pdsv).getValueUpperLimit();
                            }
                        } else {
                            pdsv = new Grib2PDSVariables(pdsData);
                            ggr.productType = ((Grib2PDSVariables)pdsv).getProductDefinition();
                            if (ggr.productType > 8 && ggr.productType < 16 || ggr.productType == 42 || ggr.productType == 43) {
                                int[] interval = ((Grib2PDSVariables)pdsv).getForecastTimeInterval();
                                ggr.startOfInterval = interval[0];
                                ggr.forecastTime = interval[1];
                            } else {
                                ggr.forecastTime = ((Grib2PDSVariables)pdsv).getForecastTime();
                            }
                            ggr.category = ((Grib2PDSVariables)pdsv).getParameterCategory();
                            ggr.paramNumber = ((Grib2PDSVariables)pdsv).getParameterNumber();
                            ggr.typeGenProcess = ((Grib2PDSVariables)pdsv).getTypeGenProcess();
                            ggr.levelType1 = ((Grib2PDSVariables)pdsv).getTypeFirstFixedSurface();
                            ggr.levelValue1 = ((Grib2PDSVariables)pdsv).getValueFirstFixedSurface();
                            ggr.levelType2 = ((Grib2PDSVariables)pdsv).getTypeSecondFixedSurface();
                            ggr.levelValue2 = ((Grib2PDSVariables)pdsv).getValueSecondFixedSurface();
                            tunit = ((Grib2PDSVariables)pdsv).getTimeRangeUnit();
                            ggr.center = center;
                            ggr.subCenter = sub_center;
                            ggr.table = table_version;
                            if (((Grib2PDSVariables)pdsv).isEnsemble()) {
                                ggr.isEnsemble = true;
                                ggr.type = ((Grib2PDSVariables)pdsv).getType();
                                ggr.ensembleNumber = ((Grib2PDSVariables)pdsv).getPerturbation();
                                ggr.numberForecasts = ((Grib2PDSVariables)pdsv).getNumberForecasts();
                                ggr.lowerLimit = ((Grib2PDSVariables)pdsv).getValueLowerLimit();
                                ggr.upperLimit = ((Grib2PDSVariables)pdsv).getValueUpperLimit();
                            }
                        }
                        if (tunit == 1 || tunit == 10 || tunit == 11 || tunit == 12) {
                            this.calendar.add(10, ggr.forecastTime);
                        } else if (tunit == 2) {
                            this.calendar.add(10, ggr.forecastTime * 24);
                        } else if (tunit == 0) {
                            this.calendar.add(12, ggr.forecastTime);
                        } else if (tunit == 3) {
                            this.calendar.add(2, ggr.forecastTime);
                        } else if (tunit == 13 || tunit == 254) {
                            this.calendar.add(13, ggr.forecastTime * 3600);
                        } else if (tunit == 4) {
                            this.calendar.add(1, ggr.forecastTime);
                        } else if (tunit == 5) {
                            this.calendar.add(1, ggr.forecastTime * 10);
                        } else if (tunit == 6) {
                            this.calendar.add(1, ggr.forecastTime * 30);
                        } else if (tunit == 7) {
                            this.calendar.add(1, ggr.forecastTime * 100);
                        }
                        ggr.setValidTime(this.calendar.getTime());
                        ggr.timeUnit = tunit;
                        if (debugParse) {
                            System.out.println(ggr.productType + " " + ggr.discipline + " " + ggr.category + " " + ggr.paramNumber + " " + ggr.typeGenProcess + " " + ggr.levelType1 + " " + ggr.levelValue1 + " " + ggr.levelType2 + " " + ggr.levelValue2 + " " + this.dateFormat.format(this.calendar.getTime()) + " " + ggr.forecastTime + " " + ggr.gdsKey + " " + ggr.offset1 + " " + ggr.offset2 + " " + ggr.decimalScale + " " + ggr.bmsExists + " " + ggr.center + " " + ggr.subCenter + " " + ggr.table + " " + ggr.type + " " + ggr.numberForecasts + " " + ggr.lowerLimit + " " + ggr.upperLimit);
                        }
                    }
                    gridIndex.addGridRecord(ggr);
                }
                if (index_version.startsWith("7")) {
                    while (!(line = ((DataInputStream)dis).readUTF()).equals("End")) {
                        GribGridDefRecord gds = new GribGridDefRecord(line);
                        gridIndex.addHorizCoordSys(gds);
                    }
                } else {
                    number = ((DataInputStream)dis).readInt();
                    for (int j = 0; j < number; ++j) {
                        GribGridDefRecord ggdr;
                        GribGDSVariablesIF gdsv;
                        int gdsSize = ((DataInputStream)dis).readInt();
                        if (gdsSize == 4) {
                            int gdskey = ((DataInputStream)dis).readInt();
                            GribGridDefRecord ggdr2 = new GribGridDefRecord();
                            Grib1Grid.PopulateGDS(ggdr2, gdskey);
                            gridIndex.addHorizCoordSys(ggdr2);
                            continue;
                        }
                        byte[] gdsData = new byte[gdsSize];
                        ((DataInputStream)dis).readFully(gdsData);
                        if (grid_edition_1) {
                            gdsv = new Grib1GDSVariables(gdsData);
                            ggdr = new GribGridDefRecord(gdsv);
                            int gdskey = index_version.startsWith("8.0") ? ((Grib1GDSVariables)gdsv).get80TypeGdsKey() : ((Grib1GDSVariables)gdsv).getGdsKey();
                            this.Grib1GDS(ggdr, (Grib1GDSVariables)gdsv, gdskey);
                            gridIndex.addHorizCoordSys(ggdr);
                            continue;
                        }
                        gdsv = new Grib2GDSVariables(gdsData);
                        ggdr = new GribGridDefRecord(gdsv);
                        int gdskey = index_version.startsWith("8.0") ? ((Grib2GDSVariables)gdsv).get80TypeGdsKey() : ((Grib2GDSVariables)gdsv).getGdsKey();
                        this.Grib2GDS(ggdr, (Grib2GDSVariables)gdsv, gdskey);
                        gridIndex.addHorizCoordSys(ggdr);
                    }
                }
                if (debugTiming) {
                    long took = System.currentTimeMillis() - start;
                    System.out.println(" Index read " + location + " count=" + gridIndex.getGridCount() + " took=" + took + " msec ");
                }
                log.debug("Binary index read: " + location);
                log.debug("Number Records =" + gridIndex.getGridCount() + " at " + this.dateFormat.format(Calendar.getInstance().getTime()));
                GridIndex gridIndex4 = gridIndex;
                return gridIndex4;
            }
            catch (IOException e) {
                if (pass == tpasses) {
                    String message = "I/O error at record " + gridIndex.getGridCount() + " in index file";
                    throw new IOException(message);
                }
                log.info("open(): rereading index [" + location + "]");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
            catch (ParseException e) {
                log.error("open(): ParseException reading index " + e.getMessage(), e);
                throw new RuntimeException(e);
            }
            finally {
                if (dis != null) {
                    dis.close();
                }
            }
        }
        return null;
    }

    public void Grib2GDS(GribGridDefRecord ggdr, Grib2GDSVariables gdsv, int gdskey) {
        int component_flag;
        int gdtn = gdsv.getGdtn();
        ggdr.addParam("GDSkey", Integer.toString(gdskey));
        ggdr.addParam("grid_type", gdtn);
        ggdr.addParam("grid_name", Grib2Tables.getGridName(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        int n = component_flag = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? 1 : 0;
        if ((gdtn < 50 || gdtn > 53) && gdtn != 100 && gdtn != 120 && gdtn != 1200) {
            int shape = gdsv.getShape();
            ggdr.addParam("grid_shape_code", shape);
            ggdr.addParam("grid_shape", Grib2Tables.getShapeName(shape));
            if (shape < 2 || shape == 6 || shape == 8) {
                ggdr.addParam("grid_radius_spherical_earth", gdsv.getEarthRadius());
            } else if (shape > 1 && shape < 6 || shape == 7) {
                ggdr.addParam("grid_major_axis_earth", gdsv.getMajorAxis());
                ggdr.addParam("grid_minor_axis_earth", gdsv.getMinorAxis());
            }
        }
        if (gdsv.getOlon() == 0) {
            ggdr.addParam("Quasi", "false");
        } else {
            ggdr.addParam("Quasi", "true");
        }
        switch (gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 32768: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 1) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 2) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 3) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 10: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LaD", gdsv.getLaD());
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("BasicAngle", gdsv.getAngle());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 20: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LaD", gdsv.getLaD());
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 30: 
            case 31: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LaD", gdsv.getLaD());
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                ggdr.addParam("Latin1", gdsv.getLatin1());
                ggdr.addParam("Latin2", gdsv.getLatin2());
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                ggdr.addParam("NumberParallels", gdsv.getNp());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 41) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 42) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 43) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("Lap", gdsv.getLap());
                ggdr.addParam("Lop", gdsv.getLop());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("Xp", gdsv.getXp());
                ggdr.addParam("Yp", gdsv.getYp());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                ggdr.addParam("Angle", gdsv.getAngle());
                ggdr.addParam("Nr", gdsv.getNr());
                ggdr.addParam("Xo", gdsv.getXo());
                ggdr.addParam("Yo", gdsv.getYo());
                break;
            }
            case 110: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 204: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("grid_units", "degrees");
                break;
            }
            default: {
                log.warn("\tUnknown Grid Type\t" + gdtn);
            }
        }
    }

    public void Grib1GDS(GribGridDefRecord ggdr, Grib1GDSVariables gdsv, int gdskey) {
        int component_flag;
        int gdtn = gdsv.getGdtn();
        ggdr.addParam("GDSkey", Integer.toString(gdskey));
        ggdr.addParam("grid_type", gdtn);
        ggdr.addParam("grid_name", Grib1Tables.getName(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        int n = component_flag = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? 1 : 0;
        if ((gdtn < 50 || gdtn > 53) && gdtn != 100 && gdtn != 120 && gdtn != 1200) {
            int shape = gdsv.getShape();
            ggdr.addParam("grid_shape_code", shape);
            ggdr.addParam("grid_shape", Grib1Tables.getShapeName(shape));
            if (shape == 0) {
                ggdr.addParam("grid_radius_spherical_earth", gdsv.getEarthRadius());
            } else if (shape == 1) {
                ggdr.addParam("grid_major_axis_earth", gdsv.getMajorAxis());
                ggdr.addParam("grid_minor_axis_earth", gdsv.getMinorAxis());
            }
        }
        switch (gdtn) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 10) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 20) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 30) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 1: 
            case 6: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Latin", gdsv.getLatin1());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 5: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 3: 
            case 13: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("Latin1", gdsv.getLatin1());
                ggdr.addParam("Latin2", gdsv.getLatin2());
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 4: 
            case 14: 
            case 24: 
            case 34: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("NumberParallels", gdsv.getNp());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 14) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 24) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 34) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("Lap", gdsv.getLap());
                ggdr.addParam("Lop", gdsv.getLop());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("Xp", gdsv.getXp());
                ggdr.addParam("Yp", gdsv.getYp());
                ggdr.addParam("Angle", gdsv.getAngle());
                ggdr.addParam("Nr", gdsv.getNr());
                ggdr.addParam("Xo", gdsv.getXo());
                ggdr.addParam("Yo", gdsv.getYo());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 204: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            default: {
                log.error("\tUnknown Grid Type\t" + gdtn);
            }
        }
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        debugParse = flag;
    }

    public static void main(String[] args) throws IOException {
        File gbx = new File(GribIndexName.get("C:/data/NDFD.grib2"));
        if (!gbx.exists()) {
            gbx = new File(GribIndexName.get("/local/robb/data/grib/idd/text/NDFD_CONUS_5km_20090221_1200.grib2"));
        }
        debugParse = true;
        if (args.length < 1) {
            GridIndex index = new GribReadIndex().open(gbx.getPath());
        } else {
            GridIndex index = new GribReadIndex().open(args[0]);
        }
        if (debugTiming) {
            return;
        }
    }
}

