/* $Id$
 *
 * Transform concurrent signal assignment statements into equivalent
 * processes.
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TRANSFORM_SIGASSIGN_HPP_INCLUDED
#define __TRANSFORM_SIGASSIGN_HPP_INCLUDED

#include <list>
#include "frontend/visitor/TopDownVisitor.hpp"

namespace ast {

//! Transform concurrent signal assignments into processes
/** This visitor will transform concurrent signal assignments into
 *  the equivalent process-statements.
 */

class TransformSigAssign : public TopDownVisitor {
public:
	//! c'tor 
	TransformSigAssign() : sensitivities(std::list<SimpleName *>()),
				workList(NULL),
				deleteFlag(false),
				pickupSignals(false) {}

private:
	/** Visit an Architecture node.
	 *  @param node Architecture node that get's visited.
	 */
	virtual void visit(Architecture &node);

	/** Visit a CondalSigAssign node.
	 *  @param node CondalSigAssign node that get's visited.
	 */
	virtual void visit(CondalSigAssign &node);

	/** Visit a SigAssignStat
	 *  @param node SigAssignStat node that gets visited.
	 */
	virtual void visit(SigAssignStat &node);

	/** Visit a WaveFormElem
	 *  @param node WaveFormElem node that gets visited.
	 */
	virtual void visit(WaveFormElem &node);

	/** Visit a SimpleName node.
	 *  @param node TemporaryName node that gets visited.
	 */
	virtual void visit(SimpleName &node);
	
	//! current list of sensitivities
	std::list<SimpleName *> sensitivities;

	//! current traversed list of concurrent statements.
	std::list<ConcurrentStat *> *workList;

	//! delete currently traversed note?
	bool deleteFlag;

	//! pick up signals as sensitivities?
	bool pickupSignals;
};

};

#endif /* __TRANSFORM_SIGASSIGN_HPP_INCLUDED */
