/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.applet.settings;

import info.dolezel.fatrat.applet.settings.SettingsListener;
import java.applet.AppletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class AppletSettings {
    AppletContext context;
    List<SettingsListener> listeners = new ArrayList<SettingsListener>();

    public AppletSettings(AppletContext context) {
        this.context = context;
    }

    public void addListener(SettingsListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SettingsListener l) {
        this.listeners.remove(l);
    }

    public void setStringValue(String key, String value) {
        ByteArrayInputStream bais = null;
        try {
            if (this.context == null) {
                return;
            }
            bais = new ByteArrayInputStream(value.getBytes("UTF-8"));
            this.context.setStream(key, bais);
            this.notifyChange(key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public String getStringValue(String key) {
        try {
            if (this.context == null) {
                return null;
            }
            InputStream is = this.context.getStream(key);
            if (is == null) {
                return null;
            }
            String rv = IOUtils.toString((InputStream)is);
            is.close();
            return rv;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setValue(String key, Object obj) {
        if (this.context == null) {
            return;
        }
        try {
            ObjectOutputStream oos = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.context.setStream(key, bais);
            this.notifyChange(key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object getValue(String key) {
        if (this.context == null) {
            return null;
        }
        try {
            ObjectInputStream ois = null;
            InputStream is = this.context.getStream(key);
            if (is == null) {
                return null;
            }
            ois = new ObjectInputStream(is);
            Object rv = ois.readObject();
            is.close();
            ois.close();
            return rv;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setValue(String key, int i) {
        this.setValue(key, (Object)i);
    }

    public int getValue(String key, int def) {
        Object o = this.getValue(key);
        if (o == null || !(o instanceof Integer)) {
            return def;
        }
        return (Integer)o;
    }

    private void notifyChange(String key) {
        for (SettingsListener l : this.listeners) {
            l.onKeyValueChanged(key);
        }
    }
}

