#if defined(WIN32)
#include <direct.h>
#else
#include <unistd.h>
#endif
#include "getopt.h"

#include <iostream>
#include <fstream>

#include "FileCache.h"
#include "FileStructure.h"
#include "CheckVersion.h"

#define CWDBUFFERLENGTH 1024

void PrintVersion()
{
	std::cout	<< "fastdep v" << FASTDEP_VERSION_MAJOR << "." << FASTDEP_VERSION_MINOR << std::endl
					<< "copyright Bart Vanhauwaert, 2001, 2002" << std::endl
					<< "licensed under the GNU Public License" << std::endl;
}


/*
 * Generate dependencies for all files.
 */
int main(int argc, char **argv)
{
	char cwd_buffer[CWDBUFFERLENGTH+1];
	cwd_buffer[0] = 0;
#if  defined(WIN32)
	_getcwd(cwd_buffer, CWDBUFFERLENGTH);
#else
	getcwd(cwd_buffer, CWDBUFFERLENGTH);
#endif
	FileCache Cache(cwd_buffer);
	Cache.addIncludeDir(cwd_buffer,".");
	std::string RemakeDepTarget;
	std::vector<std::string> ExtraRemakeDeps;
	std::string OutputFilename;
	bool doDebug = false;

	while (1)
	{
		int option_index = 0;
		static struct option long_options[] =
		{
			{"remakedeptarget", 1, 0, 0 },
			{"extraremakedep", 1, 0, 0 },
			{"version", 0, 0, 0 },
			{"stdinclude", 2, 0, 0 },
			{"compile", 1, 0, 0 },
			{"extraincludes", 1, 0, 0},
			{"debug",0,0,0 },
			{"atleastversion",1,0,0 },
			{"objectextension",2 , 0, 0 },
			{0, 0, 0, 0}
		};
		int c = getopt_long(argc,argv,"vI:dqo:O:D:e:",long_options, &option_index);
		if (c==-1)
			break;
		switch (c)
		{
			case 0:
				switch (option_index)
				{
					case 0:
						RemakeDepTarget = std::string(optarg);
						break;
					case 1:
						ExtraRemakeDeps.push_back(std::string(optarg));
						break;
					case 2:
						PrintVersion();
						return 0;
				        case 3:
					  if (optarg)
					    {
					      Cache.addIncludeDir(cwd_buffer, optarg);
					    }
					  else
					    {
					      Cache.addIncludeDir(cwd_buffer, "/usr/include");
					    }
					  break;
                   case 4:
					 Cache.SetCompileCommand( std::string(optarg) );
					 break;
                   case 5:
                     Cache.addIncludeDirFromFile(cwd_buffer, optarg);
                     break;
					case 6:
						doDebug = true;
						break;
					case 7:
						return atLeastVersion(optarg);
						break;
					case 8:
						Cache.SetObjectsExt(optarg);
						break;
				}
				break;
            case 'I':
                Cache.addIncludeDir(cwd_buffer, optarg);
                break;
            case 'O':
                Cache.SetObjectsDir(optarg);
                break;
            case 'e':
                Cache.SetObjectsExt(optarg);
                break;
            case 'v':
                PrintVersion();
                return 0;
            case 'd':
                Cache.SetObjectsShouldNotContainDirectories();
                break;
            case 'q':
                Cache.SetQuietModeOn();
					break;
				case 'o':
					OutputFilename = optarg;
					break;
				case 'D':
					Cache.addPreDefine(optarg);
					break;
		}
	}
#if ! defined (WIN32)
	Cache.addExcludeDir("","/usr/include");
#endif
	if (optind == argc)
	{
		std::cout << "Usage : fastdep filename.c" << std::endl;
		return 0;
	}
	if (doDebug)
		Cache.inDebugMode();
	std::ostream* theStream = &std::cout;
	if (OutputFilename != "")
	{
		theStream = new std::ofstream(OutputFilename.c_str());
		if (RemakeDepTarget == "")
			RemakeDepTarget = OutputFilename;
	}
	for (int i=optind; i<argc; ++i)
		Cache.generate(*theStream, cwd_buffer,argv[i]);
	if (RemakeDepTarget != "")
	{
		*theStream << RemakeDepTarget << ":" << Cache.getAllDependenciesLine();
		for (unsigned int i=0; i<ExtraRemakeDeps.size(); ++i)
			*theStream << " \\\n\t" << ExtraRemakeDeps[i];
		*theStream << std::endl;
	}
	if (OutputFilename != "")
		delete theStream;

	return 0;
}
