/*
 *  Entangle: Tethered Camera Control & Capture
 *
 *  Copyright (C) 2009-2018 Daniel P. Berrangé
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __ENTANGLE_CONTROL_H__
#define __ENTANGLE_CONTROL_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define ENTANGLE_TYPE_CONTROL (entangle_control_get_type())
G_DECLARE_DERIVABLE_TYPE(EntangleControl,
                         entangle_control,
                         ENTANGLE,
                         CONTROL,
                         GObject)

struct _EntangleControlClass
{
    GObjectClass parent_class;
};

EntangleControl *
entangle_control_new(const gchar *path,
                     gint id,
                     const gchar *label,
                     const gchar *info,
                     gboolean readonly);

gint
entangle_control_get_id(EntangleControl *control);
const gchar *
entangle_control_get_path(EntangleControl *control);
const gchar *
entangle_control_get_label(EntangleControl *control);
const gchar *
entangle_control_get_info(EntangleControl *control);

gboolean
entangle_control_get_dirty(EntangleControl *control);
void
entangle_control_set_dirty(EntangleControl *control, gboolean dirty);

gboolean
entangle_control_get_readonly(EntangleControl *control);
void
entangle_control_set_readonly(EntangleControl *control, gboolean ro);

G_END_DECLS

#endif /* __ENTANGLE_CONTROL_H__ */

/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 *  indent-tabs-mode: nil
 *  tab-width: 8
 * End:
 */
