struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 395,
		.content = "Processor\t: ARMv7 Processor rev 0 (v7l)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 \n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x06f\n"
			   "CPU revision\t: 0\n"
			   "\n"
			   "Hardware\t: SAMSUNG JF\n"
			   "Revision\t: 000a\n"
			   "Serial\t\t: 000012a70000ac49\n",
	},
	{
		.path = "/system/build.prop",
		.size = 6846,
		.content = "# begin build properties\n"
			   "# autogenerated by buildinfo.sh\n"
			   "ro.build.id=KOT49H\n"
			   "ro.build.display.id=KOT49H.I337UCUFNC1\n"
			   "ro.build.version.incremental=I337UCUFNC1\n"
			   "ro.build.version.sdk=19\n"
			   "ro.build.version.codename=REL\n"
			   "ro.build.version.release=4.4.2\n"
			   "ro.build.date=Tue Mar 25 13:32:47 KST 2014\n"
			   "ro.build.date.utc=1395721967\n"
			   "ro.build.type=user\n"
			   "ro.build.user=dpi\n"
			   "ro.build.host=SWDD5916\n"
			   "ro.build.tags=release-keys\n"
			   "ro.product.model=SAMSUNG-SGH-I337\n"
			   "ro.product.brand=samsung\n"
			   "ro.product.name=jflteuc\n"
			   "ro.product.device=jflteatt\n"
			   "ro.product.board=MSM8960\n"
			   "ro.product.cpu.abi=armeabi-v7a\n"
			   "ro.product.cpu.abi2=armeabi\n"
			   "ro.product.manufacturer=samsung\n"
			   "ro.product.locale.language=en\n"
			   "ro.product.locale.region=US\n"
			   "ro.wifi.channels=\n"
			   "ro.board.platform=msm8960\n"
			   "# ro.build.product is obsolete; use ro.product.device\n"
			   "ro.build.product=jflteatt\n"
			   "# Do not try to parse ro.build.description or .fingerprint\n"
			   "ro.build.description=jflteuc-user 4.4.2 KOT49H I337UCUFNC1 release-keys\n"
			   "ro.build.fingerprint=samsung/jflteuc/jflteatt:4.4.2/KOT49H/I337UCUFNC1:user/release-keys\n"
			   "ro.build.characteristics=att\n"
			   "# Samsung Specific Properties\n"
			   "ro.build.PDA=I337UCUFNC1\n"
			   "ro.build.hidden_ver=I337UCUFNC1\n"
			   "ro.build.changelist=1125940\n"
			   "ro.product_ship=true\n"
			   "ro.chipname=apq8064\n"
			   "# end build properties\n"
			   "#\n"
			   "# from device/samsung/jflteatt/system.prop\n"
			   "#\n"
			   "#\n"
			   "# system.prop for surf\n"
			   "#\n"
			   "\n"
			   "ro.sf.lcd_density=480\n"
			   "\n"
			   "rild.libpath=/system/lib/libsec-ril.so\n"
			   "rild.libargs=-d /dev/smd0\n"
			   "persist.rild.nitz_plmn=\n"
			   "persist.rild.nitz_long_ons_0=\n"
			   "persist.rild.nitz_long_ons_1=\n"
			   "persist.rild.nitz_long_ons_2=\n"
			   "persist.rild.nitz_long_ons_3=\n"
			   "persist.rild.nitz_short_ons_0=\n"
			   "persist.rild.nitz_short_ons_1=\n"
			   "persist.rild.nitz_short_ons_2=\n"
			   "persist.rild.nitz_short_ons_3=\n"
			   "ril.subscription.types=NV,RUIM\n"
			   "DEVICE_PROVISIONED=1\n"
			   "debug.sf.hw=1\n"
			   "debug.egl.hw=1\n"
			   "debug.composition.type=gpu\n"
			   "dalvik.vm.heapsize=36m\n"
			   "debug.enable.wl_log=1\n"
			   "persist.hwc.mdpcomp.enable=true\n"
			   "debug.mdpcomp.logs=0\n"
			   "\n"
			   "#\n"
			   "# system props for the cne module\n"
			   "#\n"
			   "persist.cne.feature=0\n"
			   "\n"
			   "lpa.decode=false\n"
			   "tunnel.decode=true\n"
			   "tunnel.audiovideo.decode=false\n"
			   "lpa.use-stagefright=true\n"
			   "qcom.hw.aac.encoder=true\n"
			   "\n"
			   "#system props for the MM modules\n"
			   "\n"
			   "media.stagefright.enable-player=true\n"
			   "media.stagefright.enable-http=true\n"
			   "media.stagefright.enable-aac=true\n"
			   "media.stagefright.enable-qcp=true\n"
			   "media.stagefright.enable-fma2dp=true\n"
			   "media.stagefright.enable-scan=true\n"
			   "mmp.enable.3g2=true\n"
			   "media.aac_51_output_enabled=true\n"
			   "#33395 is sum of supported format flags in AAL\n"
			   "#Formats: AVI AC3 ASF AAC QCP DTS 3G2\n"
			   "mm.enable.qcom_parser=33395\n"
			   "\n"
			   "#\n"
			   "# system props for the data modules\n"
			   "#\n"
			   "ro.use_data_netmgrd=true\n"
			   "persist.data.netmgrd.qos.enable=false\n"
			   "\n"
			   "#system props for time-services\n"
			   "persist.timed.enable=true\n"
			   "\n"
			   "# System props for audio\n"
			   "persist.audio.fluence.mode=endfire\n"
			   "persist.audio.vr.enable=false\n"
			   "persist.audio.handset.mic=digital\n"
			   "persist.audio.lowlatency.rec=false\n"
			   "\n"
			   "# System prop to select audio resampler quality\n"
			   "af.resampler.quality=255\n"
			   "# System prop to select MPQAudioPlayer by default on mpq8064\n"
			   "mpq.audio.decode=true\n"
			   "\n"
			   "#\n"
			   "# system prop for opengles version\n"
			   "#\n"
			   "# 196608 is decimal for 0x30000 to report version 3\n"
			   "ro.opengles.version=196608\n"
			   "\n"
			   "# system prop for requesting Master role in incoming Bluetooth connection.\n"
			   "#\n"
			   "ro.bluetooth.request.master=true\n"
			   "#\n"
			   "# system prop for Bluetooth Auto connect for remote initated connections\n"
			   "#\n"
			   "ro.bluetooth.remote.autoconnect=true\n"
			   "# system property for Bluetooth discoverability time out in seconds\n"
			   "# 0: Always discoverable\n"
			   "#debug.bt.discoverable_time=0\n"
			   "\n"
			   "#system prop for switching gps driver to qmi\n"
			   "persist.gps.qmienabled=true\n"
			   "\n"
			   "#System prop to enable ehrpd capability\n"
			   "ro.config.ehrpd=true\n"
			   "\n"
			   "# System property for cabl\n"
			   "ro.qualcomm.cabl=0\n"
			   "\n"
			   "\n"
			   "# System prop for sending transmit power request to RIL during WiFi hotspot on/off\n"
			   "#\n"
			   "ro.ril.transmitpower=true\n"
			   "\n"
			   "\n"
			   "#Simulate sdcard on /data/media\n"
			   "#\n"
			   "persist.fuse_sdcard=true\n"
			   "ro.hwui.text_cache_width=2048\n"
			   "\n"
			   "#\n"
			   "# Supports warmboot capabilities\n"
			   "#\n"
			   "ro.warmboot.capability=1\n"
			   "\n"
			   "#\n"
			   "#snapdragon value add features\n"
			   "#\n"
			   "ro.qc.sdk.audio.ssr=false\n"
			   "##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			   "ro.qc.sdk.audio.fluencetype=none\n"
			   "ro.qc.sdk.camera.facialproc=true\n"
			   "ro.qc.sdk.gestures.camera=false\n"
			   "ro.qc.sdk.sensors.gestures=false\n"
			   "#property to check if dynamic resolution change is  supported in framework\n"
			   "ro.streaming.video.drs=true\n"
			   "#property to enable user to access Google WFD settings.\n"
			   "persist.debug.wfd.enable=1\n"
			   "#property to choose between virtual/external wfd display\n"
			   "persist.sys.wfd.virtual=0\n"
			   "\n"
			   "#system prop for setting rmnet mux mode\n"
			   "persist.rmnet.mux=disabled\n"
			   "\n"
			   "#\n"
			   "# System prop for Tvout/HDMI\n"
			   "#\n"
			   "persist.sys.camera.transform=0\n"
			   "persist.sys.camera.connect=0\n"
			   "persist.sys.videomode=0\n"
			   "ro.hdmi.enable=true\n"
			   "\n"
			   "\n"
			   "# System property for Default Brightness\n"
			   "ro.lcd_min_brightness=10\n"
			   "ro.lcd_brightness=143\n"
			   "\n"
			   "# System proverty for sys info indication\n"
			   "persist.radio.add_power_save=1\n"
			   "\n"
			   "# Keep SIM state on LPM mode\n"
			   "persist.radio.apm_sim_not_pwdn=1\n"
			   "\n"
			   "# use se table when search list\n"
			   "persist.radio.use_se_table_only=1\n"
			   "\n"
			   "# System prop for PLMN\n"
			   "persist.radio.fill_eons=1\n"
			   "\n"
			   "# System prop for SPN\n"
			   "persist.radio.prefer_spn=0\n"
			   "\n"
			   "media.enable-commonsource=true\n"
			   "\n"
			   "#\n"
			   "# ADDITIONAL_BUILD_PROPERTIES\n"
			   "#\n"
			   "dalvik.vm.heapstartsize=8m\n"
			   "dalvik.vm.heapgrowthlimit=128m\n"
			   "dalvik.vm.heapsize=512m\n"
			   "dalvik.vm.heaptargetutilization=0.75\n"
			   "dalvik.vm.heapminfree=2m\n"
			   "dalvik.vm.heapmaxfree=8m\n"
			   "keyguard.no_require_sim=true\n"
			   "ro.com.android.dateformat=MM-dd-yyyy\n"
			   "ro.carrier=unknown\n"
			   "ro.vendor.extension_library=/vendor/lib/libqc-opt.so\n"
			   "ro.build.scafe=americano\n"
			   "ro.build.scafe.size=short\n"
			   "ro.build.scafe.shot=single\n"
			   "ro.hdcp2.rx=tz\n"
			   "ro.secwvk=144\n"
			   "ro.securestorage.support=true\n"
			   "security.mdpp=None\n"
			   "ro.security.mdpp.ver=1.0\n"
			   "ro.security.mdpp.release=2\n"
			   "security.mdpp.result=None\n"
			   "ro.sec.fle.encryption=true\n"
			   "ro.hwui.texture_cache_size=48\n"
			   "ro.hwui.layer_cache_size=32\n"
			   "ro.hwui.path_cache_size=8\n"
			   "ro.hwui.shape_cache_size=2\n"
			   "ro.hwui.gradient_cache_size=1\n"
			   "ro.hwui.drop_shadow_cache_size=4\n"
			   "ro.hwui.texture_cache_flush_rate=0.5\n"
			   "ro.hwui.text_small_cache_width=1024\n"
			   "ro.hwui.text_small_cache_height=512\n"
			   "ro.hwui.text_large_cache_width=2048\n"
			   "ro.hwui.text_large_cache_height=1024\n"
			   "ro.error.receiver.default=com.samsung.receiver.error\n"
			   "ro.config.ringtone=ATT_Firefly_Default.ogg\n"
			   "ro.config.notification_sound=Whisper.ogg\n"
			   "ro.config.alarm_alert=Alarm_Morning_flower.ogg\n"
			   "ro.config.media_sound=Media_preview_Touch_the_light.ogg\n"
			   "ro.security.mdpp.ux=Enabled\n"
			   "ro.setupwizard.mode=OPTIONAL\n"
			   "ro.com.google.clientidbase=android-samsung\n"
			   "ro.com.google.clientidbase.ms=android-att-us\n"
			   "ro.com.google.clientidbase.am=android-att-us\n"
			   "ro.com.google.clientidbase.yt=android-samsung\n"
			   "ro.com.google.clientidbase.gmm=android-samsung\n"
			   "ro.com.google.gmsversion=4.4.2_r1\n"
			   "persist.sys.dalvik.vm.lib=libdvm.so\n"
			   "ro.kernel.qemu=0\n"
			   "ro.build.selinux=1\n"
			   "ro.config.knox=1\n"
			   "ro.config.tima=1\n"
			   "ro.config.timaversion=2.0\n"
			   "net.bt.name=Android\n"
			   "dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			   "ro.qc.sdk.izat.premium_enabled=1\n"
			   "ro.qc.sdk.izat.service_mask=0x5\n"
			   "persist.gps.qc_nlp_in_use=0\n"
			   "ro.gps.agps_provider=1\n"
			   "\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1566000 1674000 1782000 1890000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 147,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 1\n"
			   "1026000 0\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1782000 0\n"
			   "1890000 1125\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1566000 1674000 1782000 1890000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 147,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 0\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1782000 0\n"
			   "1890000 1350\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1566000 1674000 1782000 1890000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 147,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 0\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1782000 0\n"
			   "1890000 1588\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1566000 1674000 1782000 1890000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1890000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 147,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 0\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1782000 0\n"
			   "1890000 1828\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "af.resampler.quality",
		.value = "255",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.composition.type",
		.value = "c2d",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.enable.wl_log",
		.value = "1",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "hw.cabl.version",
		.value = "1.1.20130401",
	},
	{
		.key = "hw.cabl.yuv",
		.value = "0",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.SIDESYNC_service",
		.value = "running",
	},
	{
		.key = "init.svc.TvoutService_C",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.cnd",
		.value = "running",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.container",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.diag_uart_log",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.drsd",
		.value = "running",
	},
	{
		.key = "init.svc.edmaudit",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.icd",
		.value = "stopped",
	},
	{
		.key = "init.svc.immvibed",
		.value = "stopped",
	},
	{
		.key = "init.svc.imsdatadaemon",
		.value = "restarting",
	},
	{
		.key = "init.svc.imsqmidaemon",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.kickstart",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.modem-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "running",
	},
	{
		.key = "init.svc.ppd",
		.value = "running",
	},
	{
		.key = "init.svc.prepare-mobicore",
		.value = "stopped",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qrngd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "stopped",
	},
	{
		.key = "init.svc.rtccd",
		.value = "stopped",
	},
	{
		.key = "init.svc.run-mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.scranton_RD",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "stopped",
	},
	{
		.key = "init.svc.secure_storage",
		.value = "running",
	},
	{
		.key = "init.svc.sensorhubservice",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.ssr_diag",
		.value = "restarting",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.sdcard_manipulate_done",
		.value = "1",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "lpa.decode",
		.value = "false",
	},
	{
		.key = "lpa.use-stagefright",
		.value = "true",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.enable-commonsource",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "33395",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "mpq.audio.decode",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.tcp.buffersize.evdo",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4092,87380,704512,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4092,87380,704512,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4092,87380,704512,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4092,87380,704512,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2560000,262144,524288,1220608",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,704512,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.fluence.mode",
		.value = "endfire",
	},
	{
		.key = "persist.audio.handset.mic",
		.value = "digital",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "4",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "4",
	},
	{
		.key = "persist.audio.lowlatency.rec",
		.value = "false",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "4",
	},
	{
		.key = "persist.audio.vr.enable",
		.value = "false",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "false",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "0",
	},
	{
		.key = "persist.gps.qmienabled",
		.value = "true",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.fill_eons",
		.value = "1",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1",
	},
	{
		.key = "persist.radio.prefer_spn",
		.value = "0",
	},
	{
		.key = "persist.radio.use_se_table_only",
		.value = "1",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.rmnet.mux",
		.value = "disabled",
	},
	{
		.key = "persist.sys.camera.connect",
		.value = "0",
	},
	{
		.key = "persist.sys.camera.transform",
		.value = "0",
	},
	{
		.key = "persist.sys.clssprld1",
		.value = "594",
	},
	{
		.key = "persist.sys.clssprld2",
		.value = "702",
	},
	{
		.key = "persist.sys.country",
		.value = "",
	},
	{
		.key = "persist.sys.dalvik.vm.lib",
		.value = "libdvm.so",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Tue Mar 25 13:32:47 KST 2014",
	},
	{
		.key = "persist.sys.flipfontpath",
		.value = "default",
	},
	{
		.key = "persist.sys.language",
		.value = "",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.videomode",
		.value = "0",
	},
	{
		.key = "persist.sys.wfd.virtual",
		.value = "0",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "qcom.audio.init",
		.value = "complete",
	},
	{
		.key = "qcom.hw.aac.encoder",
		.value = "true",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libsec-ril.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "mdm",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.bluetooth.remote.autoconnect",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.request.master",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8960",
	},
	{
		.key = "ro.boot.baseband",
		.value = "mdm",
	},
	{
		.key = "ro.boot.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "I337UCUFNC1",
	},
	{
		.key = "ro.boot.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.boot.csb_val",
		.value = "1",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.nvdata_backup",
		.value = "0",
	},
	{
		.key = "ro.boot.serialno",
		.value = "12a7ac49",
	},
	{
		.key = "ro.boot.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.bootloader",
		.value = "I337UCUFNC1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "I337UCUFNC1",
	},
	{
		.key = "ro.build.changelist",
		.value = "1125940",
	},
	{
		.key = "ro.build.characteristics",
		.value = "att",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1395721967",
	},
	{
		.key = "ro.build.date",
		.value = "Tue Mar 25 13:32:47 KST 2014",
	},
	{
		.key = "ro.build.description",
		.value = "jflteuc-user 4.4.2 KOT49H I337UCUFNC1 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "KOT49H.I337UCUFNC1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/jflteuc/jflteatt:4.4.2/KOT49H/I337UCUFNC1:user/release-keys",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "I337UCUFNC1",
	},
	{
		.key = "ro.build.host",
		.value = "SWDD5916",
	},
	{
		.key = "ro.build.id",
		.value = "KOT49H",
	},
	{
		.key = "ro.build.product",
		.value = "jflteatt",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "single",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe",
		.value = "americano",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "I337UCUFNC1",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.4.2",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "19",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "apq8064",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "4.4.2_r1",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Alarm_Morning_flower.ogg",
	},
	{
		.key = "ro.config.ehrpd",
		.value = "true",
	},
	{
		.key = "ro.config.knox",
		.value = "1",
	},
	{
		.key = "ro.config.media_sound",
		.value = "Media_preview_Touch_the_light.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Whisper.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "ATT_Firefly_Default.ogg",
	},
	{
		.key = "ro.config.tima",
		.value = "1",
	},
	{
		.key = "ro.config.timaversion",
		.value = "2.0",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.csb_val",
		.value = "1",
	},
	{
		.key = "ro.csc.country_code",
		.value = "USA",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "US",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "ATT",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.emmc",
		.value = "true",
	},
	{
		.key = "ro.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hdcp2.rx",
		.value = "tz",
	},
	{
		.key = "ro.hdmi.enable",
		.value = "true",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.text_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "512",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "48",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.lcd_brightness",
		.value = "143",
	},
	{
		.key = "ro.lcd_min_brightness",
		.value = "10",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.nvdata_backup",
		.value = "0",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.product.board",
		.value = "MSM8960",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.device",
		.value = "jflteatt",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SAMSUNG-SGH-I337",
	},
	{
		.key = "ro.product.name",
		.value = "jflteuc",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "none",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.camera.facialproc",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.gestures.camera",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.izat.premium_enabled",
		.value = "1",
	},
	{
		.key = "ro.qc.sdk.izat.service_mask",
		.value = "0x5",
	},
	{
		.key = "ro.qc.sdk.sensors.gestures",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "0",
	},
	{
		.key = "ro.revision",
		.value = "10",
	},
	{
		.key = "ro.ril.transmitpower",
		.value = "true",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.securestorage.support",
		.value = "true",
	},
	{
		.key = "ro.security.mdpp.release",
		.value = "2",
	},
	{
		.key = "ro.security.mdpp.ux",
		.value = "Enabled",
	},
	{
		.key = "ro.security.mdpp.ver",
		.value = "1.0",
	},
	{
		.key = "ro.secwvk",
		.value = "144",
	},
	{
		.key = "ro.serialno",
		.value = "12a7ac49",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.streaming.video.drs",
		.value = "true",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "/vendor/lib/libqc-opt.so",
	},
	{
		.key = "ro.warmboot.capability",
		.value = "1",
	},
	{
		.key = "ro.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "secmm.player.disabledivx",
		.value = "False",
	},
	{
		.key = "security.mdpp.result",
		.value = "None",
	},
	{
		.key = "security.mdpp",
		.value = "Ready",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "storage.mmc.size",
		.value = "15758000128",
	},
	{
		.key = "sys.ims.QMI_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.mobicoredaemon.enable",
		.value = "true",
	},
	{
		.key = "sys.qseecomd.enable",
		.value = "true",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "tunnel.audiovideo.decode",
		.value = "false",
	},
	{
		.key = "tunnel.decode",
		.value = "true",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{NULL},
};
#endif /* __ANDROID__ */
