/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class Reverser
extends UnaryExpression {
    public Reverser(Expression expression) {
        super(expression);
    }

    public int computeSpecialProperties() {
        int n = this.operand.getSpecialProperties();
        if ((n & 0x40000) != 0) {
            return n & 0xFFFBFFFF | 0x20000;
        }
        if ((n & 0x20000) != 0) {
            return n & 0xFFFDFFFF | 0x40000;
        }
        return n;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.operand = this.doPromotion(this.operand, promotionOffer);
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        if (sequenceIterator instanceof ReversibleIterator) {
            return ((ReversibleIterator)sequenceIterator).getReverseIterator();
        }
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        return sequenceExtent.reverseIterate();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.operand.effectiveBooleanValue(xPathContext);
    }

    protected String displayOperator(Configuration configuration) {
        return "reverse order";
    }
}

