/*
 *  Copyright 2011  Integrated Computer Solutions - http://www.ics.com
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include "media.h"

void Media::newPlayer(int scId, int ecId, const QString &src, int id) {
    Q_UNUSED(scId);
    if (m_id2Player.find(id) != m_id2Player.end()) {
        m_id2Player[id]->stop();
        m_id2Player.remove(id);
    }

    m_id2Player[id] = QSharedPointer<Player>(new Player(ecId, src, this));
}

void Media::playerSetCallbacks(int successCb, int statusCb, QVariantMap p_options) {
    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->setSuccessCb(successCb);
    player->setStatusCb(statusCb);
}

void Media::relasePlayer(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId);
    Q_UNUSED(ecId);
    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    m_id2Player.remove(id);
}

void Media::play(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->play();
}

void Media::pause(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->pause();
}

void Media::stop(int scId, int ecId, QVariantMap p_options){
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->stop();
}

void Media::startRecording(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->startRecording();
}

void Media::stopRecording(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->stopRecording();
}

void Media::getDuration(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    qint64 duration = player->getDuration();
    this->cb(scId, duration);
}

void Media::getCurrentPosition(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(ecId)
    int id = p_options.find("id")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    qint64 position = player->getPosition();
    this->cb(scId, position);
}

void Media::seekTo(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();
    qint64 position = p_options.find("position")->toLongLong();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->seekTo(position);
}

void Media::setVolume(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    int id = p_options.find("id")->toInt();
    int volume = p_options.find("volume")->toInt();

    if (m_id2Player.find(id) == m_id2Player.end())
        return;
    QSharedPointer<Player> player = m_id2Player[id];
    player->setVolume(volume);
}
