;;; snowish-theme.el --- snowish theme

;; Copyright (C) 2001 by Girish Bharadwaj
;; Copyright (C) 2013 by Syohei YOSHIDA

;; Author: Syohei YOSHIDA <syohex@gmail.com>
;; URL: https://github.com/emacs-jp/replace-colorthemes
;; Version: 0.01

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:
;;
;; Port of snowish theme from `color-themes'

;;; Code:

(deftheme snowish
  "snowish theme")

(custom-theme-set-faces
 'snowish

 '(default ((t (:background "snow2" :foreground "darkslategray"))))
 '(mouse ((t (:foreground "black"))))
 '(cursor ((t (:background "Red3"))))
 '(border ((t (:foreground "black"))))

 '(blue ((t (:foreground "blue"))))
 '(bold ((t (:bold t :foreground "peru"))))
 '(bold-italic ((t (:italic t :bold t))))
 '(border-glyph ((t (nil))))
 '(buffers-tab ((t (:background "snow2" :foreground "darkslategray"))))
 '(custom-button-face ((t (:bold t))))
 '(custom-changed-face ((t (:background "blue" :foreground "white"))))
 '(custom-comment-face ((t (:background "gray85"))))
 '(custom-comment-tag-face ((t (:foreground "blue4"))))
 '(custom-documentation-face ((t (nil))))
 '(custom-face-tag-face ((t (:underline t))))
 '(custom-group-tag-face ((t (:underline t :foreground "blue"))))
 '(custom-group-tag-face-1 ((t (:underline t :foreground "red"))))
 '(custom-invalid-face ((t (:background "red" :foreground "yellow"))))
 '(custom-modified-face ((t (:background "blue" :foreground "white"))))
 '(custom-rogue-face ((t (:background "black" :foreground "pink"))))
 '(custom-saved-face ((t (:underline t))))
 '(custom-set-face ((t (:background "white" :foreground "blue"))))
 '(custom-state-face ((t (:foreground "dark green"))))
 '(custom-variable-button-face ((t (:underline t :bold t))))
 '(custom-variable-tag-face ((t (:underline t :foreground "blue"))))
 '(cyan ((t (:foreground "cyan"))))
 '(display-time-mail-balloon-enhance-face ((t (:background "orange"))))
 '(display-time-mail-balloon-gnus-group-face ((t (:foreground "blue"))))
 '(display-time-time-balloon-face ((t (:foreground "red"))))
 '(eshell-ls-archive-face ((t (:bold t :foreground "Orchid"))))
 '(eshell-ls-backup-face ((t (:foreground "OrangeRed"))))
 '(eshell-ls-clutter-face ((t (:bold t :foreground "OrangeRed"))))
 '(eshell-ls-directory-face ((t (:bold t :foreground "Blue"))))
 '(eshell-ls-executable-face ((t (:bold t :foreground "ForestGreen"))))
 '(eshell-ls-missing-face ((t (:bold t :foreground "Red"))))
 '(eshell-ls-product-face ((t (:foreground "OrangeRed"))))
 '(eshell-ls-readonly-face ((t (:foreground "Brown"))))
 '(eshell-ls-special-face ((t (:bold t :foreground "Magenta"))))
 '(eshell-ls-symlink-face ((t (:bold t :foreground "Dark Cyan"))))
 '(eshell-ls-unreadable-face ((t (:foreground "Grey30"))))
 '(eshell-prompt-face ((t (:bold t :foreground "Red"))))
 '(font-lock-builtin-face ((t (:underline t :foreground "blue"))))
 '(font-lock-comment-face ((t (:foreground "snow4"))))
 '(font-lock-constant-face ((t (:foreground "CadetBlue"))))
 '(font-lock-doc-string-face ((t (:foreground "mediumblue"))))
 '(font-lock-function-name-face ((t (:bold t :foreground "darkblue"))))
 '(font-lock-keyword-face ((t (:bold t :foreground "dodgerblue"))))
 '(font-lock-preprocessor-face ((t (:underline t :foreground "blue3"))))
 '(font-lock-reference-face ((t (:foreground "red3"))))
 '(font-lock-string-face ((t (:foreground "darkviolet"))))
 '(font-lock-type-face ((t (:foreground "goldenrod"))))
 '(font-lock-variable-name-face ((t (:foreground "tomato"))))
 '(font-lock-warning-face ((t (:bold t :foreground "Red"))))
 '(gnus-cite-attribution-face ((t (nil))))
 '(gnus-cite-face-1 ((t (:foreground "MidnightBlue"))))
 '(gnus-cite-face-10 ((t (:foreground "medium purple"))))
 '(gnus-cite-face-11 ((t (:foreground "turquoise"))))
 '(gnus-cite-face-2 ((t (:foreground "firebrick"))))
 '(gnus-cite-face-3 ((t (:foreground "dark green"))))
 '(gnus-cite-face-4 ((t (:foreground "OrangeRed"))))
 '(gnus-cite-face-5 ((t (:foreground "dark khaki"))))
 '(gnus-cite-face-6 ((t (:foreground "dark violet"))))
 '(gnus-cite-face-7 ((t (:foreground "SteelBlue4"))))
 '(gnus-cite-face-8 ((t (:foreground "magenta"))))
 '(gnus-cite-face-9 ((t (:foreground "violet"))))
 '(gnus-emphasis-bold ((t (:bold t))))
 '(gnus-emphasis-bold-italic ((t (nil))))
 '(gnus-emphasis-highlight-words ((t (:background "black" :foreground "yellow"))))
 '(gnus-emphasis-italic ((t (nil))))
 '(gnus-emphasis-underline ((t (:underline t))))
 '(gnus-emphasis-underline-bold ((t (:underline t :bold t))))
 '(gnus-emphasis-underline-bold-italic ((t (:underline t))))
 '(gnus-emphasis-underline-italic ((t (:underline t))))
 '(gnus-group-mail-1-empty-face ((t (:foreground "DeepPink3"))))
 '(gnus-group-mail-1-face ((t (:bold t :foreground "DeepPink3"))))
 '(gnus-group-mail-2-empty-face ((t (:foreground "HotPink3"))))
 '(gnus-group-mail-2-face ((t (:bold t :foreground "HotPink3"))))
 '(gnus-group-mail-3-empty-face ((t (:foreground "magenta4"))))
 '(gnus-group-mail-3-face ((t (:bold t :foreground "magenta4"))))
 '(gnus-group-mail-low-empty-face ((t (:foreground "DeepPink4"))))
 '(gnus-group-mail-low-face ((t (:bold t :foreground "DeepPink4"))))
 '(gnus-group-news-1-empty-face ((t (:foreground "ForestGreen"))))
 '(gnus-group-news-1-face ((t (:bold t :foreground "ForestGreen"))))
 '(gnus-group-news-2-empty-face ((t (:foreground "CadetBlue4"))))
 '(gnus-group-news-2-face ((t (:bold t :foreground "CadetBlue4"))))
 '(gnus-group-news-3-empty-face ((t (nil))))
 '(gnus-group-news-3-face ((t (:bold t))))
 '(gnus-group-news-4-empty-face ((t (nil))))
 '(gnus-group-news-4-face ((t (:bold t))))
 '(gnus-group-news-5-empty-face ((t (nil))))
 '(gnus-group-news-5-face ((t (:bold t))))
 '(gnus-group-news-6-empty-face ((t (nil))))
 '(gnus-group-news-6-face ((t (:bold t))))
 '(gnus-group-news-low-empty-face ((t (:foreground "DarkGreen"))))
 '(gnus-group-news-low-face ((t (:bold t :foreground "DarkGreen"))))
 '(gnus-header-content-face ((t (:foreground "indianred4"))))
 '(gnus-header-from-face ((t (:foreground "red3"))))
 '(gnus-header-name-face ((t (:foreground "maroon"))))
 '(gnus-header-newsgroups-face ((t (:foreground "MidnightBlue"))))
 '(gnus-header-subject-face ((t (:foreground "red4"))))
 '(gnus-picons-face ((t (:background "white" :foreground "black"))))
 '(gnus-picons-xbm-face ((t (:background "white" :foreground "black"))))
 '(gnus-signature-face ((t (nil))))
 '(gnus-splash-face ((t (:foreground "Brown"))))
 '(gnus-summary-cancelled-face ((t (:background "black" :foreground "yellow"))))
 '(gnus-summary-high-ancient-face ((t (:bold t :foreground "RoyalBlue"))))
 '(gnus-summary-high-read-face ((t (:bold t :foreground "DarkGreen"))))
 '(gnus-summary-high-ticked-face ((t (:bold t :foreground "firebrick"))))
 '(gnus-summary-high-unread-face ((t (:bold t))))
 '(gnus-summary-low-ancient-face ((t (:foreground "RoyalBlue"))))
 '(gnus-summary-low-read-face ((t (:foreground "DarkGreen"))))
 '(gnus-summary-low-ticked-face ((t (:foreground "firebrick"))))
 '(gnus-summary-low-unread-face ((t (nil))))
 '(gnus-summary-normal-ancient-face ((t (:foreground "RoyalBlue"))))
 '(gnus-summary-normal-read-face ((t (:foreground "DarkGreen"))))
 '(gnus-summary-normal-ticked-face ((t (:foreground "firebrick"))))
 '(gnus-summary-normal-unread-face ((t (nil))))
 '(gnus-summary-selected-face ((t (:underline t))))
 '(gnus-x-face ((t (:background "white" :foreground "black"))))
 '(green ((t (:foreground "green"))))
 '(gui-button-face ((t (:background "grey75" :foreground "black"))))
 '(gui-element ((t (:background "#D4D0C8" :foreground "black"))))
 '(highlight ((t (:background "darkseagreen2"))))
 '(html-helper-bold-face ((t (:bold t))))
 '(html-helper-bold-italic-face ((t (nil))))
 '(html-helper-builtin-face ((t (:underline t :foreground "blue3"))))
 '(html-helper-italic-face ((t (:foreground "medium sea green"))))
 '(html-helper-underline-face ((t (:underline t))))
 '(html-tag-face ((t (:bold t))))
 '(hyper-apropos-documentation ((t (:foreground "darkred"))))
 '(hyper-apropos-heading ((t (:bold t))))
 '(hyper-apropos-hyperlink ((t (:foreground "blue4"))))
 '(hyper-apropos-major-heading ((t (:bold t))))
 '(hyper-apropos-section-heading ((t (nil))))
 '(hyper-apropos-warning ((t (:bold t :foreground "red"))))
 '(info-menu-6 ((t (nil))))
 '(isearch ((t (:background "paleturquoise"))))
 '(isearch-secondary ((t (:foreground "red3"))))
 '(italic ((t (nil))))
 '(jde-bug-breakpoint-cursor ((t (:background "brown" :foreground "cyan"))))
 '(jde-bug-breakpoint-marker ((t (:background "yellow" :foreground "red"))))
 '(jde-java-font-lock-link-face ((t (:underline t :foreground "blue"))))
 '(jde-java-font-lock-number-face ((t (:foreground "RosyBrown"))))
 '(left-margin ((t (nil))))
 '(list-mode-item-selected ((t (:background "gray68" :foreground "darkslategray"))))
 '(magenta ((t (:foreground "magenta"))))
 '(message-cited-text-face ((t (:foreground "red"))))
 '(message-header-cc-face ((t (:foreground "MidnightBlue"))))
 '(message-header-name-face ((t (:foreground "cornflower blue"))))
 '(message-header-newsgroups-face ((t (:foreground "blue4"))))
 '(message-header-other-face ((t (:foreground "steel blue"))))
 '(message-header-subject-face ((t (:bold t :foreground "navy blue"))))
 '(message-header-to-face ((t (:bold t :foreground "MidnightBlue"))))
 '(message-header-xheader-face ((t (:foreground "blue"))))
 '(message-mml-face ((t (:foreground "ForestGreen"))))
 '(message-separator-face ((t (:foreground "brown"))))
 '(modeline ((t (nil))))
 '(modeline-buffer-id ((t (:background "#D4D0C8" :foreground "blue4"))))
 '(modeline-mousable ((t (:background "#D4D0C8" :foreground "firebrick"))))
 '(modeline-mousable-minor-mode ((t (:background "#D4D0C8" :foreground "green4"))))
 '(paren-blink-off ((t (:foreground "snow2"))))
 '(paren-match ((t (:background "darkseagreen2"))))
 '(paren-mismatch ((t (:background "snow2" :foreground "darkslategray"))))
 '(pointer ((t (nil))))
 '(primary-selection ((t (:background "gray65"))))
 '(red ((t (:foreground "red"))))
 '(right-margin ((t (nil))))
 '(secondary-selection ((t (:background "paleturquoise"))))
 '(semantic-intangible-face ((t (:foreground "gray25"))))
 '(semantic-read-only-face ((t (:background "gray25"))))
 '(senator-momentary-highlight-face ((t (:background "gray70"))))
 '(speedbar-button-face ((t (:foreground "green4"))))
 '(speedbar-directory-face ((t (:foreground "blue4"))))
 '(speedbar-file-face ((t (:foreground "cyan4"))))
 '(speedbar-highlight-face ((t (:background "green"))))
 '(speedbar-selected-face ((t (:underline t :foreground "red"))))
 '(speedbar-tag-face ((t (:foreground "brown"))))
 '(template-message-face ((t (:bold t))))
 '(term-blue-bold-face ((t (:bold t :background "snow2" :foreground "blue"))))
 '(term-blue-face ((t (:foreground "blue"))))
 '(term-blue-inv-face ((t (:background "blue"))))
 '(term-blue-ul-face ((t (:underline t :background "snow2" :foreground "blue"))))
 '(term-cyan-bold-face ((t (:bold t :background "snow2" :foreground "cyan"))))
 '(term-cyan-face ((t (:foreground "cyan"))))
 '(term-cyan-inv-face ((t (:background "cyan"))))
 '(term-cyan-ul-face ((t (:underline t :background "snow2" :foreground "cyan"))))
 '(term-default-bold-face ((t (:bold t :background "snow2" :foreground "darkslategray"))))
 '(term-default-face ((t (:background "snow2" :foreground "darkslategray"))))
 '(term-default-inv-face ((t (:background "darkslategray" :foreground "snow2"))))
 '(term-default-ul-face ((t (:underline t :background "snow2" :foreground "darkslategray"))))
 '(term-green-bold-face ((t (:bold t :background "snow2" :foreground "green"))))
 '(term-green-face ((t (:foreground "green"))))
 '(term-green-inv-face ((t (:background "green"))))
 '(term-green-ul-face ((t (:underline t :background "snow2" :foreground "green"))))
 '(term-magenta-bold-face ((t (:bold t :background "snow2" :foreground "magenta"))))
 '(term-magenta-face ((t (:foreground "magenta"))))
 '(term-magenta-inv-face ((t (:background "magenta"))))
 '(term-magenta-ul-face ((t (:underline t :background "snow2" :foreground "magenta"))))
 '(term-red-bold-face ((t (:bold t :background "snow2" :foreground "red"))))
 '(term-red-face ((t (:foreground "red"))))
 '(term-red-inv-face ((t (:background "red"))))
 '(term-red-ul-face ((t (:underline t :background "snow2" :foreground "red"))))
 '(term-white-bold-face ((t (:bold t :background "snow2" :foreground "white"))))
 '(term-white-face ((t (:foreground "white"))))
 '(term-white-inv-face ((t (:background "snow2"))))
 '(term-white-ul-face ((t (:underline t :background "snow2" :foreground "white"))))
 '(term-yellow-bold-face ((t (:bold t :background "snow2" :foreground "yellow"))))
 '(term-yellow-face ((t (:foreground "yellow"))))
 '(term-yellow-inv-face ((t (:background "yellow"))))
 '(term-yellow-ul-face ((t (:underline t :background "snow2" :foreground "yellow"))))
 '(text-cursor ((t (:background "Red3" :foreground "snow2"))))
 '(toolbar ((t (nil))))
 '(underline ((t (:underline t))))
 '(vertical-divider ((t (nil))))
 '(white ((t (:foreground "white"))))
 '(widget ((t (nil))))
 '(widget-button-face ((t (:bold t))))
 '(widget-button-pressed-face ((t (:foreground "red"))))
 '(widget-documentation-face ((t (:foreground "dark green"))))
 '(widget-field-face ((t (:background "gray85"))))
 '(widget-inactive-face ((t (:foreground "dim gray"))))
 '(yellow ((t (:foreground "yellow"))))
 '(zmacs-region ((t (:background "gray65")))))

;;;###autoload
(when load-file-name
  (add-to-list 'custom-theme-load-path
               (file-name-as-directory (file-name-directory load-file-name))))

(provide-theme 'snowish)

;;; snowish-theme.el ends here
